/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.oraclespecific;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.databaseaccess.BindCallCustomParameter;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.platform.database.oracle.TIMESTAMPHelper;
import oracle.toplink.internal.platform.database.oracle.TIMESTAMPLTZWrapper;
import oracle.toplink.internal.platform.database.oracle.TIMESTAMPTZWrapper;
import oracle.toplink.internal.platform.database.oracle.TIMESTAMPTypes;
import oracle.toplink.internal.platform.database.oracle.XMLTypeFactory;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.platform.database.oracle.Oracle8Platform;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.ValueReadQuery;

public class Oracle9Platform
extends Oracle8Platform {
    public static final Class NCHAR = class$oracle$toplink$oraclespecific$NCharacter == null ? (class$oracle$toplink$oraclespecific$NCharacter = Oracle9Platform.class$("oracle.toplink.oraclespecific.NCharacter")) : class$oracle$toplink$oraclespecific$NCharacter;
    public static final Class NSTRING = class$oracle$toplink$oraclespecific$NString == null ? (class$oracle$toplink$oraclespecific$NString = Oracle9Platform.class$("oracle.toplink.oraclespecific.NString")) : class$oracle$toplink$oraclespecific$NString;
    public static final Class NCLOB = class$oracle$toplink$oraclespecific$NClob == null ? (class$oracle$toplink$oraclespecific$NClob = Oracle9Platform.class$("oracle.toplink.oraclespecific.NClob")) : class$oracle$toplink$oraclespecific$NClob;
    public static final Class XMLTYPE = class$oracle$toplink$internal$platform$database$oracle$TopLinkXMLType == null ? (class$oracle$toplink$internal$platform$database$oracle$TopLinkXMLType = Oracle9Platform.class$("oracle.toplink.internal.platform.database.oracle.TopLinkXMLType")) : class$oracle$toplink$internal$platform$database$oracle$TopLinkXMLType;
    private XMLTypeFactory xmlTypeFactory;
    static /* synthetic */ Class class$oracle$toplink$oraclespecific$NCharacter;
    static /* synthetic */ Class class$oracle$toplink$oraclespecific$NString;
    static /* synthetic */ Class class$oracle$toplink$oraclespecific$NClob;
    static /* synthetic */ Class class$oracle$toplink$internal$platform$database$oracle$TopLinkXMLType;
    static /* synthetic */ Class class$org$w3c$dom$Document;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$oracle$sql$TIMESTAMP;
    static /* synthetic */ Class class$oracle$sql$TIMESTAMPTZ;
    static /* synthetic */ Class class$oracle$sql$TIMESTAMPLTZ;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$Ljava$lang$Character;

    public Object getCustomModifyValueForCall(Call call, Object object, DatabaseField databaseField, boolean bl) {
        Class clazz = databaseField.getType();
        if (clazz != null && this.isOracle9Specific(clazz)) {
            if (object == null) {
                return null;
            }
            if (NCHAR.equals(clazz) || NSTRING.equals(clazz)) {
                return new NTypeBindCallCustomParameter(object);
            }
            if (NCLOB.equals(clazz)) {
                object = this.convertToDatabaseType(object);
                if (this.shouldUseLocatorForLOBWrite() && this.lobValueExceedsLimit(object)) {
                    ((DatabaseCall)call).addContext(databaseField, object);
                    object = new String(" ");
                }
                return new NTypeBindCallCustomParameter(object);
            }
            if (XMLTYPE.equals(clazz)) {
                return this.getXMLTypeFactory().createXMLTypeBindCallCustomParameter(object);
            }
        }
        return super.getCustomModifyValueForCall(call, object, databaseField, bl);
    }

    public Object getObjectFromResultSet(ResultSet resultSet, int n, int n2, Session session) throws SQLException {
        if (n2 == 93 || n2 == 91) {
            return resultSet.getTimestamp(n);
        }
        if (n2 == -101) {
            TIMESTAMPTZ tIMESTAMPTZ = (TIMESTAMPTZ)resultSet.getObject(n);
            if (tIMESTAMPTZ != null && tIMESTAMPTZ.getLength() != 0L) {
                tIMESTAMPTZ.timestampValue(this.getConnection(session, resultSet.getStatement().getConnection()));
                return new TIMESTAMPTZWrapper(tIMESTAMPTZ);
            }
            return null;
        }
        if (n2 == -102) {
            TIMESTAMPLTZ tIMESTAMPLTZ = (TIMESTAMPLTZ)resultSet.getObject(n);
            if (tIMESTAMPLTZ != null && tIMESTAMPLTZ.getLength() != 0L) {
                Timestamp timestamp = TIMESTAMPLTZ.toTimestamp((Connection)this.getConnection(session, resultSet.getStatement().getConnection()), (byte[])tIMESTAMPLTZ.toBytes());
                return new TIMESTAMPLTZWrapper(timestamp, ((oracle.jdbc.OracleConnection)this.getConnection(session, resultSet.getStatement().getConnection())).getSessionTimeZone());
            }
            return null;
        }
        if (n2 == 2007) {
            try {
                Object object = resultSet.getObject(n);
                if (!(object instanceof OPAQUE)) {
                    return object;
                }
                return this.getXMLTypeFactory().getDOM((OPAQUE)object);
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException, null, session);
            }
        }
        return resultSet.getObject(n);
    }

    public boolean shouldUseCustomModifyForCall(DatabaseField databaseField) {
        Class clazz = databaseField.getType();
        if (clazz != null && this.isOracle9Specific(clazz)) {
            return true;
        }
        return super.shouldUseCustomModifyForCall(databaseField);
    }

    protected boolean isClob(Class clazz) {
        return NCLOB.equals(clazz) || super.isClob(clazz);
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.extract());
        this.addOperator(ExpressionOperator.extractValue());
        this.addOperator(ExpressionOperator.existsNode());
        this.addOperator(ExpressionOperator.isFragment());
        this.addOperator(ExpressionOperator.getStringVal());
        this.addOperator(ExpressionOperator.getNumberVal());
    }

    protected Hashtable buildFieldTypes() {
        Hashtable hashtable = super.buildFieldTypes();
        hashtable.put(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = Oracle9Platform.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document, new FieldTypeDefinition("sys.XMLType"));
        hashtable.put(class$java$sql$Time == null ? (class$java$sql$Time = Oracle9Platform.class$("java.sql.Time")) : class$java$sql$Time, new FieldTypeDefinition("TIMESTAMP", false));
        hashtable.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Oracle9Platform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new FieldTypeDefinition("TIMESTAMP", false));
        hashtable.put(class$oracle$sql$TIMESTAMP == null ? (class$oracle$sql$TIMESTAMP = Oracle9Platform.class$("oracle.sql.TIMESTAMP")) : class$oracle$sql$TIMESTAMP, new FieldTypeDefinition("TIMESTAMP", false));
        hashtable.put(class$oracle$sql$TIMESTAMPTZ == null ? (class$oracle$sql$TIMESTAMPTZ = Oracle9Platform.class$("oracle.sql.TIMESTAMPTZ")) : class$oracle$sql$TIMESTAMPTZ, new FieldTypeDefinition("TIMESTAMP WITH TIME ZONE", false));
        hashtable.put(class$oracle$sql$TIMESTAMPLTZ == null ? (class$oracle$sql$TIMESTAMPLTZ = Oracle9Platform.class$("oracle.sql.TIMESTAMPLTZ")) : class$oracle$sql$TIMESTAMPLTZ, new FieldTypeDefinition("TIMESTAMP WITH LOCAL TIME ZONE", false));
        return hashtable;
    }

    protected Hashtable buildClassTypes() {
        Hashtable hashtable = super.buildClassTypes();
        hashtable.put("TIMESTAMP", class$oracle$sql$TIMESTAMP == null ? (class$oracle$sql$TIMESTAMP = Oracle9Platform.class$("oracle.sql.TIMESTAMP")) : class$oracle$sql$TIMESTAMP);
        hashtable.put("TIMESTAMP WITH TIME ZONE", class$oracle$sql$TIMESTAMPTZ == null ? (class$oracle$sql$TIMESTAMPTZ = Oracle9Platform.class$("oracle.sql.TIMESTAMPTZ")) : class$oracle$sql$TIMESTAMPTZ);
        hashtable.put("TIMESTAMP WITH LOCAL TIME ZONE", class$oracle$sql$TIMESTAMPLTZ == null ? (class$oracle$sql$TIMESTAMPLTZ = Oracle9Platform.class$("oracle.sql.TIMESTAMPLTZ")) : class$oracle$sql$TIMESTAMPLTZ);
        return hashtable;
    }

    public Object convertObject(Object object, Class clazz) throws ConversionException, DatabaseException {
        if (clazz == null || object != null && object.getClass() == clazz) {
            return object;
        }
        Object object2 = object;
        if (clazz == TIMESTAMPTypes.TIMESTAMP_CLASS || clazz == TIMESTAMPTypes.TIMESTAMPTZ_CLASS || clazz == TIMESTAMPTypes.TIMESTAMPLTZ_CLASS) {
            return object;
        }
        if (clazz == XMLTYPE) {
            return object;
        }
        if (object instanceof TIMESTAMP) {
            try {
                object2 = ((TIMESTAMP)object).timestampValue();
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException);
            }
        } else if (object instanceof TIMESTAMPTZWrapper) {
            if (clazz == ClassConstants.CALENDAR || clazz == ClassConstants.GREGORIAN_CALENDAR) {
                try {
                    return TIMESTAMPHelper.buildCalendar((TIMESTAMPTZWrapper)object);
                }
                catch (SQLException sQLException) {
                    throw DatabaseException.sqlException(sQLException);
                }
            }
            object2 = ((TIMESTAMPTZWrapper)object).getTimestamp();
        } else if (object instanceof TIMESTAMPLTZWrapper) {
            if (clazz == ClassConstants.CALENDAR || clazz == ClassConstants.GREGORIAN_CALENDAR) {
                try {
                    return TIMESTAMPHelper.buildCalendar((TIMESTAMPLTZWrapper)object);
                }
                catch (SQLException sQLException) {
                    throw DatabaseException.sqlException(sQLException);
                }
            }
            object2 = ((TIMESTAMPLTZWrapper)object).getTimestamp();
        }
        return super.convertObject(object2, clazz);
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_timestamp('");
            writer.write(Helper.printTimestamp(timestamp));
            writer.write("','yyyy-mm-dd HH24:MI:SS.FF')");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_timestamp_tz('");
            writer.write(TIMESTAMPHelper.printCalendar(calendar));
            writer.write("','yyyy-mm-dd HH24:MI:SS.FF TZR')");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    public Connection getConnection(Session session, Connection connection) {
        if (session.getServerPlatform() != null && session.getLogin().shouldUseExternalConnectionPooling()) {
            return session.getServerPlatform().unwrapOracleConnection(connection);
        }
        return connection;
    }

    public void setParameterValueInDatabaseCall(Object object, PreparedStatement preparedStatement, int n, Session session) throws SQLException {
        if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            TIMESTAMPTZ tIMESTAMPTZ = TIMESTAMPHelper.buildTIMESTAMPTZ(calendar, this.getConnection(session, preparedStatement.getConnection()));
            preparedStatement.setObject(n, tIMESTAMPTZ);
        } else {
            super.setParameterValueInDatabaseCall(object, preparedStatement, n, session);
        }
    }

    public Timestamp getTimestampFromServer(Session session, String string) {
        if (this.getTimestampQuery() != null) {
            this.getTimestampQuery().setSessionName(string);
            Object object = session.executeQuery(this.getTimestampQuery());
            return ((TIMESTAMPTZWrapper)object).getTimestamp();
        }
        return super.getTimestampFromServer(session, string);
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSTIMESTAMP FROM DUAL");
        }
        return this.timestampQuery;
    }

    public String serverTimestampString() {
        return "SYSTIMESTAMP";
    }

    public Vector getDataTypesConvertedFrom(Class clazz) {
        Vector vector;
        if (this.dataTypesConvertedFromAClass == null) {
            this.dataTypesConvertedFromAClass = new Hashtable(5);
        }
        if ((vector = (Vector)this.dataTypesConvertedFromAClass.get(clazz)) != null) {
            return vector;
        }
        vector = super.getDataTypesConvertedFrom(clazz);
        if (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Oracle9Platform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp) || clazz == (class$java$sql$Time == null ? (class$java$sql$Time = Oracle9Platform.class$("java.sql.Time")) : class$java$sql$Time) || clazz == (class$java$sql$Date == null ? (class$java$sql$Date = Oracle9Platform.class$("java.sql.Date")) : class$java$sql$Date) || clazz == (class$java$util$Date == null ? (class$java$util$Date = Oracle9Platform.class$("java.util.Date")) : class$java$util$Date) || clazz == (class$java$util$Calendar == null ? (class$java$util$Calendar = Oracle9Platform.class$("java.util.Calendar")) : class$java$util$Calendar) || clazz == (class$java$lang$String == null ? (class$java$lang$String = Oracle9Platform.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Oracle9Platform.class$("java.lang.Long")) : class$java$lang$Long)) {
            vector.addElement(class$oracle$sql$TIMESTAMP == null ? (class$oracle$sql$TIMESTAMP = Oracle9Platform.class$("oracle.sql.TIMESTAMP")) : class$oracle$sql$TIMESTAMP);
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Oracle9Platform.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Oracle9Platform.class$("java.lang.Character")) : class$java$lang$Character)) {
            vector.addElement(NCHAR);
            vector.addElement(NSTRING);
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Oracle9Platform.class$("java.lang.String")) : class$java$lang$String)) {
                vector.addElement(NCLOB);
            }
        }
        if (clazz == (array$C == null ? (array$C = Oracle9Platform.class$("[C")) : array$C) || clazz == (array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = Oracle9Platform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character)) {
            vector.addElement(NCLOB);
        }
        this.dataTypesConvertedFromAClass.put(clazz, vector);
        return vector;
    }

    public Vector getDataTypesConvertedTo(Class clazz) {
        Vector vector;
        if (this.dataTypesConvertedToAClass == null) {
            this.dataTypesConvertedToAClass = new Hashtable(5);
        }
        if ((vector = (Vector)this.dataTypesConvertedToAClass.get(clazz)) != null) {
            return vector;
        }
        vector = clazz == (class$oracle$sql$TIMESTAMP == null ? (class$oracle$sql$TIMESTAMP = Oracle9Platform.class$("oracle.sql.TIMESTAMP")) : class$oracle$sql$TIMESTAMP) ? this.buildToTIMESTAMPVec() : (clazz == NCHAR || clazz == NSTRING ? this.buildToNStringCharVec() : (clazz == NCLOB ? this.buildToNClobVec() : super.getDataTypesConvertedTo(clazz)));
        this.dataTypesConvertedToAClass.put(clazz, vector);
        return vector;
    }

    protected Vector buildToTIMESTAMPVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$util$Date == null ? (class$java$util$Date = Oracle9Platform.class$("java.util.Date")) : class$java$util$Date);
        vector.addElement(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Oracle9Platform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        vector.addElement(class$java$util$Calendar == null ? (class$java$util$Calendar = Oracle9Platform.class$("java.util.Calendar")) : class$java$util$Calendar);
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = Oracle9Platform.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = Oracle9Platform.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$sql$Date == null ? (class$java$sql$Date = Oracle9Platform.class$("java.sql.Date")) : class$java$sql$Date);
        vector.addElement(class$java$sql$Time == null ? (class$java$sql$Time = Oracle9Platform.class$("java.sql.Time")) : class$java$sql$Time);
        return vector;
    }

    protected Vector buildToNStringCharVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = Oracle9Platform.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Character == null ? (class$java$lang$Character = Oracle9Platform.class$("java.lang.Character")) : class$java$lang$Character);
        return vector;
    }

    protected Vector buildToNClobVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = Oracle9Platform.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = Oracle9Platform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(array$C == null ? (array$C = Oracle9Platform.class$("[C")) : array$C);
        return vector;
    }

    protected boolean isOracle9Specific(Class clazz) {
        return clazz == NCHAR || clazz == NSTRING || clazz == NCLOB || clazz == XMLTYPE;
    }

    protected XMLTypeFactory getXMLTypeFactory() {
        if (this.xmlTypeFactory == null) {
            String string = "oracle.toplink.internal.platform.database.oracle.xdb.XMLTypeFactoryImpl";
            try {
                Class clazz = PrivilegedAccessController.getClassForName(string);
                Constructor constructor = PrivilegedAccessController.getConstructorFor(clazz, new Class[0], true);
                this.xmlTypeFactory = (XMLTypeFactory)PrivilegedAccessController.invokeConstructor(constructor, new Object[0]);
            }
            catch (Exception exception) {
                throw QueryException.reflectiveCallOnTopLinkClassFailed(string, exception);
            }
        }
        return this.xmlTypeFactory;
    }

    public boolean isXDBDocument(Object object) {
        return this.getXMLTypeFactory().isXDBDocument(object);
    }

    public boolean canUnwrapOracleConnection() {
        return true;
    }

    public Connection unwrapOracleConnection(Connection connection) {
        return ((OracleConnection)connection).getPhysicalConnection();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class NTypeBindCallCustomParameter
    extends BindCallCustomParameter {
        public NTypeBindCallCustomParameter(Object object) {
            super(object);
        }

        public void set(DatabasePlatform databasePlatform, PreparedStatement preparedStatement, int n, Session session) throws SQLException {
            ((OraclePreparedStatement)preparedStatement).setFormOfUse(n, (short)2);
            super.set(databasePlatform, preparedStatement, n, session);
        }
    }
}

