/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings.foundation;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.queryframework.CollectionContainerPolicy;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.queryframework.ListContainerPolicy;
import oracle.toplink.internal.queryframework.MapContainerPolicy;
import oracle.toplink.internal.sessions.AggregateCollectionChangeRecord;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.AggregateMapping;
import oracle.toplink.mappings.ContainerMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.sessions.ObjectCopyingPolicy;

public abstract class AbstractCompositeCollectionMapping
extends AggregateMapping
implements ContainerMapping {
    protected DatabaseField field;
    private ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);

    public Object buildAddedElementFromChangeSet(Object object, MergeManager mergeManager) {
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    protected Object buildBackupClonePart(Object object, UnitOfWork unitOfWork) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object == null) {
            return containerPolicy.containerInstance();
        }
        Object object2 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Object object3 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = super.buildBackupClonePart(containerPolicy.next(object3, unitOfWork), unitOfWork);
            containerPolicy.addInto(object4, object2, unitOfWork);
        }
        return object2;
    }

    public Object buildChangeSet(Object object, ObjectChangeSet objectChangeSet, Session session) {
        ObjectBuilder objectBuilder = this.getObjectBuilder(object, session);
        return objectBuilder.compareForChange(object, null, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), session);
    }

    protected Object buildClonePart(Object object, Object object2, UnitOfWork unitOfWork) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object2 == null) {
            return containerPolicy.containerInstance();
        }
        Object object3 = containerPolicy.containerInstance(containerPolicy.sizeFor(object2));
        Object object4 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = super.buildClonePart(object, containerPolicy.next(object4, unitOfWork), unitOfWork);
            containerPolicy.addInto(object5, object3, unitOfWork);
        }
        return object3;
    }

    protected Object buildCopyOfAttributeValue(Object object, ObjectCopyingPolicy objectCopyingPolicy) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object == null) {
            return containerPolicy.containerInstance();
        }
        Object object2 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Object object3 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = super.buildCopyOfAttributeValue(containerPolicy.next(object3, objectCopyingPolicy.getSession()), objectCopyingPolicy);
            containerPolicy.addInto(object4, object2, objectCopyingPolicy.getSession());
        }
        return object2;
    }

    protected Object buildElementFromChangeSet(Object object, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)object;
        ObjectBuilder objectBuilder = this.getObjectBuilderForClass(objectChangeSet.getClassType(mergeManager.getSession()), mergeManager.getSession());
        Object object2 = objectBuilder.buildNewInstance();
        objectBuilder.mergeChangesIntoObject(object2, objectChangeSet, null, mergeManager);
        return object2;
    }

    public Object buildElementFromElement(Object object, MergeManager mergeManager) {
        ObjectBuilder objectBuilder = this.getObjectBuilder(object, mergeManager.getSession());
        Object object2 = objectBuilder.buildNewInstance();
        objectBuilder.mergeIntoObject(object2, true, object, mergeManager);
        return object2;
    }

    public Object buildRemovedElementFromChangeSet(Object object, MergeManager mergeManager) {
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Object object2 = null;
        object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWork);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.next(object4, unitOfWork);
            if (object5 == null || identityHashtable.contains(object5)) continue;
            identityHashtable.put(object5, object5);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object5.getClass(), (Session)unitOfWork).getObjectBuilder();
            objectBuilder.cascadePerformRemove(object5, unitOfWork, identityHashtable);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Object object2 = null;
        object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            return;
        }
        ObjectBuilder objectBuilder = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWork);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.next(object4, unitOfWork);
            if (object5 == null || identityHashtable.contains(object5)) continue;
            identityHashtable.put(object5, object5);
            objectBuilder = this.getReferenceDescriptor(object5.getClass(), (Session)unitOfWork).getObjectBuilder();
            objectBuilder.cascadeRegisterNewForCreate(object5, unitOfWork, identityHashtable);
        }
    }

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public boolean compareElements(Object object, Object object2, Session session) {
        if (object.getClass() != object2.getClass()) {
            return false;
        }
        return this.getObjectBuilder(object, session).compareObjects(object, object2, session);
    }

    public boolean compareElementsForChange(Object object, Object object2, Session session) {
        return this.compareElements(object, object2, session);
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        Object object3 = null;
        Object object4 = null;
        if (session.isClassReadOnly(this.getReferenceClass())) {
            return null;
        }
        object3 = this.getAttributeValueFromObject(object);
        if (!objectChangeSet.isNew()) {
            object4 = this.getAttributeValueFromObject(object2);
            if (object4 == null && object3 == null) {
                return null;
            }
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object5 = null;
            Object object6 = null;
            object6 = this.getRealCollectionAttributeValueFromObject(object, session);
            object5 = this.getRealCollectionAttributeValueFromObject(object2, session);
            if (containerPolicy.sizeFor(object5) != containerPolicy.sizeFor(object6)) {
                return this.convertToChangeRecord(object6, objectChangeSet, session);
            }
            Object object7 = containerPolicy.iteratorFor(object6);
            Object object8 = containerPolicy.iteratorFor(object5);
            boolean bl = false;
            UnitOfWorkChangeSet unitOfWorkChangeSet = new UnitOfWorkChangeSet();
            while (containerPolicy.hasNext(object7)) {
                Object object9 = containerPolicy.next(object7, session);
                if (object9 == null) {
                    bl = true;
                    break;
                }
                Object object10 = null;
                if (!containerPolicy.hasNext(object8)) {
                    bl = true;
                    break;
                }
                object10 = containerPolicy.next(object8, session);
                if (object9.getClass().equals(object10.getClass())) {
                    ObjectBuilder objectBuilder = this.getReferenceDescriptor(object9.getClass(), session).getObjectBuilder();
                    ObjectChangeSet objectChangeSet2 = objectBuilder.createObjectChangeSet(object9, unitOfWorkChangeSet, objectChangeSet.isNew(), session);
                    ObjectChangeSet objectChangeSet3 = objectBuilder.compareForChange(object9, object10, unitOfWorkChangeSet, session);
                    if (objectChangeSet3 == null) continue;
                    bl = true;
                    break;
                }
                bl = true;
                break;
            }
            if (bl || containerPolicy.hasNext(object8)) {
                return this.convertToChangeRecord(object6, objectChangeSet, session);
            }
            return null;
        }
        return this.convertToChangeRecord(this.getRealCollectionAttributeValueFromObject(object, session), objectChangeSet, session);
    }

    protected ChangeRecord convertToChangeRecord(Object object, ObjectChangeSet objectChangeSet, Session session) {
        Object object2;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = containerPolicy.iteratorFor(object);
        Vector<ObjectChangeSet> vector = new Vector<ObjectChangeSet>(2);
        while (containerPolicy.hasNext(object3)) {
            object2 = containerPolicy.next(object3, session);
            if (object2 == null) continue;
            ObjectChangeSet objectChangeSet2 = this.getReferenceDescriptor(object2.getClass(), session).getObjectBuilder().compareForChange(object2, null, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), session);
            vector.addElement(objectChangeSet2);
        }
        object2 = new AggregateCollectionChangeRecord(objectChangeSet);
        ((ChangeRecord)object2).setAttribute(this.getAttributeName());
        ((ChangeRecord)object2).setMapping(this);
        ((AggregateCollectionChangeRecord)object2).setChangedValues(vector);
        return object2;
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, session);
        Object object4 = this.getRealCollectionAttributeValueFromObject(object2, session);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(object3) != containerPolicy.sizeFor(object4)) {
            return false;
        }
        if (containerPolicy.sizeFor(object3) == 0) {
            return true;
        }
        Object object5 = containerPolicy.iteratorFor(object3);
        Object object6 = containerPolicy.iteratorFor(object4);
        while (containerPolicy.hasNext(object5)) {
            Object object7 = containerPolicy.next(object5, session);
            Object object8 = containerPolicy.next(object6, session);
            if (this.getReferenceDescriptor().getObjectBuilder().compareObjects(object7, object8, session)) continue;
            return false;
        }
        return true;
    }

    protected void fixAttributeValue(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.fixAttributeValue(containerPolicy.next(object2, remoteSession), identityHashtable, identityHashtable2, objectLevelReadQuery, remoteSession);
        }
    }

    protected Object getAttributeValueFromBackupClone(Object object) {
        return null;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public Object getRealCollectionAttributeValueFromObject(Object object, Session session) throws DescriptorException {
        Object object2 = this.getRealAttributeValueFromObject(object, session);
        if (object2 == null) {
            object2 = this.getContainerPolicy().containerInstance(1);
        }
        return object2;
    }

    protected String getStructureName() {
        return "";
    }

    public boolean isAbstractCompositeCollectionMapping() {
        return true;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        this.getDescriptor().buildField(this.getField());
        this.setFields(this.collectFields());
    }

    protected void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.iterateOnAttributeValue(descriptorIterator, containerPolicy.next(object2, descriptorIterator.getSession()));
        }
    }

    public boolean mapKeyHasChanged(Object object, Session session) {
        return false;
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Session session = mergeManager.getSession();
        Object object3 = null;
        Object object4 = null;
        Vector vector = ((AggregateCollectionChangeRecord)changeRecord).getChangedValues();
        object3 = containerPolicy.containerInstance();
        ObjectChangeSet objectChangeSet = null;
        for (int i = 0; i < vector.size(); ++i) {
            objectChangeSet = (ObjectChangeSet)vector.elementAt(i);
            Class clazz = objectChangeSet.getClassType(session);
            object4 = objectChangeSet.getUnitOfWorkClone();
            containerPolicy.addInto(this.buildElementFromChangeSet(objectChangeSet, mergeManager), object3, session);
            Object object5 = ((UnitOfWork)mergeManager.getSession()).getCloneToOriginals().get(object4);
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if (!mergeManager.shouldCascadeReferences()) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = this.getRealCollectionAttributeValueFromObject(object2, mergeManager.getSession());
        Object object4 = containerPolicy.containerInstance(containerPolicy.sizeFor(object3));
        Object object5 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object5)) {
            Object object6 = containerPolicy.next(object5, mergeManager.getSession());
            Object object7 = this.getReferenceDescriptor(object6.getClass(), mergeManager.getSession()).getObjectBuilder().buildNewInstance();
            this.getReferenceDescriptor(object6.getClass(), mergeManager.getSession()).getObjectBuilder().mergeIntoObject(object7, true, object6, mergeManager);
            containerPolicy.addInto(object7, object4, mergeManager.getSession());
        }
        this.setRealAttributeValueInObject(object, object4);
    }

    protected void postDeleteAttributeValue(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.postDeleteAttributeValue(deleteObjectQuery, containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    protected void postInsertAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.postInsertAttributeValue(writeObjectQuery, containerPolicy.next(object2, writeObjectQuery.getSession()));
        }
    }

    protected void postUpdateAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.postUpdateAttributeValue(writeObjectQuery, containerPolicy.next(object2, writeObjectQuery.getSession()));
        }
    }

    protected void preDeleteAttributeValue(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.preDeleteAttributeValue(deleteObjectQuery, containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    protected void preInsertAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.preInsertAttributeValue(writeObjectQuery, containerPolicy.next(object2, writeObjectQuery.getSession()));
        }
    }

    protected void preUpdateAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.preUpdateAttributeValue(writeObjectQuery, containerPolicy.next(object2, writeObjectQuery.getSession()));
        }
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    protected void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        AggregateCollectionChangeRecord aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (aggregateCollectionChangeRecord == null) {
            Object object3 = ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(objectChangeSet);
            Object object4 = this.getRealAttributeValueFromObject(object3, session);
            aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(object4, objectChangeSet, session);
            objectChangeSet.addChange(aggregateCollectionChangeRecord);
        } else {
            aggregateCollectionChangeRecord.getChangedValues().add(object2);
        }
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        AggregateCollectionChangeRecord aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (aggregateCollectionChangeRecord == null) {
            Object object3 = ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(objectChangeSet);
            Object object4 = this.getRealAttributeValueFromObject(object3, session);
            aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(object4, objectChangeSet, session);
            objectChangeSet.addChange(aggregateCollectionChangeRecord);
        } else {
            aggregateCollectionChangeRecord.getChangedValues().remove(object2);
        }
    }

    public void useCollectionClass(Class clazz) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(clazz));
    }

    public void useCollectionClassName(String string) {
        this.setContainerPolicy(new CollectionContainerPolicy(string));
    }

    public void useListClassName(String string) {
        this.setContainerPolicy(new ListContainerPolicy(string));
    }

    public void useMapClass(Class clazz, String string) {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(clazz);
        containerPolicy.setKeyMethod(string, this.getReferenceClass());
        this.setContainerPolicy(containerPolicy);
    }

    public void useMapClassName(String string, String string2) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        MapContainerPolicy mapContainerPolicy = new MapContainerPolicy(string);
        mapContainerPolicy.setKeyMethod(string2, this.getReferenceClassName());
        this.setContainerPolicy(mapContainerPolicy);
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object = databaseRow.getValues(this.getField());
        if (object == null || object instanceof String) {
            return containerPolicy.containerInstance();
        }
        Vector vector = this.getReferenceDescriptor().buildNestedRowsFromFieldValue(object, session);
        if (vector == null) {
            return containerPolicy.containerInstance();
        }
        Object object2 = containerPolicy.containerInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object3;
            DatabaseRow databaseRow2 = (DatabaseRow)enumeration.nextElement();
            Descriptor descriptor = this.getReferenceDescriptor();
            if (descriptor.hasInheritance()) {
                object3 = descriptor.getInheritancePolicy().classFromRow(databaseRow2, session);
                descriptor = this.getReferenceDescriptor((Class)object3, session);
            }
            object3 = this.buildCompositeObject(descriptor, databaseRow2, objectLevelReadQuery);
            containerPolicy.addInto(object3, object2, objectLevelReadQuery.getSession());
        }
        return object2;
    }

    protected abstract Object buildCompositeObject(Descriptor var1, DatabaseRow var2, ObjectLevelReadQuery var3);

    protected boolean verifyDeleteOfAttributeValue(Object object, Session session) throws DatabaseException {
        if (object == null) {
            return true;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            if (super.verifyDeleteOfAttributeValue(containerPolicy.next(object2, session), session)) continue;
            return false;
        }
        return true;
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            databaseRow.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Vector<DatabaseRow> vector = new Vector<DatabaseRow>(containerPolicy.sizeFor(object2));
        Object object3 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = containerPolicy.next(object3, session);
            vector.addElement(this.buildCompositeRow(object4, session, databaseRow));
        }
        object3 = null;
        if (!vector.isEmpty()) {
            object3 = this.getReferenceDescriptor().buildFieldValueFromNestedRows(vector, this.getStructureName(), session);
        }
        databaseRow.put(this.getField(), object3);
    }

    protected abstract DatabaseRow buildCompositeRow(Object var1, Session var2, DatabaseRow var3);

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, DatabaseRow databaseRow) throws DescriptorException {
        Session session = writeObjectQuery.getSession();
        if (session.isClassReadOnly(this.getReferenceClass())) {
            return;
        }
        if (session.isUnitOfWork() && this.compareObjects(writeObjectQuery.getObject(), writeObjectQuery.getBackupClone(), session)) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), databaseRow, session);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) throws DescriptorException {
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, databaseRow, session);
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }
}

