/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.logging;

import java.util.Hashtable;
import java.util.ListResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.toplink.internal.localization.i18n.LoggingLocalizationResource;
import oracle.toplink.internal.localization.i18n.TraceLocalizationResource;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.logging.SessionLogEntry;
import oracle.toplink.logging.TopLinkLogRecord;
import oracle.toplink.sessions.Session;

public class JavaLog
extends AbstractSessionLog {
    private Hashtable nameSpaceTable;
    private Hashtable loggerTable;
    private Hashtable shouldLogTable;
    private Level[] levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private int elementCount = 9;
    private String sessionNameSpace;
    private Logger defaultTopLinkLogger;
    private Logger sessionLogger;
    private Boolean defaultTopLinkShouldLog;
    private Boolean sessionShouldLog;
    protected static final String DEFAULT_SESSION_NAME = "defaultsessionname";
    public static final String DEFAULT_TOPLINK_NAMESPACE = "oracle.toplink";
    protected static final String LOGGING_LOCALIZATION_STRING = "oracle.toplink.internal.localization.i18n.LoggingLocalizationResource";
    protected static final String TRACE_LOCALIZATION_STRING = "oracle.toplink.internal.localization.i18n.TraceLocalizationResource";

    public JavaLog() {
        this.initializeHashtables();
    }

    protected void initializeHashtables() {
        this.nameSpaceTable = new Hashtable();
        this.loggerTable = new Hashtable();
        this.shouldLogTable = new Hashtable();
    }

    public int getLevel(String string) {
        Logger logger;
        for (logger = this.getLogger(string); logger != null && logger.getLevel() == null; logger = logger.getParent()) {
        }
        if (logger == null) {
            return 8;
        }
        int n = logger.getLevel().intValue();
        for (int i = 0; i < this.elementCount; ++i) {
            if (n != this.levels[i].intValue()) continue;
            return i;
        }
        return 8;
    }

    public void setLevel(int n, String string) {
        Logger logger = this.getLogger(string);
        logger.setLevel(this.getJavaLevel(n));
        Boolean bl = new Boolean(logger.isLoggable(this.getJavaLevel(n)));
        if (this.session == null) {
            this.defaultTopLinkShouldLog = bl;
            return;
        }
        if (string == null || string.length() == 0) {
            this.sessionShouldLog = bl;
            return;
        }
        this.shouldLogTable.put(string, bl);
    }

    public String getNameSpaceString(String string) {
        if (this.session == null) {
            return DEFAULT_TOPLINK_NAMESPACE;
        }
        if (string == null || string.length() == 0) {
            return this.sessionNameSpace;
        }
        String string2 = (String)this.nameSpaceTable.get(string);
        if (string2 == null) {
            string2 = this.sessionNameSpace + "." + string;
            this.nameSpaceTable.put(string, string2);
        }
        return string2;
    }

    public Logger getLogger(String string) {
        if (this.session == null) {
            if (this.defaultTopLinkLogger == null) {
                this.defaultTopLinkLogger = Logger.getLogger(DEFAULT_TOPLINK_NAMESPACE);
            }
            return this.defaultTopLinkLogger;
        }
        if (string == null || string.length() == 0) {
            if (this.sessionLogger == null) {
                this.sessionLogger = Logger.getLogger(this.sessionNameSpace);
            }
            return this.sessionLogger;
        }
        Logger logger = (Logger)this.loggerTable.get(string);
        if (logger == null) {
            logger = Logger.getLogger(this.getNameSpaceString(string));
            this.loggerTable.put(string, logger);
        }
        return logger;
    }

    public void setSession(Session session) {
        super.setSession(session);
        if (session != null) {
            String string = session.getName() != null && session.getName().length() != 0 ? session.getName() : DEFAULT_SESSION_NAME;
            this.sessionNameSpace = "oracle.toplink." + string;
        }
    }

    private Level getJavaLevel(int n) {
        return this.levels[n];
    }

    public boolean shouldLog(int n, String string) {
        if (this.session == null) {
            if (this.defaultTopLinkShouldLog == null) {
                this.defaultTopLinkShouldLog = new Boolean(this.getLogger(DEFAULT_TOPLINK_NAMESPACE).isLoggable(this.getJavaLevel(n)));
            }
            return this.defaultTopLinkShouldLog;
        }
        if (string == null || string.length() == 0) {
            if (this.sessionShouldLog == null) {
                this.sessionShouldLog = new Boolean(this.getLogger(this.sessionNameSpace).isLoggable(this.getJavaLevel(n)));
            }
            return this.sessionShouldLog;
        }
        Boolean bl = (Boolean)this.shouldLogTable.get(string);
        if (bl == null) {
            bl = new Boolean(this.getLogger(string).isLoggable(this.getJavaLevel(n)));
            this.shouldLogTable.put(string, bl);
        }
        return bl;
    }

    public void log(SessionLogEntry sessionLogEntry) {
        if (!this.shouldLog(sessionLogEntry.getLevel(), sessionLogEntry.getNameSpace())) {
            return;
        }
        Logger logger = this.getLogger(sessionLogEntry.getNameSpace());
        Level level = this.getJavaLevel(sessionLogEntry.getLevel());
        this.internalLog(sessionLogEntry, level, logger);
    }

    protected void internalLog(SessionLogEntry sessionLogEntry, Level level, Logger logger) {
        TopLinkLogRecord topLinkLogRecord = new TopLinkLogRecord(level, sessionLogEntry.getMessage());
        topLinkLogRecord.setSourceClassName(null);
        topLinkLogRecord.setSourceMethodName(null);
        topLinkLogRecord.setParameters(sessionLogEntry.getParameters());
        topLinkLogRecord.setLoggerName(this.getNameSpaceString(sessionLogEntry.getNameSpace()));
        if (sessionLogEntry.shouldTranslate()) {
            ListResourceBundle listResourceBundle;
            String string;
            if (sessionLogEntry.getLevel() > 3) {
                string = LOGGING_LOCALIZATION_STRING;
                listResourceBundle = new LoggingLocalizationResource();
            } else {
                string = TRACE_LOCALIZATION_STRING;
                listResourceBundle = new TraceLocalizationResource();
            }
            topLinkLogRecord.setResourceBundleName(string);
            topLinkLogRecord.setResourceBundle(listResourceBundle);
        }
        if (this.shouldPrintSession()) {
            topLinkLogRecord.setSessionString(this.getSessionString(sessionLogEntry.getSession()));
        }
        if (this.shouldPrintConnection()) {
            topLinkLogRecord.setConnection(sessionLogEntry.getConnection());
        }
        topLinkLogRecord.setThrown(sessionLogEntry.getException());
        topLinkLogRecord.setShouldLogExceptionStackTrace(this.shouldLogExceptionStackTrace());
        topLinkLogRecord.setShouldPrintDate(this.shouldPrintDate());
        topLinkLogRecord.setShouldPrintThread(this.shouldPrintThread());
        logger.log(topLinkLogRecord);
    }

    public void throwing(Throwable throwable) {
        this.getLogger(null).throwing(null, null, throwable);
    }

    public Object clone() {
        JavaLog javaLog = (JavaLog)super.clone();
        if (javaLog != null) {
            javaLog.initializeHashtables();
            return javaLog;
        }
        return null;
    }
}

