/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.jts.os390;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.jts.JTSExternalTransactionController;
import oracle.toplink.jts.os390.OS390SynchronizationListener;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.sessions.ExternalTransactionController;

public class OS390ExternalTransactionController
extends JTSExternalTransactionController
implements ExternalTransactionController {
    public OS390ExternalTransactionController() {
        if (OS390SynchronizationListener.getTransactionManager() == null) {
            OS390SynchronizationListener.setTransactionManager(this.getTxManager());
        }
    }

    private TransactionManager getTxManager() {
        TransactionManager transactionManager = null;
        try {
            Class clazz = PrivilegedAccessController.getClassForName("com.ibm.ws390.tx.TransactionManagerImpl");
            Method method = PrivilegedAccessController.getMethod(clazz, "getTransactionManager", new Class[0], false);
            transactionManager = (TransactionManager)PrivilegedAccessController.invokeMethod(method, null, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return transactionManager;
    }

    public void register(UnitOfWork unitOfWork, Session session) throws Exception {
        if (OS390SynchronizationListener.getTransactionManager() == null) {
            throw DatabaseException.transactionManagerNotSetForJTSDriver();
        }
        OS390SynchronizationListener.register(unitOfWork, session);
    }
}

