/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.jts;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.jts.AbstractSynchronizationListener;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;

public class JTSSynchronizationListener
extends AbstractSynchronizationListener
implements Synchronization {
    protected static TransactionManager transactionManager;
    protected static boolean shouldAlwaysBeginTransaction;

    public JTSSynchronizationListener(UnitOfWork unitOfWork, Session session, Object object) {
        super(unitOfWork, session, object);
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public static void register(UnitOfWork unitOfWork, Session session) throws Exception {
        if (JTSSynchronizationListener.getTransactionManager().getStatus() != 0 || JTSSynchronizationListener.shouldAlwaysBeginTransaction()) {
            unitOfWork.beginTransaction();
        }
        Transaction transaction = JTSSynchronizationListener.getTransactionManager().getTransaction();
        JTSSynchronizationListener jTSSynchronizationListener = new JTSSynchronizationListener(unitOfWork, session, transaction);
        transaction.registerSynchronization((Synchronization)jTSSynchronizationListener);
    }

    public void rollbackGlobalTransaction() {
        try {
            ((Transaction)this.getGlobalTransaction()).setRollbackOnly();
        }
        catch (SystemException systemException) {
            throw ValidationException.jtsExceptionRaised((Exception)((Object)systemException));
        }
    }

    public static void setTransactionManager(TransactionManager transactionManager) {
        JTSSynchronizationListener.transactionManager = transactionManager;
    }

    public boolean wasTransactionCommitted(int n) {
        return n == 3;
    }

    public static void setShouldAlwaysBeginTransaction(boolean bl) {
        shouldAlwaysBeginTransaction = bl;
    }

    public static boolean shouldAlwaysBeginTransaction() {
        return shouldAlwaysBeginTransaction;
    }

    static {
        shouldAlwaysBeginTransaction = false;
    }
}

