/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.jts;

import oracle.toplink.jts.AbstractExternalTransactionController;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;

public abstract class AbstractSynchronizationListener {
    protected Session session;
    protected UnitOfWork unitOfWork;
    protected Object globalTransaction;
    public static boolean dumpExceptionsFromCallbacks = false;

    public AbstractSynchronizationListener() {
    }

    protected AbstractSynchronizationListener(UnitOfWork unitOfWork, Session session, Object object) {
        this.session = session;
        this.unitOfWork = unitOfWork;
        this.globalTransaction = object;
    }

    public void afterCompletion(int n) {
        UnitOfWork unitOfWork = this.getUnitOfWork();
        if (unitOfWork != null) {
            unitOfWork.log(2, "transaction", "JTS_after_completion");
            if (this.wasTransactionCommitted(n)) {
                unitOfWork.afterTransaction(true, true);
                if (unitOfWork.isMergePending()) {
                    try {
                        unitOfWork.mergeClonesAfterCompletion();
                    }
                    catch (RuntimeException runtimeException) {
                        if (AbstractSynchronizationListener.shouldDumpExceptionsFromCallbacks()) {
                            runtimeException.printStackTrace();
                        }
                        throw runtimeException;
                    }
                }
            } else {
                unitOfWork.afterTransaction(false, true);
            }
            unitOfWork.release();
            ((AbstractExternalTransactionController)this.getSession().getExternalTransactionController()).removeActiveUnitOfWork(this.getGlobalTransaction());
            Session session = this.getSession();
            this.setSession(null);
            this.setUnitOfWork(null);
            this.setGlobalTransaction(null);
            if (session.isClientSession()) {
                session.release();
            }
        }
    }

    public void beforeCompletion() {
        UnitOfWork unitOfWork = this.getUnitOfWork();
        unitOfWork.log(2, "transaction", "JTS_before_completion");
        if (unitOfWork.isActive()) {
            try {
                if (this.getSession().isInTransaction()) {
                    this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
                }
                unitOfWork.issueSQLbeforeCompletion();
                unitOfWork.setPendingMerge();
            }
            catch (RuntimeException runtimeException) {
                if (AbstractSynchronizationListener.shouldDumpExceptionsFromCallbacks()) {
                    runtimeException.printStackTrace();
                }
                throw runtimeException;
            }
        } else {
            this.rollbackGlobalTransaction();
        }
    }

    protected Object getGlobalTransaction() {
        return this.globalTransaction;
    }

    protected Session getSession() {
        return this.session;
    }

    protected UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public static boolean shouldDumpExceptionsFromCallbacks() {
        return dumpExceptionsFromCallbacks;
    }

    public static void setShouldDumpExceptionsFromCallbacks(boolean bl) {
        dumpExceptionsFromCallbacks = bl;
    }

    public abstract void rollbackGlobalTransaction();

    protected void setGlobalTransaction(Object object) {
        this.globalTransaction = object;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
    }

    public abstract boolean wasTransactionCommitted(int var1);
}

