/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;

public class OrderedCollectionChangeRecord
extends ChangeRecord
implements oracle.toplink.changesets.OrderedCollectionChangeRecord {
    protected Hashtable addObjectList;
    protected Vector addIndexes;
    protected int startIndexOfRemove;

    public OrderedCollectionChangeRecord(ObjectChangeSet objectChangeSet) {
        this.owner = objectChangeSet;
        this.startIndexOfRemove = Integer.MAX_VALUE;
    }

    public void addAdditionChange(Hashtable hashtable, Vector vector, UnitOfWorkChangeSet unitOfWorkChangeSet, Session session) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            ObjectChangeSet objectChangeSet = session.getDescriptor(v.getClass()).getObjectBuilder().createObjectChangeSet(v, unitOfWorkChangeSet, session);
            hashtable.put(k, objectChangeSet);
        }
        this.addObjectList = hashtable;
        this.addIndexes = vector;
    }

    public Vector getAddIndexes() {
        if (this.addIndexes == null) {
            this.addIndexes = new Vector(1);
        }
        return this.addIndexes;
    }

    public Hashtable getAddObjectList() {
        if (this.addObjectList == null) {
            this.addObjectList = new Hashtable(1);
        }
        return this.addObjectList;
    }

    public int getStartRemoveIndex() {
        return this.startIndexOfRemove;
    }

    public void mergeRecord(ChangeRecord changeRecord, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
    }

    public void prepareForSynchronization(Session session) {
        Enumeration enumeration = this.getAddObjectList().elements();
        while (enumeration.hasMoreElements()) {
            ObjectChangeSet objectChangeSet = (ObjectChangeSet)enumeration.nextElement();
            if (objectChangeSet.getSynchronizationType() != 0) continue;
            Descriptor descriptor = session.getDescriptor(objectChangeSet.getClassType(session));
            int n = descriptor.getCacheSynchronizationType();
            objectChangeSet.setSynchronizationType(n);
            objectChangeSet.prepareChangeRecordsForSynchronization(session);
        }
    }

    public void setStartRemoveIndex(int n) {
        this.startIndexOfRemove = n;
    }

    public void updateReferences(UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
    }
}

