/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.linkedlist.LinkedNode;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.remote.ObjectDescriptor;
import oracle.toplink.internal.remote.RemoteUnitOfWork;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DoesExistQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.remote.RemoteSession;

public class MergeManager {
    protected Session session;
    protected IdentityHashtable objectDescriptors;
    protected IdentityHashtable objectsAlreadyMerged;
    protected ArrayList acquiredLocks;
    protected CacheKey writeLockQueued;
    protected LinkedNode queueNode;
    protected int mergePolicy;
    protected static final int WORKING_COPY_INTO_ORIGINAL = 1;
    protected static final int ORIGINAL_INTO_WORKING_COPY = 2;
    protected static final int CLONE_INTO_WORKING_COPY = 3;
    protected static final int WORKING_COPY_INTO_REMOTE = 4;
    protected static final int REFRESH_REMOTE_OBJECT = 5;
    protected static final int CHANGES_INTO_DISTRIBUTED_CACHE = 6;
    protected static final int CLONE_WITH_REFS_INTO_WORKING_COPY = 7;
    protected static final int WORKING_COPY_INTO_BACKUP = 9;
    protected int cascadePolicy;
    public static final int NO_CASCADE = 1;
    public static final int CASCADE_PRIVATE_PARTS = 2;
    public static final int CASCADE_ALL_PARTS = 3;
    public static final int CASCADE_BY_MAPPING = 4;
    protected long systemTime = 0L;
    public static boolean LOCK_ON_MERGE = true;

    public MergeManager(Session session) {
        this.session = session;
        this.objectsAlreadyMerged = new IdentityHashtable();
        this.cascadePolicy = 3;
        this.mergePolicy = 1;
        this.objectDescriptors = new IdentityHashtable();
        this.acquiredLocks = new ArrayList();
    }

    protected IdentityHashtable buildIdentitySet(Object object, ContainerPolicy containerPolicy, boolean bl) {
        IdentityHashtable identityHashtable = new IdentityHashtable(containerPolicy.sizeFor(object) + 1);
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Object object3 = containerPolicy.next(object2, this.getSession());
            if (bl) {
                identityHashtable.put(this.getTargetVersionOfSourceObject(object3), object3);
                continue;
            }
            identityHashtable.put(object3, object3);
        }
        return identityHashtable;
    }

    public void cascadeAllParts() {
        this.setCascadePolicy(3);
    }

    public void cascadePrivateParts() {
        this.setCascadePolicy(2);
    }

    public void dontCascadeParts() {
        this.setCascadePolicy(1);
    }

    public ArrayList getAcquiredLocks() {
        return this.acquiredLocks;
    }

    public int getCascadePolicy() {
        return this.cascadePolicy;
    }

    protected int getMergePolicy() {
        return this.mergePolicy;
    }

    public IdentityHashtable getObjectDescriptors() {
        return this.objectDescriptors;
    }

    public IdentityHashtable getObjectsAlreadyMerged() {
        return this.objectsAlreadyMerged;
    }

    public Object getObjectToMerge(Object object) {
        if (this.shouldMergeOriginalIntoWorkingCopy()) {
            return this.getTargetVersionOfSourceObject(object);
        }
        return object;
    }

    public LinkedNode getQueueNode() {
        return this.queueNode;
    }

    public Session getSession() {
        return this.session;
    }

    public long getSystemTime() {
        if (this.systemTime == 0L) {
            this.systemTime = System.currentTimeMillis();
        }
        return this.systemTime;
    }

    public Object getTargetVersionOfSourceObject(Object object) {
        if (this.shouldMergeWorkingCopyIntoOriginal() || this.shouldMergeWorkingCopyIntoRemote()) {
            return ((UnitOfWork)this.getSession()).getOriginalVersionOfObject(object);
        }
        if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeOriginalIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            return this.registerObjectForMergeCloneIntoWorkingCopy(object);
        }
        if (this.shouldRefreshRemoteObject()) {
            Descriptor descriptor = this.getSession().getDescriptor(object);
            Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
            return this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), descriptor);
        }
        throw ValidationException.invalidMergePolicy();
    }

    public CacheKey getWriteLockQueued() {
        return this.writeLockQueued;
    }

    public Object mergeChanges(Object object, ObjectChangeSet objectChangeSet) throws ValidationException {
        Object object2;
        if (object == null) {
            return object;
        }
        if (this.getSession().isClassReadOnly(object.getClass())) {
            return object;
        }
        if (this.getObjectsAlreadyMerged().containsKey(object)) {
            return object;
        }
        this.getObjectsAlreadyMerged().put(object, object);
        if (this.shouldMergeWorkingCopyIntoOriginal()) {
            object2 = this.mergeChangesOfWorkingCopyIntoOriginal(object, objectChangeSet);
        } else if (this.shouldMergeChangesIntoDistributedCache()) {
            object2 = this.mergeChangesIntoDistributedCache(object, objectChangeSet);
        } else if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            object2 = this.mergeChangesOfCloneIntoWorkingCopy(object);
        } else if (this.shouldMergeOriginalIntoWorkingCopy()) {
            object2 = this.mergeChangesOfOriginalIntoWorkingCopy(object);
        } else if (this.shouldMergeWorkingCopyIntoRemote()) {
            object2 = this.mergeChangesOfWorkingCopyIntoRemote(object);
        } else if (this.shouldRefreshRemoteObject()) {
            object2 = this.mergeChangesForRefreshingRemoteObject(object);
        } else {
            throw ValidationException.invalidMergePolicy();
        }
        return object2;
    }

    protected Object mergeChangesForRefreshingRemoteObject(Object object) {
        Descriptor descriptor = this.getSession().getDescriptor(object);
        Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        Object object2 = this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), descriptor);
        if (object2 == null) {
            Cloneable cloneable;
            ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectDescriptors.get(object);
            if (objectDescriptor == null) {
                objectDescriptor = new ObjectDescriptor();
                objectDescriptor.setKey(vector);
                objectDescriptor.setObject(object);
                cloneable = descriptor.getOptimisticLockingPolicy();
                if (cloneable == null) {
                    objectDescriptor.setWriteLockValue(null);
                } else {
                    objectDescriptor.setWriteLockValue(cloneable.getBaseValue());
                }
            }
            cloneable = new ReadObjectQuery();
            ((DatabaseQuery)cloneable).setCascadePolicy(this.getCascadePolicy());
            ((RemoteSession)this.getSession()).getIdentityMapAccessorInstance().putInIdentityMap(object, vector, objectDescriptor.getWriteLockValue(), objectDescriptor.getReadTime(), descriptor);
            descriptor.getObjectBuilder().fixObjectReferences(object, this.getObjectDescriptors(), this.getObjectsAlreadyMerged(), (ObjectLevelReadQuery)cloneable, (RemoteSession)this.getSession());
            object2 = object;
        } else {
            Cloneable cloneable;
            descriptor.getObjectBuilder().mergeIntoObject(object2, false, object, this);
            ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.getObjectDescriptors().get(object);
            if (objectDescriptor == null) {
                objectDescriptor = new ObjectDescriptor();
                objectDescriptor.setKey(vector);
                objectDescriptor.setObject(object);
                cloneable = descriptor.getOptimisticLockingPolicy();
                if (cloneable == null) {
                    objectDescriptor.setWriteLockValue(null);
                } else {
                    objectDescriptor.setWriteLockValue(cloneable.getBaseValue());
                }
            }
            if ((cloneable = this.getSession().getIdentityMapAccessorInstance().getCacheKeyForObject(vector, object2.getClass(), descriptor)) != null) {
                ((CacheKey)cloneable).setReadTime(objectDescriptor.getReadTime());
            }
            if (descriptor.usesOptimisticLocking()) {
                this.getSession().getIdentityMapAccessor().updateWriteLockValue(vector, object2.getClass(), objectDescriptor.getWriteLockValue());
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesFromChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.getSession().startOperationProfile("distributed merge");
        this.getSession().getIdentityMapAccessorInstance().acquireWriteLock();
        this.getSession().log(2, "propagation", "received_updates_from_remote_server");
        this.getSession().getEventManager().preDistributedMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
        try {
            try {
                Object object;
                Object object2;
                this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this, unitOfWorkChangeSet);
                Enumeration enumeration = unitOfWorkChangeSet.getAllChangeSets().keys();
                while (enumeration.hasMoreElements()) {
                    object2 = (ObjectChangeSet)enumeration.nextElement();
                    object = ((ObjectChangeSet)object2).getTargetVersionOfSourceObject(this.getSession(), false);
                    Object object3 = this.mergeChanges(object, (ObjectChangeSet)object2);
                    if (object3 == null && ((ObjectChangeSet)object2).isNew()) {
                        object3 = this.mergeNewObjectIntoCache((ObjectChangeSet)object2);
                    }
                    if (object3 == null) {
                        this.getSession().incrementProfile("ChangesNotProcessed");
                        continue;
                    }
                    this.getSession().incrementProfile("ChangesProcessed");
                }
                object2 = unitOfWorkChangeSet.getDeletedObjects().elements();
                while (object2.hasMoreElements()) {
                    object = (ObjectChangeSet)object2.nextElement();
                    ((ObjectChangeSet)object).removeFromIdentityMap(this.getSession());
                    this.getSession().incrementProfile("deleted object");
                }
                Object var7_7 = null;
            }
            catch (RuntimeException runtimeException) {
                this.getSession().handleException(runtimeException);
                Object var7_8 = null;
                this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this);
                this.getSession().getIdentityMapAccessorInstance().releaseWriteLock();
                this.getSession().getEventManager().postDistributedMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
                this.getSession().endOperationProfile("distributed merge");
            }
            this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this);
            this.getSession().getIdentityMapAccessorInstance().releaseWriteLock();
            this.getSession().getEventManager().postDistributedMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
            this.getSession().endOperationProfile("distributed merge");
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.getSession().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this);
            this.getSession().getIdentityMapAccessorInstance().releaseWriteLock();
            this.getSession().getEventManager().postDistributedMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
            this.getSession().endOperationProfile("distributed merge");
            throw throwable;
        }
    }

    public boolean mergeChangesInCollection(Object object, Object object2, Object object3, DatabaseMapping databaseMapping) {
        Object object4;
        ContainerPolicy containerPolicy = databaseMapping.getContainerPolicy();
        IdentityHashtable identityHashtable = this.buildIdentitySet(object3, containerPolicy, false);
        IdentityHashtable identityHashtable2 = null;
        IdentityHashtable identityHashtable3 = null;
        if (this.shouldMergeWorkingCopyIntoOriginal()) {
            identityHashtable2 = this.buildIdentitySet(object, containerPolicy, false);
        } else {
            identityHashtable3 = this.buildIdentitySet(object, containerPolicy, true);
        }
        boolean bl = false;
        if (object3 == object2) {
            object3 = containerPolicy.cloneFor(object3);
        }
        Object object5 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object5)) {
            object4 = containerPolicy.next(object5, this.getSession());
            if (this.shouldMergeWorkingCopyIntoOriginal()) {
                if (identityHashtable2.containsKey(object4)) continue;
                bl = true;
                containerPolicy.removeFrom(null, this.getTargetVersionOfSourceObject(object4), object2, this.getSession());
                if (!databaseMapping.isPrivateOwned()) continue;
                this.registerRemovedNewObjectIfRequired(object4);
                continue;
            }
            if (identityHashtable3.containsKey(object4)) continue;
            bl = true;
            containerPolicy.removeFrom(null, object4, object2, this.getSession());
        }
        object5 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object5)) {
            object4 = containerPolicy.next(object5, this.getSession());
            databaseMapping.cascadeMerge(object4, this);
            if (this.shouldMergeWorkingCopyIntoOriginal()) {
                if (!identityHashtable.containsKey(object4)) {
                    bl = true;
                    containerPolicy.addInto(this.getTargetVersionOfSourceObject(object4), object2, this.getSession());
                    continue;
                }
                containerPolicy.validateElementAndRehashIfRequired(object4, object2, this.getSession(), this.getTargetVersionOfSourceObject(object4));
                continue;
            }
            Object object6 = this.getTargetVersionOfSourceObject(object4);
            if (identityHashtable.containsKey(object6)) continue;
            bl = true;
            containerPolicy.addInto(object6, object2, this.getSession());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesIntoDistributedCache(Object object, ObjectChangeSet objectChangeSet) {
        Session session = this.getSession();
        Class clazz = objectChangeSet.getClassType(session);
        Descriptor descriptor = session.getDescriptor(clazz);
        if (object != null && descriptor.usesOptimisticLocking()) {
            int n;
            if (session.getCommandManager() != null && session.getCommandManager().getCommandConverter() != null) {
                objectChangeSet.rebuildWriteLockValueFromUserFormat(descriptor, session);
            }
            if ((n = descriptor.getOptimisticLockingPolicy().getVersionDifference(objectChangeSet.getWriteLockValue(), object, objectChangeSet.getPrimaryKeys(), session)) < 0) {
                this.getSession().log(1, "propagation", "change_from_remote_server_older_than_current_version", objectChangeSet.getClassName(), objectChangeSet.getPrimaryKeys());
                return object;
            }
            if (n > 1) {
                this.getSession().log(1, "propagation", "current_version_much_older_than_change_from_remote_server", objectChangeSet.getClassName(), objectChangeSet.getPrimaryKeys());
                session.refreshObject(object);
                return object;
            }
        }
        this.getSession().log(1, "propagation", "Merging_from_remote_server", objectChangeSet.getClassName(), objectChangeSet.getPrimaryKeys());
        if (objectChangeSet.getSynchronizationType() == 2) {
            this.getSession().getIdentityMapAccessorInstance().invalidateObject(objectChangeSet.getPrimaryKeys(), clazz);
        } else if (objectChangeSet.getSynchronizationType() != 4) {
            descriptor.getObjectBuilder().mergeChangesIntoObject(object, objectChangeSet, null, this);
            Vector vector = objectChangeSet.getPrimaryKeys();
            CacheKey cacheKey = session.getIdentityMapAccessorInstance().acquireLock(vector, object.getClass(), descriptor);
            try {
                if (descriptor.usesOptimisticLocking() && descriptor.getOptimisticLockingPolicy().isChildWriteLockValueGreater(session, vector, object.getClass(), objectChangeSet)) {
                    cacheKey.setWriteLockValue(objectChangeSet.getWriteLockValue());
                }
                cacheKey.setObject(object);
                if (descriptor.getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate()) {
                    cacheKey.setReadTime(this.getSystemTime());
                }
            }
            finally {
                cacheKey.updateAccess();
                cacheKey.release();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfCloneIntoWorkingCopy(Object object) {
        Descriptor descriptor = this.getSession().getDescriptor(object);
        Object object2 = this.registerObjectForMergeCloneIntoWorkingCopy(object);
        if (object2 == object) {
            return object;
        }
        boolean bl = false;
        try {
            descriptor.getObjectChangePolicy().dissableEventProcessing(object2);
            descriptor.getObjectBuilder().mergeIntoObject(object2, false, object, this);
        }
        finally {
            descriptor.getObjectChangePolicy().enableEventProcessing(object2);
        }
        return object2;
    }

    protected Object mergeChangesOfOriginalIntoWorkingCopy(Object object) {
        Descriptor descriptor = this.getSession().getDescriptor(object);
        Object object2 = ((UnitOfWork)this.getSession()).getOriginalVersionOfObjectOrNull(object);
        if (object2 == null) {
            return object;
        }
        descriptor.getObjectBuilder().mergeIntoObject(object, false, object2, this);
        descriptor.getObjectChangePolicy().revertChanges(object, descriptor, (UnitOfWork)this.getSession(), ((UnitOfWork)this.getSession()).getCloneMapping());
        Vector vector = this.getSession().keyFromObject(object);
        if (descriptor.usesOptimisticLocking()) {
            descriptor.getOptimisticLockingPolicy().mergeIntoParentCache((UnitOfWork)this.getSession(), vector, object);
        }
        CacheKey cacheKey = ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(vector, object.getClass(), descriptor);
        CacheKey cacheKey2 = this.getSession().getIdentityMapAccessorInstance().getCacheKeyForObject(vector, object.getClass(), descriptor);
        if (cacheKey != null && cacheKey2 != null) {
            cacheKey2.setReadTime(cacheKey.getReadTime());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfWorkingCopyIntoOriginal(Object object, ObjectChangeSet objectChangeSet) {
        Object object2;
        Object object3;
        Object object4;
        UnitOfWork unitOfWork = (UnitOfWork)this.getSession();
        boolean bl = false;
        if (unitOfWork.isNestedUnitOfWork() && (object4 = unitOfWork.getOriginalVersionOfNewObject(object)) != null && !((UnitOfWork)unitOfWork.getParent()).isCloneNewObject(object4) && !unitOfWork.isUnregisteredNewObjectInParent(object4)) {
            bl = true;
        }
        object4 = unitOfWork.getOriginalVersionOfObjectOrNull(object);
        Descriptor descriptor = unitOfWork.getDescriptor(object.getClass());
        try {
            if (object4 == null) {
                object4 = unitOfWork.buildOriginal(object);
                if (objectChangeSet == null) {
                    descriptor.getObjectBuilder().mergeIntoObject(object4, true, object, this);
                } else if (!objectChangeSet.isNew()) {
                    object4 = ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessorInstance().getWriteLockManager().appendLock(objectChangeSet.getPrimaryKeys(), object4, descriptor, this, ((UnitOfWork)this.getSession()).getParent());
                    descriptor.getObjectBuilder().mergeIntoObject(object4, true, object, this);
                } else {
                    descriptor.getObjectBuilder().mergeChangesIntoObject(object4, objectChangeSet, object, this);
                }
            } else if (objectChangeSet == null) {
                descriptor.getObjectBuilder().mergeIntoObject(object4, false, object, this);
            } else {
                descriptor.getObjectBuilder().mergeChangesIntoObject(object4, objectChangeSet, object, this);
            }
        }
        catch (QueryException queryException) {
            if (unitOfWork.shouldPerformNoValidation() || descriptor.hasWrapperPolicy()) {
                if (queryException.getErrorCode() != 6066 && queryException.getErrorCode() != 6004 && queryException.getErrorCode() != 6005) {
                    throw queryException;
                }
                return object;
            }
            throw queryException;
        }
        if (bl) {
            object3 = descriptor.getObjectBuilder().buildNewInstance();
            object2 = descriptor.getObjectBuilder().buildNewInstance();
            ((UnitOfWork)unitOfWork.getParent()).registerOriginalNewObjectFromNestedUnitOfWork(object4, object3, object2);
        }
        if (!unitOfWork.isNestedUnitOfWork()) {
            object3 = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, unitOfWork);
            object2 = unitOfWork.getParent().getIdentityMapAccessorInstance().acquireLock((Vector)object3, object4.getClass(), descriptor);
            try {
                if (descriptor.usesOptimisticLocking() && descriptor.getOptimisticLockingPolicy().isChildWriteLockValueGreater(unitOfWork, (Vector)object3, object4.getClass())) {
                    ((CacheKey)object2).setWriteLockValue(unitOfWork.getIdentityMapAccessor().getWriteLockValue(object4));
                }
                ((CacheKey)object2).setObject(object4);
                if (descriptor.getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate() || objectChangeSet != null && objectChangeSet.isNew()) {
                    ((CacheKey)object2).setReadTime(this.getSystemTime());
                }
            }
            finally {
                ((CacheKey)object2).updateAccess();
                ((CacheKey)object2).release();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mergeChangesOfWorkingCopyIntoRemote(Object object) throws ValidationException {
        Object object2;
        Object object3;
        UnitOfWork unitOfWork = (UnitOfWork)this.getSession();
        Object object4 = unitOfWork.getOriginalVersionOfObject(object);
        Descriptor descriptor = unitOfWork.getDescriptor(object);
        descriptor.getObjectBuilder().mergeIntoObject(object4, false, object, this);
        if (((RemoteUnitOfWork)unitOfWork.getParent()).getUnregisteredNewObjectsCache().contains(object4)) {
            object3 = descriptor.getObjectBuilder().buildNewInstance();
            object2 = descriptor.getObjectBuilder().buildNewInstance();
            ((UnitOfWork)unitOfWork.getParent()).registerOriginalNewObjectFromNestedUnitOfWork(object4, object3, object2);
        }
        object3 = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, unitOfWork);
        object2 = unitOfWork.getParent().getIdentityMapAccessorInstance().acquireLock((Vector)object3, object4.getClass(), descriptor);
        try {
            if (descriptor.usesOptimisticLocking()) {
                ((CacheKey)object2).setObject(object4);
                ((CacheKey)object2).setWriteLockValue(unitOfWork.getIdentityMapAccessor().getWriteLockValue(object4));
            } else {
                ((CacheKey)object2).setObject(object4);
            }
        }
        finally {
            ((CacheKey)object2).updateAccess();
            ((CacheKey)object2).release();
        }
        return object;
    }

    public void mergeCloneIntoWorkingCopy() {
        this.setMergePolicy(3);
    }

    public void mergeCloneWithReferencesIntoWorkingCopy() {
        this.setMergePolicy(7);
    }

    public void mergeIntoDistributedCache() {
        this.setMergePolicy(6);
    }

    public Object mergeNewObjectIntoCache(ObjectChangeSet objectChangeSet) {
        if (objectChangeSet.isNew()) {
            Class clazz = objectChangeSet.getClassType(this.session);
            Descriptor descriptor = this.getSession().getDescriptor(clazz);
            Object object = objectChangeSet.getTargetVersionOfSourceObject(this.getSession(), false);
            if (object == null) {
                if (!this.getObjectsAlreadyMerged().containsKey(objectChangeSet)) {
                    object = descriptor.getObjectBuilder().buildNewInstance();
                    this.getObjectsAlreadyMerged().put(objectChangeSet, object);
                } else {
                    object = this.getObjectsAlreadyMerged().get(objectChangeSet);
                }
            } else {
                object = objectChangeSet.getTargetVersionOfSourceObject(this.getSession(), true);
            }
            this.mergeChanges(object, objectChangeSet);
            Object object2 = descriptor.getObjectBuilder().unwrapObject(object, this.getSession());
            return this.getSession().getIdentityMapAccessorInstance().putInIdentityMap(object2, descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object2, this.getSession()), objectChangeSet.getWriteLockValue(), this.getSystemTime(), descriptor);
        }
        return null;
    }

    public void mergeOriginalIntoWorkingCopy() {
        this.setMergePolicy(2);
    }

    public void mergeWorkingCopyIntoBackup() {
        this.setMergePolicy(9);
    }

    public void mergeWorkingCopyIntoOriginal() {
        this.setMergePolicy(1);
    }

    public void mergeWorkingCopyIntoRemote() {
        this.setMergePolicy(4);
    }

    public void refreshRemoteObject() {
        this.setMergePolicy(5);
    }

    protected Object registerObjectForMergeCloneIntoWorkingCopy(Object object) {
        Descriptor descriptor = this.getSession().getDescriptor(object.getClass());
        Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        Object object2 = this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(vector, descriptor.getJavaClass(), descriptor);
        if (object2 != null) {
            return object2;
        }
        DoesExistQuery doesExistQuery = descriptor.getQueryManager().getDoesExistQuery();
        if (doesExistQuery.shouldCheckCacheForDoesExist()) {
            return ((UnitOfWork)this.getSession()).internalRegisterObject(object, descriptor);
        }
        Boolean bl = (Boolean)doesExistQuery.checkEarlyReturn(object, vector, this.getSession(), null);
        if (bl == Boolean.FALSE) {
            return ((UnitOfWork)this.getSession()).internalRegisterObject(object, descriptor);
        }
        Object object3 = this.getSession().readObject(object);
        if (object3 == null) {
            return ((UnitOfWork)this.getSession()).internalRegisterObject(object, descriptor);
        }
        return object3;
    }

    public void registerRemovedNewObjectIfRequired(Object object) {
        if (this.getSession().isUnitOfWork()) {
            UnitOfWork unitOfWork = (UnitOfWork)this.getSession();
            if (this.shouldMergeWorkingCopyIntoOriginal() && unitOfWork.getParent().isUnitOfWork() && unitOfWork.isCloneNewObject(object)) {
                Object object2 = unitOfWork.getOriginalVersionOfObject(object);
                unitOfWork.addRemovedObject(object2);
            }
        }
    }

    public void setCascadePolicy(int n) {
        this.cascadePolicy = n;
    }

    protected void setMergePolicy(int n) {
        this.mergePolicy = n;
    }

    public void setObjectDescriptors(IdentityHashtable identityHashtable) {
        this.objectDescriptors = identityHashtable;
    }

    protected void setObjectsAlreadyMerged(IdentityHashtable identityHashtable) {
        this.objectsAlreadyMerged = identityHashtable;
    }

    public void setQueueNode(LinkedNode linkedNode) {
        this.queueNode = linkedNode;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    public void setWriteLockQueued(CacheKey cacheKey) {
        this.writeLockQueued = cacheKey;
    }

    public boolean shouldCascadeByMapping() {
        return this.getCascadePolicy() == 4;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeParts() {
        return this.getCascadePolicy() != 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadePolicy() == 2 || this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeReferences() {
        return !this.shouldMergeCloneIntoWorkingCopy();
    }

    public boolean shouldMergeChangesIntoDistributedCache() {
        return this.getMergePolicy() == 6;
    }

    public boolean shouldMergeCloneIntoWorkingCopy() {
        return this.getMergePolicy() == 3;
    }

    public boolean shouldMergeCloneWithReferencesIntoWorkingCopy() {
        return this.getMergePolicy() == 7;
    }

    public boolean shouldMergeOriginalIntoWorkingCopy() {
        return this.getMergePolicy() == 2;
    }

    public boolean shouldMergeWorkingCopyIntoBackup() {
        return this.getMergePolicy() == 9;
    }

    public boolean shouldMergeWorkingCopyIntoOriginal() {
        return this.getMergePolicy() == 1;
    }

    public boolean shouldMergeWorkingCopyIntoRemote() {
        return this.getMergePolicy() == 4;
    }

    public boolean shouldRefreshRemoteObject() {
        return this.getMergePolicy() == 5;
    }
}

