/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.Association;

public class DirectMapChangeRecord
extends ChangeRecord {
    protected HashMap addObjectsList;
    protected HashMap removeObjectsList;
    protected transient Object originalCollection;
    protected transient Object latestCollection;

    public DirectMapChangeRecord() {
    }

    public DirectMapChangeRecord(ObjectChangeSet objectChangeSet) {
        this.owner = objectChangeSet;
    }

    public Vector getAddAssociations() {
        Vector<Association> vector = new Vector<Association>();
        Iterator iterator = this.getAddObjects().keySet().iterator();
        while (iterator.hasNext()) {
            Association association = new Association();
            Object k = iterator.next();
            Object v = this.getAddObjects().get(k);
            association.setKey(k);
            association.setValue(v);
            vector.add(association);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public boolean hasChanges() {
        return !this.getAddObjects().isEmpty() || !this.getRemoveObjects().isEmpty() || this.getOwner().isNew();
    }

    public void mergeRecord(ChangeRecord changeRecord, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
        Object object;
        Iterator iterator = ((DirectMapChangeRecord)changeRecord).getAddObjects().keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (this.getAddObjects().containsKey(object)) continue;
            if (this.getRemoveObjects().containsKey(object)) {
                this.getRemoveObjects().remove(object);
                continue;
            }
            this.getAddObjects().put(object, ((DirectMapChangeRecord)changeRecord).getAddObjects().get(object));
        }
        object = ((DirectMapChangeRecord)changeRecord).getRemoveObjects().keySet().iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (this.getRemoveObjects().containsKey(e)) continue;
            if (this.getAddObjects().containsKey(e)) {
                this.getAddObjects().remove(e);
                continue;
            }
            this.getRemoveObjects().put(e, ((DirectMapChangeRecord)changeRecord).getRemoveObjects().get(e));
        }
    }

    public void setAddAssociations(Vector vector) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            hashMap.put(association.getKey(), association.getValue());
        }
        if (hashMap.isEmpty()) {
            this.addObjectsList = null;
        }
        this.addObjectsList = hashMap;
    }

    public Object getLatestCollection() {
        return this.latestCollection;
    }

    public Object getOriginalCollection() {
        return this.originalCollection;
    }

    public Vector getRemoveAssociations() {
        Vector<Association> vector = new Vector<Association>();
        Iterator iterator = this.getRemoveObjects().keySet().iterator();
        while (iterator.hasNext()) {
            Association association = new Association();
            Object k = iterator.next();
            Object v = this.getAddObjects().get(k);
            association.setKey(k);
            association.setValue(v);
            vector.add(association);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public void setRemoveAssociations(Vector vector) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            hashMap.put(association.getKey(), association.getValue());
        }
        if (hashMap.isEmpty()) {
            this.removeObjectsList = null;
        }
        this.removeObjectsList = hashMap;
    }

    public void addAdditionChange(HashMap hashMap) {
        if (this.getAddObjects().size() == 0) {
            this.addObjectsList = hashMap;
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (this.getAddObjects().containsKey(k)) {
                this.getAddObjects().put(k, hashMap.get(k));
                continue;
            }
            if (!hashMap.get(k).equals(this.getAddObjects().get(k))) continue;
            this.getAddObjects().put(k, hashMap.get(k));
        }
    }

    public void addRemoveChange(HashMap hashMap) {
        if (this.getRemoveObjects().size() == 0) {
            this.removeObjectsList = hashMap;
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!this.getRemoveObjects().containsKey(k)) {
                this.getRemoveObjects().put(k, hashMap.get(k));
                continue;
            }
            if (!hashMap.get(k).equals(this.getRemoveObjects().get(k))) continue;
            this.getRemoveObjects().put(k, hashMap.get(k));
        }
    }

    public void addAdditionChange(Object object, Object object2) {
        if (this.getRemoveObjects().containsKey(object)) {
            if (object2.equals(this.getRemoveObjects().get(object))) {
                this.getRemoveObjects().remove(object);
            } else {
                this.getAddObjects().put(object, object2);
            }
        } else {
            this.getAddObjects().put(object, object2);
        }
    }

    public void addRemoveChange(Object object, Object object2) {
        if (this.getAddObjects().containsKey(object)) {
            this.getAddObjects().remove(object);
        } else if (!this.getRemoveObjects().containsKey(object)) {
            this.getRemoveObjects().put(object, object2);
        }
    }

    public void setAddObjects(HashMap hashMap) {
        this.addObjectsList = hashMap;
    }

    public void setLatestCollection(Object object) {
        this.latestCollection = object;
    }

    public void setOriginalCollection(Object object) {
        this.originalCollection = object;
    }

    public HashMap getAddObjects() {
        if (this.addObjectsList == null) {
            this.addObjectsList = new HashMap();
        }
        return this.addObjectsList;
    }

    public void setRemoveObjects(HashMap hashMap) {
        this.removeObjectsList = hashMap;
    }

    public HashMap getRemoveObjects() {
        if (this.removeObjectsList == null) {
            this.removeObjectsList = new HashMap();
        }
        return this.removeObjectsList;
    }

    public void updateReferences(UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet2) {
    }
}

