/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.descriptors.changetracking.AttributeChangeTrackingPolicy;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.DescriptorCompare;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.helper.TOPSort;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.internal.sessions.CommitOrderCalculator;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.UpdateObjectQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class CommitManager {
    protected Vector commitOrder;
    protected IdentityHashtable processedCommits;
    protected IdentityHashtable pendingCommits;
    protected IdentityHashtable preModifyCommits;
    protected IdentityHashtable postModifyCommits;
    protected IdentityHashtable completedCommits;
    protected IdentityHashtable shallowCommits;
    protected Session session;
    protected boolean isActive;
    protected Hashtable dataModifications;
    protected Vector objectsToDelete;

    public CommitManager(Session session) {
        this.session = session;
        this.commitOrder = NonSynchronizedVector.newInstance();
        this.isActive = false;
    }

    public void addDataModificationEvent(DatabaseMapping databaseMapping, Object[] objectArray) {
        if (!this.getDataModifications().containsKey(databaseMapping)) {
            this.getDataModifications().put(databaseMapping, new Vector());
        }
        ((Vector)this.getDataModifications().get(databaseMapping)).addElement(objectArray);
    }

    public void addObjectToDelete(Object object) {
        this.getObjectsToDelete().addElement(object);
    }

    protected void addProcessedCommit(Object object) {
        this.getProcessedCommits().put(object, object);
    }

    public void commitAllObjects(IdentityHashtable identityHashtable) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.reinitialize();
        this.setPendingCommits(identityHashtable);
        this.setIsActive(true);
        this.getSession().beginTransaction();
        try {
            Object object;
            Object object2;
            Object object3;
            Enumeration enumeration;
            Object object4 = this.getCommitOrder().elements();
            while (object4.hasMoreElements()) {
                enumeration = (Class)object4.nextElement();
                object3 = this.getPendingCommits().elements();
                while (object3.hasMoreElements()) {
                    object2 = object3.nextElement();
                    if (this.getSession().getDescriptor(object2).getObjectChangePolicy() instanceof AttributeChangeTrackingPolicy) {
                        throw ValidationException.oldCommitNotSupportedForAttributeTracking();
                    }
                    if (object2.getClass() != enumeration) continue;
                    this.removePendingCommit(object2);
                    object = new WriteObjectQuery();
                    ((DatabaseQuery)object).setIsExecutionClone(true);
                    ((ObjectLevelModifyQuery)object).setObject(object2);
                    if (this.getSession().isUnitOfWork()) {
                        ((DatabaseQuery)object).cascadeOnlyDependentParts();
                    } else {
                        ((DatabaseQuery)object).cascadeAllParts();
                    }
                    this.getSession().executeQuery((DatabaseQuery)object);
                }
            }
            object4 = this.getDataModifications().keys();
            enumeration = this.getDataModifications().elements();
            while (enumeration.hasMoreElements()) {
                object3 = (Vector)enumeration.nextElement();
                object2 = (DatabaseMapping)object4.nextElement();
                object = ((Vector)object3).elements();
                while (object.hasMoreElements()) {
                    Object[] objectArray = (Object[])object.nextElement();
                    ((DatabaseMapping)object2).performDataModificationEvent(objectArray, this.getSession());
                }
            }
            object4 = this.getObjectsToDelete();
            this.reinitialize();
            enumeration = ((Vector)object4).elements();
            while (enumeration.hasMoreElements()) {
                this.getSession().deleteObject(enumeration.nextElement());
            }
        }
        catch (RuntimeException runtimeException) {
            this.getSession().rollbackTransaction();
            throw runtimeException;
        }
        finally {
            this.reinitialize();
            this.setIsActive(false);
        }
        this.getSession().commitTransaction();
    }

    public void commitAllObjectsWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.reinitialize();
        this.setIsActive(true);
        this.getSession().beginTransaction();
        try {
            Object object;
            Enumeration<Object> enumeration;
            Enumeration enumeration2;
            if (unitOfWorkChangeSet.getObjectChanges().size() + unitOfWorkChangeSet.getNewObjectChangeSets().size() <= 1) {
                enumeration2 = unitOfWorkChangeSet.getNewObjectChangeSets().keys();
                if (enumeration2.hasMoreElements()) {
                    enumeration = (Class)enumeration2.nextElement();
                    this.commitNewObjectsForClassWithChangeSet(unitOfWorkChangeSet, (Class)((Object)enumeration));
                }
                if ((enumeration = unitOfWorkChangeSet.getObjectChanges().keys()).hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    this.commitChangedObjectsForClassWithChangeSet(unitOfWorkChangeSet, (String)object);
                }
            } else {
                enumeration2 = this.getCommitOrder().elements();
                while (enumeration2.hasMoreElements()) {
                    enumeration = (Class)enumeration2.nextElement();
                    this.commitAllObjectsForClassWithChangeSet(unitOfWorkChangeSet, (Class)((Object)enumeration));
                }
            }
            if (this.hasDataModifications()) {
                enumeration2 = this.getDataModifications().keys();
                enumeration = this.getDataModifications().elements();
                while (enumeration.hasMoreElements()) {
                    object = (Vector)enumeration.nextElement();
                    DatabaseMapping databaseMapping = (DatabaseMapping)enumeration2.nextElement();
                    Enumeration enumeration3 = ((Vector)object).elements();
                    while (enumeration3.hasMoreElements()) {
                        Object[] objectArray = (Object[])enumeration3.nextElement();
                        databaseMapping.performDataModificationEvent(objectArray, this.getSession());
                    }
                }
            }
            if (this.hasObjectsToDelete()) {
                enumeration2 = this.getObjectsToDelete();
                this.reinitialize();
                enumeration = ((Vector)((Object)enumeration2)).elements();
                while (enumeration.hasMoreElements()) {
                    this.getSession().deleteObject(enumeration.nextElement());
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.getSession().rollbackTransaction();
            throw runtimeException;
        }
        finally {
            this.reinitialize();
            this.setIsActive(false);
        }
        this.getSession().commitTransaction();
    }

    protected void commitAllObjectsForClassWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet, Class clazz) {
        this.commitChangedObjectsForClassWithChangeSet(unitOfWorkChangeSet, clazz.getName());
        this.commitNewObjectsForClassWithChangeSet(unitOfWorkChangeSet, clazz);
    }

    protected void commitNewObjectsForClassWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet, Class clazz) {
        IdentityHashtable identityHashtable = (IdentityHashtable)unitOfWorkChangeSet.getNewObjectChangeSets().get(clazz);
        if (identityHashtable != null) {
            Descriptor descriptor = this.getSession().getDescriptor(clazz);
            Enumeration enumeration = identityHashtable.elements();
            while (enumeration.hasMoreElements()) {
                ObjectChangeSet objectChangeSet = (ObjectChangeSet)enumeration.nextElement();
                Object object = objectChangeSet.getUnitOfWorkClone();
                if (!this.getProcessedCommits().containsKey(objectChangeSet) && !this.getProcessedCommits().containsKey(object)) {
                    this.addProcessedCommit(objectChangeSet);
                    InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
                    insertObjectQuery.setIsExecutionClone(true);
                    insertObjectQuery.setDescriptor(descriptor);
                    insertObjectQuery.setObjectChangeSet(objectChangeSet);
                    insertObjectQuery.setObject(object);
                    insertObjectQuery.cascadeOnlyDependentParts();
                    this.getSession().executeQuery(insertObjectQuery);
                }
                ((UnitOfWork)this.getSession()).updateChangeTrackersIfRequired(object, objectChangeSet, (UnitOfWork)this.getSession(), descriptor);
            }
        }
    }

    protected void commitChangedObjectsForClassWithChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet, String string) {
        Hashtable hashtable = (Hashtable)unitOfWorkChangeSet.getObjectChanges().get(string);
        if (hashtable != null) {
            Descriptor descriptor = null;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                ObjectChangeSet objectChangeSet = (ObjectChangeSet)enumeration.nextElement();
                if (descriptor == null) {
                    descriptor = this.getSession().getDescriptor(objectChangeSet.getClassType(this.getSession()));
                }
                Object object = objectChangeSet.getUnitOfWorkClone();
                if (!this.getProcessedCommits().containsKey(objectChangeSet) && !this.getProcessedCommits().containsKey(object)) {
                    this.addProcessedCommit(objectChangeSet);
                    WriteObjectQuery writeObjectQuery = null;
                    writeObjectQuery = objectChangeSet.isNew() ? new InsertObjectQuery() : new UpdateObjectQuery();
                    writeObjectQuery.setIsExecutionClone(true);
                    writeObjectQuery.setDescriptor(descriptor);
                    writeObjectQuery.setObjectChangeSet(objectChangeSet);
                    writeObjectQuery.setObject(object);
                    writeObjectQuery.cascadeOnlyDependentParts();
                    this.getSession().executeQuery(writeObjectQuery);
                }
                ((UnitOfWork)this.getSession()).updateChangeTrackersIfRequired(object, objectChangeSet, (UnitOfWork)this.getSession(), descriptor);
            }
        }
    }

    public void deleteAllObjects(Vector vector) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.setIsActive(true);
        this.getSession().beginTransaction();
        try {
            for (int i = this.getCommitOrder().size() - 1; i >= 0; --i) {
                Class clazz = (Class)this.getCommitOrder().elementAt(i);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e.getClass() != clazz) continue;
                    DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
                    deleteObjectQuery.setIsExecutionClone(true);
                    deleteObjectQuery.setObject(e);
                    this.getSession().executeQuery(deleteObjectQuery);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            try {
                this.getSession().rollbackTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw runtimeException;
        }
        finally {
            this.setIsActive(false);
        }
        this.getSession().commitTransaction();
    }

    public Vector getCommitOrder() {
        return this.commitOrder;
    }

    protected IdentityHashtable getCompletedCommits() {
        if (this.completedCommits == null) {
            this.completedCommits = new IdentityHashtable();
        }
        return this.completedCommits;
    }

    protected boolean hasDataModifications() {
        return this.dataModifications != null && !this.dataModifications.isEmpty();
    }

    protected Hashtable getDataModifications() {
        if (this.dataModifications == null) {
            this.dataModifications = new Hashtable(10);
        }
        return this.dataModifications;
    }

    protected boolean hasObjectsToDelete() {
        return this.objectsToDelete != null && !this.objectsToDelete.isEmpty();
    }

    protected Vector getObjectsToDelete() {
        if (this.objectsToDelete == null) {
            this.objectsToDelete = new Vector(5);
        }
        return this.objectsToDelete;
    }

    protected IdentityHashtable getProcessedCommits() {
        if (this.processedCommits == null) {
            this.processedCommits = new IdentityHashtable();
        }
        return this.processedCommits;
    }

    protected IdentityHashtable getPendingCommits() {
        if (this.pendingCommits == null) {
            this.pendingCommits = new IdentityHashtable();
        }
        return this.pendingCommits;
    }

    protected IdentityHashtable getPostModifyCommits() {
        if (this.postModifyCommits == null) {
            this.postModifyCommits = new IdentityHashtable();
        }
        return this.postModifyCommits;
    }

    protected IdentityHashtable getPreModifyCommits() {
        if (this.preModifyCommits == null) {
            this.preModifyCommits = new IdentityHashtable();
        }
        return this.preModifyCommits;
    }

    protected Session getSession() {
        return this.session;
    }

    protected IdentityHashtable getShallowCommits() {
        if (this.shallowCommits == null) {
            this.shallowCommits = new IdentityHashtable();
        }
        return this.shallowCommits;
    }

    public void initializeCommitOrder() {
        int n;
        Vector vector = Helper.buildVectorFromMapElements(this.getSession().getDescriptors());
        vector = Helper.addAllUniqueToVector(new Vector(vector.size()), vector);
        Object[] objectArray = new Object[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            objectArray[n] = vector.elementAt(n);
        }
        TOPSort.quicksort(objectArray, new DescriptorCompare());
        vector = new Vector(vector.size());
        for (n = 0; n < objectArray.length; ++n) {
            vector.addElement(objectArray[n]);
        }
        CommitOrderCalculator commitOrderCalculator = new CommitOrderCalculator(this.getSession());
        commitOrderCalculator.addNodes(vector);
        commitOrderCalculator.calculateMappingDependencies();
        commitOrderCalculator.orderCommits();
        vector = commitOrderCalculator.getOrderedDescriptors();
        commitOrderCalculator = new CommitOrderCalculator(this.getSession());
        commitOrderCalculator.addNodes(vector);
        commitOrderCalculator.calculateSpecifiedDependencies();
        commitOrderCalculator.orderCommits();
        this.setCommitOrder(commitOrderCalculator.getOrderedClasses());
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isCommitCompleted(Object object) {
        return this.getCompletedCommits().containsKey(object);
    }

    public boolean isCommitInPostModify(Object object) {
        return this.getPostModifyCommits().containsKey(object);
    }

    public boolean isCommitInPreModify(Object object) {
        return this.getPreModifyCommits().containsKey(object);
    }

    public boolean isShallowCommitted(Object object) {
        return this.getShallowCommits().containsKey(object);
    }

    public void markCommitCompleted(Object object) {
        this.getPreModifyCommits().remove(object);
        this.getPostModifyCommits().remove(object);
        if (!this.isActive() && this.getPostModifyCommits().isEmpty() && this.getPreModifyCommits().isEmpty()) {
            this.reinitialize();
            return;
        }
        this.getCompletedCommits().put(object, object);
    }

    public void markPostModifyCommitInProgress(Object object) {
        this.getPreModifyCommits().remove(object);
        this.getPostModifyCommits().put(object, object);
    }

    public void markPreModifyCommitInProgress(Object object) {
        this.removePendingCommit(object);
        this.addProcessedCommit(object);
        this.getPreModifyCommits().put(object, object);
    }

    public void markShallowCommit(Object object) {
        this.getShallowCommits().put(object, object);
    }

    public void reinitialize() {
        this.setPendingCommits(null);
        this.setProcessedCommits(null);
        this.setPreModifyCommits(null);
        this.setPostModifyCommits(null);
        this.setCompletedCommits(null);
        this.setShallowCommits(null);
        this.setObjectsToDelete(null);
        this.setDataModifications(null);
    }

    protected void removePendingCommit(Object object) {
        this.getPendingCommits().remove(object);
    }

    public void setCommitOrder(Vector vector) {
        this.commitOrder = vector;
    }

    protected void setCompletedCommits(IdentityHashtable identityHashtable) {
        this.completedCommits = identityHashtable;
    }

    protected void setDataModifications(Hashtable hashtable) {
        this.dataModifications = hashtable;
    }

    public void setIsActive(boolean bl) {
        this.isActive = bl;
    }

    protected void setObjectsToDelete(Vector vector) {
        this.objectsToDelete = vector;
    }

    protected void setPendingCommits(IdentityHashtable identityHashtable) {
        this.pendingCommits = identityHashtable;
    }

    protected void setProcessedCommits(IdentityHashtable identityHashtable) {
        this.processedCommits = identityHashtable;
    }

    protected void setPostModifyCommits(IdentityHashtable identityHashtable) {
        this.postModifyCommits = identityHashtable;
    }

    protected void setPreModifyCommits(IdentityHashtable identityHashtable) {
        this.preModifyCommits = identityHashtable;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected void setShallowCommits(IdentityHashtable identityHashtable) {
        this.shallowCommits = identityHashtable;
    }

    public String toString() {
        int n = 0;
        if (this.preModifyCommits != null) {
            n += this.getPreModifyCommits().size();
        }
        if (this.postModifyCommits != null) {
            n += this.getPostModifyCommits().size();
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("commit_depth", objectArray);
    }
}

