/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.security;

import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.internal.security.Securable;

public class SecurableObjectHolder {
    private static final String JCE_ENCRYPTION_CLASS_NAME = "oracle.toplink.internal.security.JCEEncryptor";
    private String m_securableClassName;
    private Securable m_securableObject = null;
    static /* synthetic */ Class class$java$lang$Class;

    public SecurableObjectHolder() {
        this(null);
    }

    public SecurableObjectHolder(String string) {
        this.m_securableClassName = string;
    }

    public void setEncryptionClassName(String string) {
        this.m_securableClassName = string;
    }

    public Securable getSecurableObject() {
        if (this.m_securableObject == null) {
            this.initSecurableObject();
        }
        return this.m_securableObject;
    }

    public boolean hasSecurableObject() {
        return this.m_securableObject != null;
    }

    private void initSecurableObject() {
        boolean bl = false;
        if (this.m_securableClassName == null) {
            bl = true;
            this.m_securableClassName = JCE_ENCRYPTION_CLASS_NAME;
        }
        try {
            ConversionManager conversionManager = ConversionManager.getDefaultManager();
            Class clazz = (Class)conversionManager.convertObject(this.m_securableClassName, class$java$lang$Class == null ? (class$java$lang$Class = SecurableObjectHolder.class$("java.lang.Class")) : class$java$lang$Class);
            this.m_securableObject = (Securable)PrivilegedAccessController.newInstanceFromClass(clazz);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.m_securableObject = new PassThroughEncryptor();
            }
            throw ValidationException.invalidEncryptionClass(this.m_securableClassName, throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PassThroughEncryptor
    implements Securable {
        private PassThroughEncryptor() {
        }

        public String encryptPassword(String string) {
            return string;
        }

        public String decryptPassword(String string) {
            return string;
        }
    }
}

