/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.tools.sessionconfiguration.XMLLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public class PrivilegedAccessController {
    private static boolean shouldUsePrivilegedAccess = false;
    private static boolean shouldSecurityManagerBeChecked = true;

    private static Field findDeclaredField(Class clazz, String string) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                throw noSuchFieldException;
            }
            return PrivilegedAccessController.findDeclaredField(clazz2, string);
        }
    }

    private static Method findMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                throw noSuchMethodException;
            }
            try {
                return PrivilegedAccessController.findMethod(clazz2, string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw noSuchMethodException;
            }
        }
    }

    public static Class getClassForName(final String string) throws ClassNotFoundException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Class.forName(string);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
        }
        return Class.forName(string);
    }

    public static Class getClassForName(final String string, final boolean bl, final ClassLoader classLoader) throws ClassNotFoundException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Class.forName(string, bl, classLoader);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
        }
        return Class.forName(string, bl, classLoader);
    }

    public static ClassLoader getClassLoaderForClass(final Class clazz) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    public static Constructor getConstructorFor(final Class clazz, final Class[] classArray, final boolean bl) throws NoSuchMethodException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        Constructor constructor = clazz.getConstructor(classArray);
                        if (bl) {
                            constructor.setAccessible(true);
                        }
                        return constructor;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
        }
        Constructor constructor = clazz.getConstructor(classArray);
        if (bl) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    public static ClassLoader getContextClassLoader(final Thread thread) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return thread.getContextClassLoader();
                }
            });
        }
        return thread.getContextClassLoader();
    }

    public static Constructor getDeclaredConstructorFor(final Class clazz, final Class[] classArray, final boolean bl) throws NoSuchMethodException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        Constructor constructor = clazz.getDeclaredConstructor(classArray);
                        if (bl) {
                            constructor.setAccessible(true);
                        }
                        return constructor;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
        }
        Constructor constructor = clazz.getDeclaredConstructor(classArray);
        if (bl) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    public static Field getDeclaredField(final Class clazz, final String string, final boolean bl) throws NoSuchFieldException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchFieldException {
                        Field field = PrivilegedAccessController.findDeclaredField(clazz, string);
                        if (bl) {
                            field.setAccessible(true);
                        }
                        return field;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchFieldException)privilegedActionException.getException();
            }
        }
        Field field = PrivilegedAccessController.findDeclaredField(clazz, string);
        if (bl) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field[] getDeclaredFields(final Class clazz) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getDeclaredFields();
                }
            });
        }
        return clazz.getDeclaredFields();
    }

    public static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray) throws NoSuchMethodException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        return clazz.getDeclaredMethod(string, classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
        }
        return clazz.getDeclaredMethod(string, classArray);
    }

    public static Method getMethod(final Class clazz, final String string, final Class[] classArray, final boolean bl) throws NoSuchMethodException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        Method method = PrivilegedAccessController.findMethod(clazz, string, classArray);
                        if (bl) {
                            method.setAccessible(true);
                        }
                        return method;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
        }
        Method method = PrivilegedAccessController.findMethod(clazz, string, classArray);
        if (bl) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method[] getDeclaredMethods(final Class clazz) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getDeclaredMethods();
                }
            });
        }
        return clazz.getDeclaredMethods();
    }

    public static Field[] getFields(final Class clazz) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getFields();
                }
            });
        }
        return clazz.getFields();
    }

    public static Class getFieldType(final Field field) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return field.getType();
                }
            });
        }
        return field.getType();
    }

    public static String getLineSeparator() {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("file.separator");
                }
            });
        }
        return Helper.cr();
    }

    public static Class[] getMethodParameterTypes(final Method method) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Class[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return method.getParameterTypes();
                }
            });
        }
        return method.getParameterTypes();
    }

    public static Class getMethodReturnType(final Method method) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return method.getReturnType();
                }
            });
        }
        return method.getReturnType();
    }

    public static Object getValueFromField(final Field field, final Object object) throws IllegalAccessException {
        if (shouldUsePrivilegedAccess) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException {
                        return field.get(object);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IllegalAccessException)privilegedActionException.getException();
            }
        }
        return field.get(object);
    }

    public static int getIntValueFromField(final Field field, final Object object) throws IllegalAccessException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException {
                        return new Integer(field.getInt(object));
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IllegalAccessException)privilegedActionException.getException();
            }
        }
        return field.getInt(object);
    }

    public static Object invokeConstructor(final Constructor constructor, final Object[] objectArray) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InvocationTargetException, InstantiationException {
                        return constructor.newInstance(objectArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IllegalAccessException) {
                    throw (IllegalAccessException)exception;
                }
                if (exception instanceof InstantiationException) {
                    throw (InstantiationException)exception;
                }
                throw (InvocationTargetException)exception;
            }
        }
        return constructor.newInstance(objectArray);
    }

    public static Object invokeMethod(final Method method, final Object object, final Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InvocationTargetException {
                        return method.invoke(object, objectArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IllegalAccessException) {
                    throw (IllegalAccessException)exception;
                }
                throw (InvocationTargetException)exception;
            }
        }
        return method.invoke(object, objectArray);
    }

    public static void loadDeploymentXML(final XMLLoader xMLLoader, final SessionManager sessionManager, final ClassLoader classLoader, final boolean bl, final boolean bl2) {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    xMLLoader.loadInternal(sessionManager, classLoader, bl, bl2);
                    return null;
                }
            });
        } else {
            xMLLoader.loadInternal(sessionManager, classLoader, bl, bl2);
        }
    }

    public static Object newInstanceFromClass(final Class clazz) throws IllegalAccessException, InstantiationException {
        if (PrivilegedAccessController.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, InstantiationException {
                        return clazz.newInstance();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IllegalAccessException) {
                    throw (IllegalAccessException)exception;
                }
                throw (InstantiationException)exception;
            }
        }
        return clazz.newInstance();
    }

    public static void setValueInField(final Field field, final Object object, final Object object2) throws IllegalAccessException {
        if (shouldUsePrivilegedAccess) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException {
                        field.set(object, object2);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IllegalAccessException)privilegedActionException.getException();
            }
        } else {
            field.set(object, object2);
        }
    }

    private static boolean shouldUsePrivilegedAccess() {
        if (shouldSecurityManagerBeChecked) {
            shouldSecurityManagerBeChecked = false;
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("oracle.j2ee.toplink.security.usedoprivileged");
                    String string2 = System.getProperty("oracle.j2ee.security.usedoprivileged");
                    boolean bl = string != null && string.equalsIgnoreCase("false") || string2 != null && string2.equalsIgnoreCase("false");
                    return new Boolean(bl);
                }
            });
            shouldUsePrivilegedAccess = bl != false ? false : System.getSecurityManager() != null;
        }
        return shouldUsePrivilegedAccess;
    }
}

