/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.remote;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.helper.ConcurrencyManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.InvalidObject;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.Transporter;
import oracle.toplink.internal.sessions.CommitManager;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.threetier.ServerSession;

public class RemoteUnitOfWork
extends UnitOfWorkImpl {
    protected Vector newObjectsCache;
    protected Vector unregisteredNewObjectsCache;
    protected boolean isOnClient = true;
    protected transient RemoteSessionController parentSessionController;

    public RemoteUnitOfWork(RemoteUnitOfWork remoteUnitOfWork) {
        super(remoteUnitOfWork);
    }

    public RemoteUnitOfWork(RemoteSession remoteSession) {
        super(remoteSession);
    }

    public UnitOfWork acquireUnitOfWork() {
        this.log(2, "transaction", "acquire_unit_of_work");
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        RemoteUnitOfWork remoteUnitOfWork = new RemoteUnitOfWork(this);
        remoteUnitOfWork.discoverAllUnregisteredNewObjectsInParent();
        return remoteUnitOfWork;
    }

    protected Vector collectNewObjects() {
        return Helper.buildVectorFromHashtableElements(this.getNewObjectsCloneToOriginal());
    }

    protected Vector collectUnregisteredNewObjects() {
        this.discoverAllUnregisteredNewObjects();
        return Helper.buildVectorFromHashtableElements(this.getUnregisteredNewObjects());
    }

    protected void commitIntoRemoteUnitOfWork() {
        ((UnitOfWork)this.getParent()).setWasTransactionBegunPrematurely(this.wasTransactionBegunPrematurely());
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeWorkingCopyIntoRemote();
        Enumeration enumeration = ((IdentityHashtable)this.getCloneMapping().clone()).keys();
        while (enumeration.hasMoreElements()) {
            mergeManager.mergeChanges(enumeration.nextElement(), null);
        }
    }

    public void commitRootUnitOfWork() {
        RemoteUnitOfWork remoteUnitOfWork;
        if (!this.isOnClient()) {
            if (this.isSynchronized()) {
                if (this.getParent().wasJTSTransactionInternallyStarted()) {
                    this.commitInternallyStartedExternalTransaction();
                }
                return;
            }
            this.getEventManager().preCommitUnitOfWork();
            super.commitRootUnitOfWork();
            this.getEventManager().postCommitUnitOfWork();
            return;
        }
        this.setNewObjectsCache(this.collectNewObjects());
        this.setUnregisteredNewObjectsCache(this.collectUnregisteredNewObjects());
        try {
            remoteUnitOfWork = ((RemoteSession)this.getParent()).getRemoteConnection().commitRootUnitOfWork(this);
        }
        catch (RuntimeException runtimeException) {
            if (this.wasTransactionBegunPrematurely()) {
                this.getParent().getTransactionMutex().release();
            }
            this.setWasTransactionBegunPrematurely(false);
            throw runtimeException;
        }
        if (this.wasTransactionBegunPrematurely()) {
            this.getParent().getTransactionMutex().release();
        }
        remoteUnitOfWork.setParent(this);
        remoteUnitOfWork.setProject(this.getProject());
        remoteUnitOfWork.prepareForMergeIntoRemoteUnitOfWork();
        remoteUnitOfWork.commitIntoRemoteUnitOfWork();
        this.commitRootUnitOfWorkOnClient();
    }

    protected void commitRootUnitOfWorkOnClient() {
        IdentityHashtable identityHashtable = this.collectAndPrepareObjectsForNestedMerge();
        this.setAllClonesCollection(identityHashtable);
        UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (unitOfWorkChangeSet == null) {
            this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
            unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
            this.calculateChanges(this.getAllClones(), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
        }
        Enumeration enumeration = unitOfWorkChangeSet.getNewObjectChangeSets().elements();
        while (enumeration.hasMoreElements()) {
            IdentityHashtable identityHashtable2 = (IdentityHashtable)enumeration.nextElement();
            Enumeration enumeration2 = identityHashtable2.keys();
            while (enumeration2.hasMoreElements()) {
                unitOfWorkChangeSet.putNewObjectInChangesList((ObjectChangeSet)enumeration2.nextElement(), this);
            }
        }
        this.mergeChangesIntoParent();
    }

    protected void discoverAllUnregisteredNewObjects() {
        IdentityHashtable identityHashtable = new IdentityHashtable();
        IdentityHashtable identityHashtable2 = new IdentityHashtable();
        Enumeration enumeration = this.getCloneMapping().keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.discoverUnregisteredNewObjects(e, identityHashtable2, this.getUnregisteredExistingObjects(), identityHashtable);
        }
        this.setUnregisteredNewObjects(identityHashtable2);
    }

    public Object executeQuery(String string) throws DatabaseException {
        return this.executeQuery(string, new Vector(1));
    }

    public Object executeQuery(String string, Class clazz) throws DatabaseException {
        return this.executeQuery(string, clazz, new Vector(1));
    }

    public Object executeQuery(String string, Class clazz, Vector vector) throws DatabaseException {
        Serializable serializable;
        RemoteSession remoteSession = null;
        if (this.getParent().isRemoteSession()) {
            remoteSession = (RemoteSession)this.getParent();
        } else {
            serializable = (RemoteUnitOfWork)this.getParent();
            while (((UnitOfWork)serializable).getParent().isRemoteUnitOfWork()) {
                serializable = (RemoteUnitOfWork)((UnitOfWork)serializable).getParent();
            }
            remoteSession = (RemoteSession)((UnitOfWork)serializable).getParent();
        }
        serializable = remoteSession.getRemoteConnection().remoteExecuteNamedQuery(string, clazz, vector);
        ((Transporter)serializable).getQuery().setSession(this);
        return ((Transporter)serializable).getQuery().extractRemoteResult((Transporter)serializable);
    }

    public Object executeQuery(String string, Vector vector) throws DatabaseException {
        if (this.containsQuery(string)) {
            return super.executeQuery(string, vector);
        }
        return this.executeQuery(string, null, vector);
    }

    public Descriptor getDescriptor(Class clazz) {
        return this.getParent().getDescriptor(clazz);
    }

    public Vector getNewObjectsCache() {
        return this.newObjectsCache;
    }

    public RemoteSessionController getParentSessionController() {
        return this.parentSessionController;
    }

    public DatabasePlatform getPlatform() {
        return this.getParent().getPlatform();
    }

    public Platform getDatasourcePlatform() {
        return this.getParent().getDatasourcePlatform();
    }

    public Vector getUnregisteredNewObjectsCache() {
        return this.unregisteredNewObjectsCache;
    }

    public Object internalExecuteQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow) throws DatabaseException, QueryException {
        if (!this.isActive()) {
            throw QueryException.querySentToInactiveUnitOfWork(databaseQuery);
        }
        if (this.isOnClient()) {
            Object object;
            boolean bl;
            boolean bl2 = bl = databaseQuery.isObjectLevelReadQuery() && !databaseQuery.isReportQuery() && databaseQuery.shouldMaintainCache();
            if (bl) {
                object = (ObjectLevelReadQuery)databaseQuery;
                if (this.isAfterWriteChangesButBeforeCommit()) {
                    throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "executeQuery(ObjectLevelReadQuery)");
                }
                Object object2 = ((ObjectLevelReadQuery)object).checkEarlyReturn(this, databaseRow);
                if (object2 != null) {
                    if (object2 == InvalidObject.instance) {
                        return null;
                    }
                    return object2;
                }
                if (((ObjectLevelReadQuery)object).isLockQuery(this) && !this.wasTransactionBegunPrematurely()) {
                    this.beginEarlyTransaction();
                }
            } else if (databaseQuery.isObjectLevelModifyQuery()) {
                return databaseQuery.executeInUnitOfWork(this, databaseRow);
            }
            if (!this.getCommitManager().isActive() && databaseQuery.isDataModifyQuery() && !this.wasTransactionBegunPrematurely()) {
                this.beginEarlyTransaction();
            }
            object = this.getParent().executeQuery(databaseQuery, databaseRow);
            if (bl) {
                object = ((ObjectLevelReadQuery)databaseQuery).registerResultInUnitOfWork(object, this, databaseRow, false);
            }
            return object;
        }
        return databaseQuery.executeInUnitOfWork(this, databaseRow);
    }

    protected boolean isOnClient() {
        return this.isOnClient;
    }

    public boolean isRemoteUnitOfWork() {
        return true;
    }

    protected void prepareForMergeIntoRemoteUnitOfWork() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        IdentityHashtable identityHashtable = new IdentityHashtable();
        IdentityHashtable identityHashtable2 = new IdentityHashtable();
        Enumeration enumeration = this.getNewObjectsCache().elements();
        Enumeration enumeration2 = ((RemoteUnitOfWork)this.getParent()).getNewObjectsCache().elements();
        while (enumeration.hasMoreElements()) {
            object4 = ((RemoteUnitOfWork)this.getParent()).getNewObjectsOriginalToClone().get(enumeration2.nextElement());
            object3 = this.getNewObjectsOriginalToClone().get(enumeration.nextElement());
            if (object3 == null) continue;
            identityHashtable.put(object4, object3);
            identityHashtable2.put(object3, object4);
        }
        object4 = this.getUnregisteredNewObjectsCache().elements();
        object3 = ((RemoteUnitOfWork)this.getParent()).getUnregisteredNewObjectsCache().elements();
        while (object4.hasMoreElements()) {
            object2 = ((RemoteUnitOfWork)this.getParent()).getUnregisteredNewObjects().get(object3.nextElement());
            object = this.getUnregisteredNewObjects().get(object4.nextElement());
            identityHashtable.put(object2, object);
            identityHashtable2.put(object, object2);
        }
        this.setNewObjectsOriginalToClone(identityHashtable);
        this.setNewObjectsCloneToOriginal(identityHashtable2);
        object2 = new IdentityHashtable();
        object = this.getObjectsDeletedDuringCommit().keys();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            Vector vector = this.keyFromObject(e);
            Object object5 = this.getParent().getIdentityMapAccessor().getFromIdentityMap(vector, e.getClass());
            if (object5 == null && (object5 = identityHashtable2.get(e)) == null) {
                object5 = e;
            }
            ((IdentityHashtable)object2).put(object5, this.keyFromObject(object5));
            ((UnitOfWork)this.getParent()).getIdentityMapAccessor().removeFromIdentityMap(object5);
        }
        ((UnitOfWork)this.getParent()).setObjectsDeletedDuringCommit((IdentityHashtable)object2);
    }

    public void reinitializeForSession(Session session, RemoteSessionController remoteSessionController) {
        if (session.isServerSession()) {
            session = ((ServerSession)session).acquireClientSession();
        }
        this.setIsOnClient(false);
        this.setParentSessionController(remoteSessionController);
        this.setParent(session);
        this.setProject(session.getProject());
        this.setProfiler(this.getProfiler());
        this.setEventManager(session.getEventManager().clone(this));
        this.setSessionLog(session.getSessionLog());
        this.setLog(session.getLog());
        this.setCommitManager(new CommitManager(this));
        this.setTransactionMutex(new ConcurrencyManager());
        this.getCommitManager().setCommitOrder(session.getCommitManager().getCommitOrder());
        if (this.getParent().hasExternalTransactionController()) {
            this.getParent().getExternalTransactionController().registerSynchronizationListener(this, this.getParent());
        }
    }

    protected void setIsOnClient(boolean bl) {
        this.isOnClient = bl;
    }

    protected void setNewObjectsCache(Vector vector) {
        this.newObjectsCache = vector;
    }

    public void setParentSessionController(RemoteSessionController remoteSessionController) {
        this.parentSessionController = remoteSessionController;
    }

    protected void setUnregisteredNewObjectsCache(Vector vector) {
        this.unregisteredNewObjectsCache = vector;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "()";
    }

    public boolean verifyDelete(Object object) {
        return this.getParent().verifyDelete(object);
    }
}

