/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.queryframework.CollectionContainerPolicy;
import oracle.toplink.internal.queryframework.ListContainerPolicy;
import oracle.toplink.internal.queryframework.MapContainerPolicy;
import oracle.toplink.internal.queryframework.SortedCollectionContainerPolicy;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.internal.sessions.CollectionChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.CursoredStreamPolicy;
import oracle.toplink.queryframework.DataReadQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.ScrollableCursorPolicy;

public abstract class ContainerPolicy
implements Cloneable,
Serializable {
    protected transient Descriptor elementDescriptor;
    protected transient Constructor constructor;

    protected boolean addInto(Object object, Object object2, Object object3) {
        throw QueryException.cannotAddToContainer(object2, object3, this);
    }

    public boolean addInto(Object object, Object object2, Session session) {
        return this.addInto(null, object, object2, session);
    }

    public boolean addInto(Object object, Object object2, Object object3, Session session) {
        Object object4 = object2;
        if (this.hasElementDescriptor()) {
            object4 = this.getElementDescriptor().getObjectBuilder().wrapObject(object2, session);
        }
        return this.addInto(object, object4, object3);
    }

    public void addIntoWithOrder(Integer n, Object object, Object object2) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public void addIntoWithOrder(Integer n, Object object, Object object2, Session session) {
        Object object3 = object;
        if (this.hasElementDescriptor()) {
            object3 = this.getElementDescriptor().getObjectBuilder().wrapObject(object, session);
        }
        this.addIntoWithOrder(n, object3, object2);
    }

    public void addIntoWithOrder(Vector vector, Hashtable hashtable, Object object, Session session) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public Object buildContainerFromVector(Vector vector, Session session) {
        Object object = this.containerInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addInto(enumeration.nextElement(), object, session);
        }
        return object;
    }

    public static ContainerPolicy buildPolicyFor(Class clazz) {
        if (Helper.classImplementsInterface(clazz, ClassConstants.List_Class)) {
            return new ListContainerPolicy(clazz);
        }
        if (Helper.classImplementsInterface(clazz, ClassConstants.SortedSet_Class)) {
            return new SortedCollectionContainerPolicy(clazz);
        }
        if (Helper.classImplementsInterface(clazz, ClassConstants.Collection_Class)) {
            return new CollectionContainerPolicy(clazz);
        }
        if (Helper.classImplementsInterface(clazz, ClassConstants.Map_Class)) {
            return new MapContainerPolicy(clazz);
        }
        if (clazz.equals(ClassConstants.CursoredStream_Class)) {
            return new CursoredStreamPolicy();
        }
        if (clazz.equals(ClassConstants.ScrollableCursor_Class)) {
            return new ScrollableCursorPolicy();
        }
        throw ValidationException.illegalContainerClass(clazz);
    }

    public void clear(Object object) {
        throw QueryException.methodNotValid(this, "clear(Object container)");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ContainerPolicy clone(ReadQuery readQuery) {
        return (ContainerPolicy)this.clone();
    }

    public Object cloneFor(Object object) {
        throw QueryException.cannotCreateClone(this, object);
    }

    public boolean compareKeys(Object object, Session session) {
        return true;
    }

    public Object concatenateContainers(Object object, Object object2) {
        Object object3 = this.containerInstance(this.sizeFor(object) + this.sizeFor(object2));
        Object object4 = this.iteratorFor(object);
        while (this.hasNext(object4)) {
            this.addInto(null, this.next(object4), object3);
        }
        object4 = this.iteratorFor(object2);
        while (this.hasNext(object4)) {
            this.addInto(null, this.next(object4), object3);
        }
        return object3;
    }

    public Object containerInstance() {
        try {
            return PrivilegedAccessController.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception exception) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception);
        }
    }

    public Object containerInstance(int n) {
        if (this.getConstructor() == null) {
            return this.containerInstance();
        }
        try {
            Object[] objectArray = new Object[]{new Integer(n)};
            return PrivilegedAccessController.invokeConstructor(this.getConstructor(), objectArray);
        }
        catch (Exception exception) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception);
        }
    }

    protected boolean contains(Object object, Object object2) {
        throw QueryException.methodNotValid(this, "contains(Object element, Object container)");
    }

    public boolean contains(Object object, Object object2, Session session) {
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object object3 = this.iteratorFor(object2);
            while (this.hasNext(object3)) {
                Object object4 = this.next(object3);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(object4, session).equals(object)) continue;
                return true;
            }
            return false;
        }
        return this.contains(object, object2);
    }

    protected boolean containsKey(Object object, Object object2) {
        throw QueryException.methodNotValid(this, "containsKey(Object element, Object container)");
    }

    public Object execute() {
        throw QueryException.methodNotValid(this, "execute()");
    }

    protected Constructor getConstructor() {
        return this.constructor;
    }

    public Class getContainerClass() {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public String getContainerClassName() {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public Descriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public boolean hasElementDescriptor() {
        return this.getElementDescriptor() != null;
    }

    public abstract boolean hasNext(Object var1);

    public boolean hasOrder() {
        return false;
    }

    public void initializeConstructor() {
        try {
            this.setConstructor(PrivilegedAccessController.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false));
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isCollectionPolicy() {
        return false;
    }

    public boolean isCursoredStreamPolicy() {
        return false;
    }

    public boolean isCursorPolicy() {
        return false;
    }

    public boolean isCursorStreamPolicy() {
        return false;
    }

    public boolean isDirectMapPolicy() {
        return false;
    }

    public boolean isEmpty(Object object) {
        return this.sizeFor(object) == 0;
    }

    public boolean isListPolicy() {
        return false;
    }

    public boolean isMapPolicy() {
        return false;
    }

    public boolean isScrollableCursorPolicy() {
        return false;
    }

    public boolean isValidContainer(Object object) {
        throw QueryException.methodNotValid(this, "isValidContainer(Object container)");
    }

    public boolean isValidContainerType(Class clazz) {
        throw QueryException.methodNotValid(this, "isValidContainerType(Class containerType)");
    }

    public abstract Object iteratorFor(Object var1);

    public Object keyFrom(Object object, Session session) {
        return null;
    }

    protected abstract Object next(Object var1);

    public Object next(Object object, Session session) {
        Object object2 = this.next(object);
        if (this.hasElementDescriptor()) {
            object2 = this.getElementDescriptor().getObjectBuilder().unwrapObject(object2, session);
        }
        return object2;
    }

    public boolean overridesRead() {
        return false;
    }

    public void prepare(DatabaseQuery databaseQuery, Session session) throws QueryException {
        if (databaseQuery.isReadAllQuery() && !databaseQuery.isReportQuery() && databaseQuery.shouldUseWrapperPolicy()) {
            this.setElementDescriptor(databaseQuery.getDescriptor());
        } else if (databaseQuery.isDataReadQuery()) {
            ((DataReadQuery)databaseQuery).setContainerPolicy(this);
        }
    }

    public void prepareForExecution() throws QueryException {
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(objectChangeSet)) {
            collectionChangeRecord.getRemoveObjectList().remove(objectChangeSet);
        } else {
            collectionChangeRecord.getAddObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(objectChangeSet)) {
            collectionChangeRecord.getAddObjectList().remove(objectChangeSet);
        } else {
            collectionChangeRecord.getRemoveObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public Object remoteExecute() {
        return null;
    }

    public void removeAllElements(Object object) {
        this.clear(object);
    }

    protected boolean removeFrom(Object object, Object object2, Object object3) {
        throw QueryException.cannotRemoveFromContainer(object2, object3, this);
    }

    public boolean removeFrom(Object object, Object object2, Object object3, Session session) {
        Object object4 = object2;
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object object5 = this.iteratorFor(object3);
            while (this.hasNext(object5)) {
                Object object6 = this.next(object5);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(object6, session).equals(object2)) continue;
                object4 = object6;
                break;
            }
        }
        return this.removeFrom(object, object4, object3);
    }

    public boolean removeFrom(Object object, Object object2, Session session) {
        return this.removeFrom(null, object, object2, session);
    }

    public void removeFromWithOrder(int n, Object object) {
        throw QueryException.methodDoesNotExistInContainerClass("remove(index)", this.getContainerClass());
    }

    protected void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public void setContainerClass(Class clazz) {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public void setContainerClassName(String string) {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public void setElementDescriptor(Descriptor descriptor) {
        this.elementDescriptor = descriptor;
    }

    public void setKeyMethod(String string, Class clazz) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, string);
    }

    public int sizeFor(Object object) {
        throw QueryException.methodNotValid(this, "sizeFor(Object container)");
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.toStringInfo() + ")";
    }

    protected Object toStringInfo() {
        return "";
    }

    public void validateElementAndRehashIfRequired(Object object, Object object2, Session session, Object object3) {
    }

    public Vector vectorFor(Object object, Session session) {
        Vector<Object> vector = new Vector<Object>(this.sizeFor(object));
        Object object2 = this.iteratorFor(object);
        while (this.hasNext(object2)) {
            vector.addElement(this.next(object2, session));
        }
        return vector;
    }
}

