/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.platform.database.oracle;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.ZONEIDMAP;
import oracle.toplink.Version;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.platform.database.oracle.TIMESTAMPLTZWrapper;
import oracle.toplink.internal.platform.database.oracle.TIMESTAMPTZWrapper;

public class TIMESTAMPHelper {
    public static TIMESTAMPTZ buildTIMESTAMPTZ(Calendar calendar, Connection connection) {
        try {
            return new TIMESTAMPTZ(connection, Helper.printCalendar(calendar, false), calendar);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static Calendar buildCalendar(TIMESTAMPTZWrapper tIMESTAMPTZWrapper) throws SQLException {
        Timestamp timestamp = tIMESTAMPTZWrapper.getTimestamp();
        TimeZone timeZone = tIMESTAMPTZWrapper.getTimeZone();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        calendar.getTimeZone().setID(timeZone.getID());
        calendar.getTimeZone().setRawOffset(timeZone.getRawOffset());
        TIMESTAMPHelper.assignMillisecond(calendar, timestamp);
        return calendar;
    }

    public static Calendar buildCalendar(TIMESTAMPLTZWrapper tIMESTAMPLTZWrapper) throws SQLException {
        Calendar calendar = tIMESTAMPLTZWrapper.getZoneId() != null ? Calendar.getInstance(TimeZone.getTimeZone(tIMESTAMPLTZWrapper.getZoneId())) : Calendar.getInstance();
        Calendar calendar2 = Helper.allocateCalendar();
        calendar2.setTime(tIMESTAMPLTZWrapper.getTimestamp());
        calendar.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), calendar2.get(11), calendar2.get(12), calendar2.get(13));
        Helper.releaseCalendar(calendar2);
        calendar.set(14, tIMESTAMPLTZWrapper.getTimestamp().getNanos() / 1000000);
        return calendar;
    }

    public static void assignMillisecond(Calendar calendar, Timestamp timestamp) {
        if (Version.isJDK13() && (double)calendar.get(14) * 1000000.0 != (double)timestamp.getNanos()) {
            calendar.set(14, (int)((double)timestamp.getNanos() / 1000000.0));
        }
    }

    public static String printCalendar(Calendar calendar) {
        if (calendar == null) {
            return "null";
        }
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.printCalendar(calendar, false));
        stringWriter.write(" ");
        stringWriter.write(calendar.getTimeZone().getID());
        return stringWriter.toString();
    }

    public static TimeZone extractTimeZone(byte[] byArray) {
        String string = null;
        if ((byArray[11] & 0xFFFFFF80) != 0) {
            int n = (byArray[11] & 0x7F) << 6;
            string = new String(ZONEIDMAP.getRegion((int)(n += (byArray[12] & 0xFC) >> 2)));
        } else {
            int n = byArray[11] - 20;
            int n2 = byArray[12] - 60;
            String string2 = Helper.buildZeroPrefix(n, 2) + ":" + Helper.buildZeroPrefix(n2, 2);
            string = "GMT" + string2;
        }
        return TimeZone.getTimeZone(string);
    }
}

