/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.MemberOfNode;
import oracle.toplink.internal.parsing.ParseTree;
import oracle.toplink.internal.parsing.ParseTreeContext;
import oracle.toplink.internal.parsing.SelectNode;
import oracle.toplink.publicinterface.Session;

public class SelectGenerationContext
extends GenerationContext {
    private boolean useParallelExpressions = false;
    private boolean shouldCheckSelectNodeBeforeResolving = false;
    private boolean isNotIndicatedInMemberOf = false;
    private MemberOfNode memberOfNode = null;
    private boolean shouldUseOuterJoins = false;

    public SelectGenerationContext() {
    }

    public SelectGenerationContext(ParseTreeContext parseTreeContext, Session session, ParseTree parseTree) {
        super(parseTreeContext, session, parseTree);
        this.useParallelExpressions = this.computeUseParallelExpressions();
    }

    public void setMemberOfNode(MemberOfNode memberOfNode) {
        this.memberOfNode = memberOfNode;
    }

    public MemberOfNode getMemberOfNode() {
        return this.memberOfNode;
    }

    private boolean computeUseParallelExpressions() {
        boolean bl = ((SelectNode)this.parseTree.getQueryNode()).hasOneToOneSelected(this);
        bl = bl || ((SelectNode)this.parseTree.getQueryNode()).isVariableInINClauseSelected(this) || this.parseTree.getContext().hasMoreThanOneVariablePerType() || this.parseTree.getContext().hasMoreThanOneAliasInFrom();
        return bl;
    }

    public boolean useParallelExpressions() {
        return this.useParallelExpressions;
    }

    public void checkSelectNodeBeforeResolving(boolean bl) {
        this.shouldCheckSelectNodeBeforeResolving = bl;
    }

    public boolean shouldCheckSelectNodeBeforeResolving() {
        return this.shouldCheckSelectNodeBeforeResolving;
    }

    public boolean shouldUseOuterJoins() {
        return this.shouldUseOuterJoins;
    }

    public void useOuterJoins() {
        this.shouldUseOuterJoins = true;
    }

    public void dontUseOuterJoins() {
        this.shouldUseOuterJoins = false;
    }

    public boolean hasMemberOfNode() {
        return this.memberOfNode != null;
    }
}

