/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.toplink.exceptions.EJBQLException;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.publicinterface.Descriptor;

public class ParseTreeContext {
    public static ClassLoader classLoader;
    private Hashtable nodes;
    private Hashtable variableTypes;

    public ParseTreeContext() {
        this.setVariableTypes(new Hashtable());
        this.setNodes(new Hashtable());
    }

    public String aliasForVariableName(String string) {
        return (String)this.getVariableTypes().get(string);
    }

    public boolean hasClassForVariableName(String string) {
        String string2 = (String)this.getVariableTypes().get(string);
        return string2 != null;
    }

    public Class classForSchemaName(String string, GenerationContext generationContext) {
        Descriptor descriptor = generationContext.getSession().getDescriptorForAlias(string);
        if (descriptor == null) {
            throw EJBQLException.missingDescriptorException(string);
        }
        Class clazz = descriptor.getJavaClass();
        if (clazz == null) {
            throw EJBQLException.resolutionClassNotFoundException(string);
        }
        return clazz;
    }

    public boolean hasVariableNameForClass(Class clazz, GenerationContext generationContext) {
        return this.getVariableNameForClass(clazz, generationContext) != null;
    }

    public String getVariableNameForClass(Class clazz, GenerationContext generationContext) {
        Enumeration enumeration = this.getVariableTypes().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.getVariableTypes().get(string);
            if (clazz != this.classForSchemaName(string2, generationContext)) continue;
            return string;
        }
        return null;
    }

    public boolean isDeclaredInINClause(String string) {
        return this.nodeForIdentifier(string) != null;
    }

    public Node nodeForIdentifier(String string) {
        return (Node)this.getNodes().get(string);
    }

    public void registerIdentifierWithNode(String string, Node node) {
        this.getNodes().put(string, node);
    }

    public void registerSchema(String string, String string2) {
        this.getVariableTypes().put(string, string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getVariableTypes().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(ToStringLocalization.buildMessage("name", null) + string + " " + ToStringLocalization.buildMessage("schema", null) + " " + this.getVariableTypes().get(string));
        }
        return stringBuffer.toString();
    }

    public Hashtable getNodes() {
        return this.nodes;
    }

    public void setNodes(Hashtable hashtable) {
        this.nodes = hashtable;
    }

    public Hashtable getVariableTypes() {
        return this.variableTypes;
    }

    public void setVariableTypes(Hashtable hashtable) {
        this.variableTypes = hashtable;
    }

    public boolean hasMoreThanOneVariablePerType() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.variableTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put((String)this.variableTypes.get(string), string);
        }
        return hashtable.size() != this.variableTypes.size();
    }

    public boolean hasMoreThanOneAliasInFrom() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.variableTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put((String)this.variableTypes.get(string), string);
        }
        return hashtable.size() > 1;
    }
}

