/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.internal.parsing.ParseTree;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;

public class OrderByNode
extends Node {
    Collection orderByItems = null;

    private void addOrderByItem(Object object) {
        this.getOrderByItems().add(object);
    }

    public void addOrderingToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.isReadAllQuery()) {
            Iterator iterator = this.getOrderByItems().iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                ((ReadAllQuery)objectLevelReadQuery).addOrdering(node.generateExpression(generationContext));
            }
        }
    }

    public void placeNode(Node node) {
        this.addOrderByItem(node);
    }

    public void placeNodeOnTree(ParseTree parseTree) {
        parseTree.setOrderByNode(this);
    }

    private Collection getOrderByItems() {
        if (this.orderByItems == null) {
            this.setOrderByItems(new Vector());
        }
        return this.orderByItems;
    }

    private void setOrderByItems(Collection collection) {
        this.orderByItems = collection;
    }
}

