/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.parsing.EscapeNode;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.internal.parsing.SimpleConditionalExpressionNode;

public class LikeNode
extends SimpleConditionalExpressionNode {
    private EscapeNode escape = null;

    public boolean containsNode(Node node) {
        boolean bl = false;
        if (this.hasLeft()) {
            boolean bl2 = bl = this.getLeft().containsNode(node) || this.getLeft() == node;
        }
        if (this.hasRight() && !bl) {
            bl = this.getRight().containsNode(node) || this.getRight() == node;
        }
        return bl;
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        expression = !this.hasEscape() ? expression.like(this.getRight().generateExpression(generationContext)) : expression.like(this.getRight().getAsString(), this.getEscapeNode().getAsString());
        return expression;
    }

    public void placeNode(Node node) {
        if (!this.hasLeft()) {
            this.setLeft(node);
        } else if (!this.hasRight()) {
            this.setRight(node);
        } else if (node.isEscape()) {
            this.setEscapeNode((EscapeNode)node);
        } else if (this.hasEscape()) {
            this.getEscapeNode().setLiteral(node);
        } else {
            node.placeNode(this);
        }
    }

    private boolean hasEscape() {
        return this.getEscapeNode() != null;
    }

    private EscapeNode getEscapeNode() {
        return this.escape;
    }

    private void setEscapeNode(EscapeNode escapeNode) {
        this.escape = escapeNode;
    }
}

