/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.LogicalOperatorNode;
import oracle.toplink.internal.parsing.VariableNode;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReportQuery;

public class DotNode
extends LogicalOperatorNode {
    public void applyToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        ReportQuery reportQuery = (ReportQuery)objectLevelReadQuery;
        reportQuery.addAttribute(this.resolveAttributeForSelect(generationContext), this.generateExpression(generationContext));
        reportQuery.returnSingleAttribute();
        reportQuery.dontRetrievePrimaryKeys();
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        expression = this.getRight().addToExpression(expression, generationContext);
        return expression;
    }

    public boolean isDotNode() {
        return true;
    }

    public boolean endsWithDirectToField(GenerationContext generationContext) {
        return this.resolveAttributeForSelect(generationContext) != null;
    }

    public String resolveAttributeForSelect(GenerationContext generationContext) {
        DatabaseMapping databaseMapping = this.getRight().resolveMapping(generationContext, this.getLeft().resolveClass(generationContext));
        if (databaseMapping != null && databaseMapping.isDirectToFieldMapping()) {
            return ((VariableNode)this.getRight()).getVariableName();
        }
        return null;
    }

    public DatabaseMapping resolveMapping(GenerationContext generationContext) {
        Class clazz = this.getLeft().resolveClass(generationContext);
        return this.getRight().resolveMapping(generationContext, clazz);
    }

    public Class resolveClass(GenerationContext generationContext) {
        Class clazz = this.getLeft().resolveClass(generationContext);
        return this.getRight().resolveClass(generationContext, clazz);
    }
}

