/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.toplink.internal.ox.NodeValue;
import oracle.toplink.internal.ox.TreeObjectBuilder;
import oracle.toplink.internal.ox.XPathFragment;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.XMLMarshaller;
import oracle.toplink.ox.record.MarshalRecord;
import oracle.toplink.sessions.Session;

public class XPathNode {
    private NodeValue nodeValue;
    private XPathFragment xPathFragment;
    private XPathNode parent;
    private List attributeChildren;
    private List nonAttributeChildren;
    private List selfChildren;
    private Map attributeChildrenMap;
    private Map nonAttributeChildrenMap;

    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    public NodeValue getNodeValue() {
        return this.nodeValue;
    }

    public void setNodeValue(NodeValue nodeValue) {
        this.nodeValue = nodeValue;
        if (null != nodeValue) {
            nodeValue.setXPathNode(this);
        }
    }

    public XPathNode getParent() {
        return this.parent;
    }

    public void setParent(XPathNode xPathNode) {
        this.parent = xPathNode;
    }

    public List getAttributeChildren() {
        return this.attributeChildren;
    }

    public List getNonAttributeChildren() {
        return this.nonAttributeChildren;
    }

    public List getSelfChildren() {
        return this.selfChildren;
    }

    public Map getNonAttributeChildrenMap() {
        return this.nonAttributeChildrenMap;
    }

    public boolean equals(Object object) {
        try {
            XPathNode xPathNode = (XPathNode)object;
            return this.getXPathFragment().equals(xPathNode.getXPathFragment());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void addChild(XPathFragment xPathFragment, NodeValue nodeValue, NamespaceResolver namespaceResolver) {
        Map map;
        List list;
        if (xPathFragment != null && xPathFragment.hasNamespace() && namespaceResolver != null) {
            xPathFragment.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix()));
        }
        XPathNode xPathNode = new XPathNode();
        xPathNode.setXPathFragment(xPathFragment);
        if (xPathFragment != null && xPathFragment.isAttribute()) {
            if (null == this.attributeChildren) {
                this.attributeChildren = new ArrayList();
                this.attributeChildrenMap = new HashMap();
            }
            list = this.attributeChildren;
            map = this.attributeChildrenMap;
        } else {
            if (null == this.nonAttributeChildren) {
                this.nonAttributeChildren = new ArrayList();
                this.nonAttributeChildrenMap = new HashMap();
            }
            list = this.nonAttributeChildren;
            map = this.nonAttributeChildrenMap;
        }
        if (null == xPathFragment) {
            xPathNode.setNodeValue(nodeValue);
            xPathNode.setParent(this);
            list.add(xPathNode);
            map.put(xPathFragment, xPathNode);
            return;
        }
        int n = list.indexOf(xPathNode);
        if (n >= 0) {
            xPathNode = (XPathNode)list.get(n);
        } else {
            xPathNode.setParent(this);
            list.add(xPathNode);
            if (XPathFragment.SELF_FRAGMENT.equals(xPathFragment)) {
                if (null == this.selfChildren) {
                    this.selfChildren = new ArrayList();
                }
                this.selfChildren.add(xPathNode);
            } else {
                map.put(xPathFragment, xPathNode);
            }
        }
        if (nodeValue.isOwningNode(xPathFragment)) {
            xPathNode.setNodeValue(nodeValue);
        } else {
            XPathFragment xPathFragment2 = xPathFragment.getNextFragment();
            xPathNode.addChild(xPathFragment2, nodeValue, namespaceResolver);
        }
    }

    public boolean marshal(MarshalRecord marshalRecord, Object object, Session session, NamespaceResolver namespaceResolver) {
        return this.marshal(marshalRecord, object, session, namespaceResolver, null);
    }

    public boolean marshal(MarshalRecord marshalRecord, Object object, Session session, NamespaceResolver namespaceResolver, XMLMarshaller xMLMarshaller) {
        if (null == this.nodeValue) {
            XPathNode xPathNode;
            int n;
            int n2;
            marshalRecord.addGroupingElement(this);
            boolean bl = false;
            if (null != this.attributeChildren) {
                n2 = this.attributeChildren.size();
                for (n = 0; n < n2; ++n) {
                    xPathNode = (XPathNode)this.attributeChildren.get(n);
                    bl = xPathNode.marshal(marshalRecord, object, session, namespaceResolver, xMLMarshaller) || bl;
                }
            }
            if (null != this.nonAttributeChildren) {
                n2 = this.nonAttributeChildren.size();
                for (n = 0; n < n2; ++n) {
                    xPathNode = (XPathNode)this.nonAttributeChildren.get(n);
                    bl = xPathNode.marshal(marshalRecord, object, session, namespaceResolver, xMLMarshaller) || bl;
                }
            }
            if (bl) {
                marshalRecord.endElement(this.getXPathFragment(), namespaceResolver);
            } else {
                marshalRecord.removeGroupingElement(this);
            }
            return bl;
        }
        return this.nodeValue.marshal(this.xPathFragment, marshalRecord, object, session, namespaceResolver, xMLMarshaller);
    }

    public boolean startElement(MarshalRecord marshalRecord, XPathFragment xPathFragment, Object object, Session session, NamespaceResolver namespaceResolver, TreeObjectBuilder treeObjectBuilder, Object object2) {
        if (null == xPathFragment) {
            return false;
        }
        marshalRecord.openStartElement(xPathFragment, namespaceResolver);
        boolean bl = false;
        if (null != this.attributeChildren) {
            int n = this.attributeChildren.size();
            for (int i = 0; i < n; ++i) {
                XPathNode xPathNode = (XPathNode)this.attributeChildren.get(i);
                bl = xPathNode.marshal(marshalRecord, object, session, namespaceResolver) || bl;
            }
        }
        if (null != treeObjectBuilder) {
            bl = treeObjectBuilder.marshalAttributes(marshalRecord, object2, session) || bl;
        }
        marshalRecord.closeStartElement();
        return bl;
    }
}

