/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.ox.UnmarshalXPathEngine;
import oracle.toplink.internal.ox.XMLConversionManager;
import oracle.toplink.internal.ox.XPathFragment;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.XMLUnionField;
import oracle.toplink.platform.xml.XMLNamespaceResolver;
import oracle.toplink.platform.xml.XMLNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathEngine {
    private static XPathEngine instance = null;
    private UnmarshalXPathEngine unmarshalXPathEngine = new UnmarshalXPathEngine();

    public static XPathEngine getInstance() {
        if (instance == null) {
            instance = new XPathEngine();
        }
        return instance;
    }

    private XPathEngine() {
    }

    public Node create(XMLField xMLField, Element element) throws XMLMarshalException {
        return this.create(xMLField, element, this);
    }

    public Node create(XMLField xMLField, Element element, Object object) throws XMLMarshalException {
        if (null == object) {
            return null;
        }
        XPathFragment xPathFragment = xMLField.getXPathFragment();
        if (xPathFragment.getNextFragment() == null && xPathFragment.nameIsText()) {
            Object object2 = this.getValueToWrite(object, xMLField);
            if (object2 instanceof String) {
                Object object3;
                if (xMLField.isTypedTextField()) {
                    object3 = new XMLNodeList();
                    ((XMLNodeList)object3).add(element);
                    this.addTypeAttributes((NodeList)object3, xMLField, object, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", xMLField.getNamespaceResolver()));
                }
                object3 = element.getOwnerDocument().createTextNode((String)object2);
                element.appendChild((Node)object3);
                return object3;
            }
            return null;
        }
        NodeList nodeList = this.createCollection(xMLField, element, object);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    private NodeList createCollection(XMLField xMLField, Element element, Object object) throws XMLMarshalException {
        XMLNodeList xMLNodeList = new XMLNodeList();
        if (object == null || object instanceof Collection && ((Collection)object).size() == 0) {
            return xMLNodeList;
        }
        Element element2 = element;
        XPathFragment xPathFragment = xMLField.getXPathFragment();
        while (xPathFragment != null) {
            Object object2;
            boolean bl;
            String string = xPathFragment.getXPath();
            if (xPathFragment.isAttribute()) {
                this.addAttribute(xPathFragment, xMLField, element2, object);
            } else if (xPathFragment.containsIndex()) {
                boolean bl2 = bl = !xPathFragment.getHasText() && xPathFragment.getNextFragment() != null;
                if (bl) {
                    element2 = this.addIndexedElement(xPathFragment, xMLField, element2, this, !bl);
                } else {
                    object2 = this.getValueToWrite(object, xMLField);
                    element2 = this.addIndexedElement(xPathFragment, xMLField, element2, object2, !bl);
                    xMLNodeList.add(element2);
                }
            } else {
                NodeList nodeList;
                String string2 = this.resolveNamespacePrefix(xPathFragment, xMLField.getNamespaceResolver());
                boolean bl3 = bl = !xPathFragment.getHasText() && xPathFragment.getNextFragment() != null;
                if (bl) {
                    nodeList = this.addElements(xPathFragment, xMLField, element2, this, !bl);
                } else {
                    object2 = xPathFragment.getNextFragment();
                    if (object2 != null && ((XPathFragment)object2).isAttribute() && !(object instanceof List)) {
                        nodeList = this.addElements(xPathFragment, xMLField, element2, this, bl);
                    } else {
                        Object object3 = this.getValueToWrite(object, xMLField);
                        nodeList = this.addElements(xPathFragment, xMLField, element2, object3, !bl);
                        xMLNodeList.addAll(nodeList);
                    }
                }
                element2 = (Element)nodeList.item(nodeList.getLength() - 1);
            }
            if ((xPathFragment = xPathFragment.getNextFragment()) == null || !xPathFragment.nameIsText()) continue;
            xPathFragment = null;
        }
        if (xMLField.isTypedTextField()) {
            this.addTypeAttributes(xMLNodeList, xMLField, object, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", xMLField.getNamespaceResolver()));
        }
        return xMLNodeList;
    }

    private Object getValueToWrite(Object object, XMLField xMLField) {
        if (object instanceof Node) {
            return object;
        }
        if (this == object) {
            return this;
        }
        QName qName = null;
        if (xMLField.isTypedTextField()) {
            qName = xMLField.getXMLType(object.getClass());
        } else {
            if (xMLField.isUnionField()) {
                return this.getValueToWriteForUnion((XMLUnionField)xMLField, object);
            }
            if (xMLField.getSchemaType() != null) {
                qName = xMLField.getSchemaType();
            }
        }
        if (object instanceof List) {
            if (xMLField.usesSingleNode()) {
                String string = "";
                for (int i = 0; i < ((List)object).size(); ++i) {
                    Object e = ((List)object).get(i);
                    String string2 = (String)XMLConversionManager.getDefaultXMLManager().convertObject(e, ClassConstants.STRING, qName);
                    string = string + string2;
                    if (i >= ((List)object).size() - 1) continue;
                    string = string + " ";
                }
                return string;
            }
            ArrayList arrayList = new ArrayList(((List)object).size());
            for (int i = 0; i < ((List)object).size(); ++i) {
                Object e = ((List)object).get(i);
                if (e instanceof Node) {
                    arrayList.add(e);
                    continue;
                }
                String string = (String)XMLConversionManager.getDefaultXMLManager().convertObject(e, ClassConstants.STRING, qName);
                arrayList.add(string);
            }
            return arrayList;
        }
        return (String)XMLConversionManager.getDefaultXMLManager().convertObject(object, ClassConstants.STRING, qName);
    }

    private String getSingleValueToWriteForUnion(XMLUnionField xMLUnionField, Object object) {
        ArrayList arrayList = xMLUnionField.getSchemaTypes();
        QName qName = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            QName qName2 = (QName)xMLUnionField.getSchemaTypes().get(i);
            try {
                if (qName2 == null) continue;
                Class clazz = xMLUnionField.getJavaClass(qName2);
                object = XMLConversionManager.getDefaultXMLManager().convertObject(object, clazz, qName2);
                qName = qName2;
                break;
            }
            catch (ConversionException conversionException) {
                if (i != arrayList.size() - 1) continue;
                qName = qName2;
            }
        }
        return (String)XMLConversionManager.getDefaultXMLManager().convertObject(object, ClassConstants.STRING, qName);
    }

    private Object getValueToWriteForUnion(XMLUnionField xMLUnionField, Object object) {
        if (object instanceof List) {
            if (xMLUnionField.usesSingleNode()) {
                String string = "";
                Object var4_5 = null;
                for (int i = 0; i < ((List)object).size(); ++i) {
                    var4_5 = ((List)object).get(i);
                    string = string + this.getSingleValueToWriteForUnion(xMLUnionField, var4_5);
                    if (i >= ((List)object).size() - 1) continue;
                    string = string + " ";
                }
                return string;
            }
            ArrayList<String> arrayList = new ArrayList<String>(((List)object).size());
            Object var4_6 = null;
            for (int i = 0; i < ((List)object).size(); ++i) {
                var4_6 = ((List)object).get(i);
                arrayList.add(this.getSingleValueToWriteForUnion(xMLUnionField, var4_6));
            }
            return arrayList;
        }
        return this.getSingleValueToWriteForUnion(xMLUnionField, object);
    }

    private Element addIndexedElement(XPathFragment xPathFragment, XMLField xMLField, Element element, Object object, boolean bl) throws XMLMarshalException {
        Object object2;
        Node node;
        Object object3;
        String string = xPathFragment.getShortName();
        int n = xPathFragment.getIndexValue();
        if (n < 0) {
            throw XMLMarshalException.invalidXPathIndexString(xPathFragment.getXPath());
        }
        NamespaceResolver namespaceResolver = xMLField.getNamespaceResolver();
        for (int i = 1; i < n; ++i) {
            object3 = new XMLField(string + "[" + i + "]");
            ((XMLField)object3).setNamespaceResolver(namespaceResolver);
            node = this.unmarshalXPathEngine.selectSingleNode((Node)element, (XMLField)object3, (XMLNamespaceResolver)namespaceResolver);
            if (node != null) continue;
            object2 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
            this.addElement(new XPathFragment(string), xMLField, element, this, true);
        }
        XMLField xMLField2 = new XMLField(xPathFragment.getXPath());
        xMLField2.setNamespaceResolver(namespaceResolver);
        node = this.unmarshalXPathEngine.selectSingleNode((Node)element, xMLField2, (XMLNamespaceResolver)namespaceResolver);
        if (node == null) {
            object3 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
            return this.addElement(new XPathFragment(string), xMLField2, element, object, true);
        }
        if (node != null && !bl) {
            return (Element)node;
        }
        object3 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        object2 = element.getOwnerDocument().createElementNS((String)object3, string);
        if (object != this && object != null && object instanceof String) {
            Text text = element.getOwnerDocument().createTextNode((String)object);
            object2.appendChild(text);
        }
        element.replaceChild((Node)object2, node);
        return object2;
    }

    private Element addElement(XPathFragment xPathFragment, XMLField xMLField, Element element, Object object, boolean bl) {
        return this.addElement(xPathFragment, xMLField, element, null, object, bl);
    }

    private Element addElement(XPathFragment xPathFragment, XMLField xMLField, Element element, QName qName, Object object, boolean bl) {
        NodeList nodeList = this.addElements(xPathFragment, xMLField, element, object, bl);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private NodeList addElements(XPathFragment xPathFragment, XMLField xMLField, Element element, Object object, boolean bl) {
        Object object2;
        Object object3;
        if (!bl) {
            object3 = this.resolveNamespacePrefix(xPathFragment, xMLField.getNamespaceResolver());
            object2 = this.unmarshalXPathEngine.selectElementNodes(element, xPathFragment, xMLField.getNamespaceResolver());
            if (object2.getLength() > 0) {
                return object2;
            }
        }
        object3 = new XMLNodeList();
        if (object == this) {
            object2 = this.resolveNamespacePrefix(xPathFragment, xMLField.getNamespaceResolver());
            Element element2 = element.getOwnerDocument().createElementNS((String)object2, xPathFragment.getShortName());
            ((XMLNodeList)object3).add(element2);
            element.appendChild(element2);
        } else if (object == null) {
            ((XMLNodeList)object3).add(element);
        } else if (object instanceof List) {
            object2 = (List)object;
            for (int i = 0; i < object2.size(); ++i) {
                Element element3 = this.createElement(element, xPathFragment, xMLField, object2.get(i));
                element.appendChild(element3);
                ((XMLNodeList)object3).add(element3);
            }
        } else {
            object2 = this.createElement(element, xPathFragment, xMLField, object);
            element.appendChild((Node)object2);
            ((XMLNodeList)object3).add((Node)object2);
        }
        return object3;
    }

    private Element createElement(Element element, XPathFragment xPathFragment, XMLField xMLField, Object object) {
        Object object2;
        if (object == null) {
            return element;
        }
        if (object instanceof Node) {
            return this.createElement(element, xPathFragment, xMLField.getNamespaceResolver(), (Node)object);
        }
        Element element2 = null;
        if (element.getOwnerDocument() == null) {
            element2 = ((Document)((Object)element)).getDocumentElement();
        } else {
            object2 = this.resolveNamespacePrefix(xPathFragment, xMLField.getNamespaceResolver());
            element2 = element.getOwnerDocument().createElementNS((String)object2, xPathFragment.getXPath());
        }
        object2 = xPathFragment.getNextFragment();
        if (object2 != null && ((XPathFragment)object2).isAttribute()) {
            this.addAttribute((XPathFragment)object2, xMLField, element2, object);
        } else if (object instanceof String) {
            Text text = element2.getOwnerDocument().createTextNode((String)object);
            element2.appendChild(text);
        }
        return element2;
    }

    public Element createUnownedElement(Element element, XMLField xMLField) {
        XPathFragment xPathFragment = xMLField.getXPathFragment();
        while (xPathFragment.getNextFragment() != null) {
            xPathFragment = xPathFragment.getNextFragment();
        }
        String string = xPathFragment.getShortName();
        String string2 = this.resolveNamespacePrefix(xPathFragment, xMLField.getNamespaceResolver());
        XMLNodeList xMLNodeList = new XMLNodeList();
        xMLNodeList.add(element.getOwnerDocument().createElementNS(string2, string));
        return (Element)xMLNodeList.item(0);
    }

    private void addTypeAttributes(NodeList nodeList, XMLField xMLField, Object object, String string) {
        ArrayList<Object> arrayList;
        NamespaceResolver namespaceResolver = xMLField.getNamespaceResolver();
        if (!xMLField.isTypedTextField()) {
            return;
        }
        if (null == string) {
            string = "xsi";
        }
        if (object instanceof List) {
            arrayList = (ArrayList<Object>)object;
        } else {
            arrayList = new ArrayList<Object>();
            arrayList.add(object);
        }
        int n = nodeList.getLength();
        int n2 = arrayList.size();
        if (n != n2) {
            return;
        }
        Node node = null;
        for (int i = 0; i < n; ++i) {
            String string2;
            QName qName;
            node = nodeList.item(i);
            if (node.getNodeType() != 1 || (qName = xMLField.getXMLType(arrayList.get(i).getClass())) == null) continue;
            String string3 = this.resolveNamespacePrefixForURI(qName.getNamespaceURI(), namespaceResolver);
            if (string3 == null || string3.equals("")) {
                string2 = qName.getLocalPart();
                ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", string + ":" + "type", string2);
                continue;
            }
            string2 = string3 + ":" + qName.getLocalPart();
            ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", string + ":" + "type", string2);
            ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string3, qName.getNamespaceURI());
        }
    }

    private Element createElement(Element element, XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Node node) {
        String string = xPathFragment.getXPath();
        Document document = element.getOwnerDocument();
        if (document == null && element.getNodeType() == 9) {
            document = (Document)((Object)element);
        }
        if (node.getNodeName().equals(string)) {
            if (document != node.getOwnerDocument()) {
                return (Element)document.importNode(node, true);
            }
            return (Element)node;
        }
        String string2 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        Element element2 = document.createElementNS(string2, string);
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = document.importNode(namedNodeMap.item(i), true);
            element2.setAttributeNode((Attr)node2);
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node3 = document.importNode(nodeList.item(i), true);
            element2.appendChild(node3);
        }
        return element2;
    }

    private Element addAttribute(XPathFragment xPathFragment, XMLField xMLField, Element element, Object object) {
        String string = xPathFragment.getLocalName();
        String string2 = this.resolveNamespacePrefix(xPathFragment, xMLField.getNamespaceResolver());
        Object object2 = this.getValueToWrite(object, xMLField);
        if (object2 != null && element.getAttributes().getNamedItemNS(string2, string) == null) {
            if (object2 == this) {
                element.setAttributeNS(string2, xPathFragment.getShortName(), "");
            } else if (object2 instanceof String) {
                element.setAttributeNS(string2, xPathFragment.getShortName(), (String)object2);
            }
        }
        return element;
    }

    public NodeList remove(XMLField xMLField, Element element) throws XMLMarshalException {
        return this.remove(xMLField, element, false);
    }

    public NodeList remove(XMLField xMLField, Element element, boolean bl) throws XMLMarshalException {
        String string = xMLField.getXPath();
        NodeList nodeList = this.unmarshalXPathEngine.selectNodes((Node)element, xMLField, (XMLNamespaceResolver)xMLField.getNamespaceResolver());
        int n = nodeList.getLength();
        boolean bl2 = this.containsIndex(string) && !bl;
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 2) {
                ((Attr)node).getOwnerElement().removeAttribute(node.getNodeName());
                continue;
            }
            if (bl2) {
                Element element2 = node.getParentNode().getOwnerDocument().createElementNS(node.getNamespaceURI(), node.getNodeName());
                node.getParentNode().replaceChild(element2, node);
                continue;
            }
            node.getParentNode().removeChild(node);
        }
        return nodeList;
    }

    public NodeList replaceValue(XMLField xMLField, Element element, Object object) throws XMLMarshalException {
        String string = xMLField.getXPath();
        NodeList nodeList = this.unmarshalXPathEngine.selectNodes((Node)element, xMLField, (XMLNamespaceResolver)xMLField.getNamespaceResolver());
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node;
            Node node2;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1) {
                if (node3.getNodeType() == 3 && object == null) {
                    node2 = node3.getParentNode();
                    node = node2.getParentNode();
                    node.removeChild(node2);
                    continue;
                }
                node3.setNodeValue((String)XMLConversionManager.getDefaultXMLManager().convertObject(object, ClassConstants.STRING));
                continue;
            }
            node2 = (Element)node3;
            node = node2.getParentNode();
            if (object == null) {
                node.removeChild(node2);
                continue;
            }
            String string2 = node2.getTagName();
            Element element2 = null;
            Object object2 = this.getValueToWrite(object, xMLField);
            element2 = this.createElement((Element)node, new XPathFragment(string2), xMLField, object2);
            if (element2 == node2) continue;
            node.replaceChild(element2, node2);
        }
        return nodeList;
    }

    public NodeList replaceCollection(XMLField xMLField, Element element, Collection collection) throws XMLMarshalException {
        Node node;
        Object object;
        int n;
        NodeList nodeList = this.unmarshalXPathEngine.selectNodes((Node)element, xMLField, (XMLNamespaceResolver)xMLField.getNamespaceResolver());
        if (nodeList.getLength() == 0) {
            return nodeList;
        }
        Iterator iterator = collection.iterator();
        int n2 = nodeList.getLength();
        Vector<Node> vector = new Vector<Node>();
        for (n = 0; n < n2 && iterator.hasNext(); ++n) {
            Node node2;
            object = nodeList.item(n);
            node = null;
            Object e = iterator.next();
            Node node3 = object.getParentNode();
            if (object.getNodeType() != 1) {
                if (object.getNodeType() == 3 && e == null) {
                    node2 = node3.getParentNode();
                    node2.removeChild(node3);
                    continue;
                }
                object.setNodeValue((String)XMLConversionManager.getDefaultXMLManager().convertObject(e, ClassConstants.STRING));
                continue;
            }
            node2 = (Element)object;
            String string = node2.getTagName();
            Object object2 = this.getValueToWrite(e, xMLField);
            node = this.createElement((Element)node3, new XPathFragment(string), xMLField, object2);
            vector.addElement(node);
            Node node4 = object.getParentNode();
            if (node4 == null) continue;
            node4.removeChild((Node)object);
        }
        while (n < n2) {
            object = nodeList.item(n);
            node = object.getParentNode();
            if (node != null) {
                node.removeChild((Node)object);
            }
            ++n;
        }
        object = vector.iterator();
        while (object.hasNext()) {
            node = (Element)object.next();
            this.create(xMLField, element, node);
        }
        while (iterator.hasNext()) {
            object = iterator.next();
            this.create(xMLField, element, object);
        }
        return nodeList;
    }

    private boolean containsIndex(String string) {
        return string.lastIndexOf(91) != -1 && string.lastIndexOf(93) != -1;
    }

    private String resolveNamespacePrefix(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (!xPathFragment.hasNamespace()) {
                return null;
            }
            return namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String resolveNamespacePrefixForURI(String string, NamespaceResolver namespaceResolver) {
        if (null == namespaceResolver) {
            return null;
        }
        Enumeration enumeration = namespaceResolver.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!namespaceResolver.resolveNamespacePrefix(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }
}

