/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.indirection;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.security.PrivilegedAccessController;

public class ProxyIndirectionHandler
implements InvocationHandler,
Serializable {
    private ValueHolderInterface valueHolder;

    public ProxyIndirectionHandler() {
    }

    private ProxyIndirectionHandler(ValueHolderInterface valueHolderInterface) {
        this.valueHolder = valueHolderInterface;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        try {
            if (method.getName().equals("toString")) {
                if (this.valueHolder.isInstantiated()) {
                    if (this.valueHolder.getValue() == null) {
                        object2 = "null";
                    } else {
                        String string = (String)PrivilegedAccessController.invokeMethod(method, this.valueHolder.getValue(), objectArray);
                        object2 = "{ " + string + " }";
                    }
                } else {
                    object2 = "{ IndirectProxy: not instantiated }";
                }
            } else if (method.getName().equals("equals") && this.valueHolder.getValue() == null && objectArray[0] == null) {
                object2 = Boolean.TRUE;
            } else {
                Object object3 = this.valueHolder.getValue();
                if (object3 == null) {
                    throw ValidationException.nullUnderlyingValueHolderValue(method.getName());
                }
                object2 = PrivilegedAccessController.invokeMethod(method, object3, objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (ValidationException validationException) {
            throw validationException;
        }
        catch (Exception exception) {
            throw QueryException.unexpectedInvocation(exception.getMessage());
        }
        return object2;
    }

    public static Object newProxyInstance(Class clazz, Class[] classArray, ValueHolderInterface valueHolderInterface) {
        return Proxy.newProxyInstance(PrivilegedAccessController.getClassLoaderForClass(clazz), classArray, (InvocationHandler)new ProxyIndirectionHandler(valueHolderInterface));
    }

    public ValueHolderInterface getValueHolder() {
        return this.valueHolder;
    }

    public void setValueHolder(ValueHolderInterface valueHolderInterface) {
        this.valueHolder = valueHolderInterface;
    }
}

