/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.history;

import java.io.StringWriter;
import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.identitymaps.IdentityMapManager;
import oracle.toplink.internal.sessions.AbstractSession;
import oracle.toplink.internal.sessions.HistoricalSessionIdentityMapAccessor;
import oracle.toplink.platform.server.ServerPlatform;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;

public class HistoricalSession
extends AbstractSession {
    protected final Session parent;
    protected final AsOfClause asOfClause;

    public HistoricalSession(Session session, AsOfClause asOfClause) {
        this.asOfClause = asOfClause;
        this.parent = session;
        this.project = session.getProject();
        this.queries = session.getQueries();
        this.profiler = session.getProfiler();
        this.sessionLog = session.getSessionLog();
        this.eventManager = session.getEventManager().clone(this);
        this.exceptionHandler = session.getExceptionHandler();
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new HistoricalSessionIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public oracle.toplink.sessions.Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    public UnitOfWork acquireUnitOfWork() {
        throw ValidationException.operationNotSupported(Helper.getShortClassName(this.getClass()) + ".acquireUnitOfWork");
    }

    public void beginTransaction() throws DatabaseException, ConcurrencyException {
        throw ValidationException.operationNotSupported(Helper.getShortClassName(this.getClass()) + ".beginTransaction");
    }

    public void commitTransaction() throws DatabaseException, ConcurrencyException {
        throw ValidationException.operationNotSupported(Helper.getShortClassName(this.getClass()) + ".commitTransaction");
    }

    public Session getExecutionSession(DatabaseQuery databaseQuery) {
        return this.getParent().getExecutionSession(databaseQuery);
    }

    public AsOfClause getAsOfClause() {
        return this.asOfClause;
    }

    public Object getAsOfValue() {
        return this.getAsOfClause().getValue();
    }

    public Session getParent() {
        return this.parent;
    }

    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    public boolean hasAsOfClause() {
        return this.asOfClause != null && this.asOfClause.getValue() != null;
    }

    public Object internalExecuteQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow) throws DatabaseException {
        if (!databaseQuery.isReadQuery()) {
            throw QueryException.invalidQueryOnHistoricalSession(databaseQuery);
        }
        return super.internalExecuteQuery(databaseQuery, databaseRow);
    }

    public boolean isInTransaction() {
        return false;
    }

    public boolean isHistoricalSession() {
        return true;
    }

    public DatabaseQuery prepareDatabaseQuery(DatabaseQuery databaseQuery) {
        DatabaseQuery databaseQuery2 = (DatabaseQuery)databaseQuery.clone();
        databaseQuery2.setIsExecutionClone(true);
        databaseQuery2.setIsPrepared(false);
        return databaseQuery2;
    }

    public void rollbackTransaction() throws DatabaseException, ConcurrencyException {
        throw ValidationException.operationNotSupported(Helper.getShortClassName(this.getClass()) + ".rollbackTransaction");
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(this.getSessionTypeString());
        stringWriter.write("(");
        stringWriter.write(this.getAsOfClause().toString());
        stringWriter.write(")");
        return stringWriter.toString();
    }
}

