/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TopLinkIdentityHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    static final long serialVersionUID = -5176951017503351630L;
    static final int DEFAULT_INITIAL_CAPACITY = 32;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] entries;
    protected transient int count = 0;
    private transient int modCount = 0;
    protected int threshold = 0;
    protected float loadFactor = 0.0f;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();

    public TopLinkIdentityHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal loadFactor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.entries = new Entry[n2];
    }

    public TopLinkIdentityHashMap(int n) {
        this(n, 0.75f);
    }

    public TopLinkIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 24;
        this.entries = new Entry[32];
    }

    public TopLinkIdentityHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(map);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.entries;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == object) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(Object object) {
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == object) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.entries.length;
        Entry[] entryArray = this.entries;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.entries = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == object) {
                Object object3 = entry.value;
                entry.value = object2;
                return object3;
            }
            entry = entry.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.entries;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, object2, entryArray[n2]);
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        Entry[] entryArray = this.entries;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.key == object) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public void putAll(Map map) {
        if (map == null) {
            throw new NullPointerException();
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        if (this.count > 0) {
            ++this.modCount;
            Entry[] entryArray = this.entries;
            int n = entryArray.length;
            while (--n >= 0) {
                entryArray[n] = null;
            }
            this.count = 0;
        }
    }

    public Object clone() {
        try {
            Entry[] entryArray = this.entries;
            TopLinkIdentityHashMap topLinkIdentityHashMap = (TopLinkIdentityHashMap)super.clone();
            topLinkIdentityHashMap.entries = new Entry[entryArray.length];
            int n = entryArray.length;
            while (n-- > 0) {
                topLinkIdentityHashMap.entries[n] = entryArray[n] != null ? (Entry)entryArray[n].clone() : null;
            }
            topLinkIdentityHashMap.keySet = null;
            topLinkIdentityHashMap.entrySet = null;
            topLinkIdentityHashMap.values = null;
            topLinkIdentityHashMap.modCount = 0;
            return topLinkIdentityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return TopLinkIdentityHashMap.this.getHashIterator(0);
                }

                public int size() {
                    return TopLinkIdentityHashMap.this.count;
                }

                public boolean contains(Object object) {
                    return TopLinkIdentityHashMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = TopLinkIdentityHashMap.this.count;
                    TopLinkIdentityHashMap.this.remove(object);
                    return TopLinkIdentityHashMap.this.count != n;
                }

                public void clear() {
                    TopLinkIdentityHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return TopLinkIdentityHashMap.this.getHashIterator(1);
                }

                public int size() {
                    return TopLinkIdentityHashMap.this.count;
                }

                public boolean contains(Object object) {
                    return TopLinkIdentityHashMap.this.containsValue(object);
                }

                public void clear() {
                    TopLinkIdentityHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return TopLinkIdentityHashMap.this.getHashIterator(2);
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Entry[] entryArray = TopLinkIdentityHashMap.this.entries;
                    int n = System.identityHashCode(k);
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            return true;
                        }
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    Entry[] entryArray = TopLinkIdentityHashMap.this.entries;
                    int n = System.identityHashCode(k);
                    int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
                    Entry entry2 = entryArray[n2];
                    Entry entry3 = null;
                    while (entry2 != null) {
                        if (entry2.hash == n && entry2.equals(entry)) {
                            TopLinkIdentityHashMap.this.modCount++;
                            if (entry3 != null) {
                                entry3.next = entry2.next;
                            } else {
                                entryArray[n2] = entry2.next;
                            }
                            --TopLinkIdentityHashMap.this.count;
                            entry2.value = null;
                            return true;
                        }
                        entry3 = entry2;
                        entry2 = entry2.next;
                    }
                    return false;
                }

                public int size() {
                    return TopLinkIdentityHashMap.this.count;
                }

                public void clear() {
                    TopLinkIdentityHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private Iterator getHashIterator(int n) {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator(n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.entries.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.entries.length - 1; i >= 0; --i) {
            Entry entry = this.entries[i];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.entries = new Entry[n];
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] entries;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int n) {
            this.entries = TopLinkIdentityHashMap.this.entries;
            this.index = this.entries.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = TopLinkIdentityHashMap.this.modCount;
            this.type = n;
        }

        public boolean hasNext() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = TopLinkIdentityHashMap.this.entries;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            return entry != null;
        }

        public Object next() {
            if (TopLinkIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = TopLinkIdentityHashMap.this.entries;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            if (entry != null) {
                Entry entry2 = this.lastReturned = this.entry;
                this.entry = entry2.next;
                return this.type == 0 ? entry2.key : (this.type == 1 ? entry2.value : entry2);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TopLinkIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = TopLinkIdentityHashMap.this.entries;
            int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturned) {
                    TopLinkIdentityHashMap.this.modCount++;
                    ++this.expectedModCount;
                    if (entry2 == null) {
                        entryArray[n] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    --TopLinkIdentityHashMap.this.count;
                    this.lastReturned = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.key == entry.getKey() && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

