/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.JavaPlatform;
import oracle.toplink.internal.security.PrivilegedAccessController;

public class ConversionManager
implements Serializable,
Cloneable {
    protected Map defaultNullValues = new HashMap(5);
    protected boolean shouldUseClassLoaderFromCurrentThread = false;
    protected static ConversionManager defaultManager;
    private static ClassLoader defaultLoader;
    protected ClassLoader loader;
    protected Hashtable dataTypesConvertedFromAClass = new Hashtable();
    protected Hashtable dataTypesConvertedToAClass = new Hashtable();
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$Ljava$lang$Character;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object convertObject(Object object, Class clazz) throws ConversionException {
        if (object == null) {
            if (clazz != null) {
                return this.getDefaultNullValue(clazz);
            }
            return null;
        }
        if (object.getClass() == clazz || clazz == null || clazz == ClassConstants.OBJECT || clazz == ClassConstants.BLOB || clazz == ClassConstants.CLOB || ClassConstants.NOCONVERSION.isAssignableFrom(clazz)) {
            return object;
        }
        if (clazz.isPrimitive() && (object instanceof Boolean && clazz == ClassConstants.PBOOLEAN || object instanceof Long && clazz == ClassConstants.PLONG || object instanceof Integer && clazz == ClassConstants.PINT || object instanceof Float && clazz == ClassConstants.PFLOAT || object instanceof Double && clazz == ClassConstants.PDOUBLE || object instanceof Byte && clazz == ClassConstants.PBYTE || object instanceof Character && clazz == ClassConstants.PCHAR || object instanceof Short && clazz == ClassConstants.PSHORT)) {
            return object;
        }
        try {
            if (clazz == ClassConstants.STRING) {
                return this.convertObjectToString(object);
            }
            if (clazz == ClassConstants.UTILDATE) {
                return this.convertObjectToUtilDate(object);
            }
            if (clazz == ClassConstants.SQLDATE) {
                return this.convertObjectToDate(object);
            }
            if (clazz == ClassConstants.TIME) {
                return this.convertObjectToTime(object);
            }
            if (clazz == ClassConstants.TIMESTAMP) {
                return this.convertObjectToTimestamp(object);
            }
            if (clazz == ClassConstants.CALENDAR || clazz == ClassConstants.GREGORIAN_CALENDAR) {
                return this.convertObjectToCalendar(object);
            }
            if (clazz == ClassConstants.CHAR || clazz == ClassConstants.PCHAR) {
                return this.convertObjectToChar(object);
            }
            if (clazz == ClassConstants.INTEGER || clazz == ClassConstants.PINT) {
                return this.convertObjectToInteger(object);
            }
            if (clazz == ClassConstants.DOUBLE || clazz == ClassConstants.PDOUBLE) {
                return this.convertObjectToDouble(object);
            }
            if (clazz == ClassConstants.FLOAT || clazz == ClassConstants.PFLOAT) {
                return this.convertObjectToFloat(object);
            }
            if (clazz == ClassConstants.LONG || clazz == ClassConstants.PLONG) {
                return this.convertObjectToLong(object);
            }
            if (clazz == ClassConstants.SHORT || clazz == ClassConstants.PSHORT) {
                return this.convertObjectToShort(object);
            }
            if (clazz == ClassConstants.BYTE || clazz == ClassConstants.PBYTE) {
                return this.convertObjectToByte(object);
            }
            if (clazz == ClassConstants.BIGINTEGER) {
                return this.convertObjectToBigInteger(object);
            }
            if (clazz == ClassConstants.BIGDECIMAL) {
                return this.convertObjectToBigDecimal(object);
            }
            if (clazz == ClassConstants.NUMBER) {
                return this.convertObjectToNumber(object);
            }
            if (clazz == ClassConstants.BOOLEAN || clazz == ClassConstants.PBOOLEAN) {
                return this.convertObjectToBoolean(object);
            }
            if (clazz == ClassConstants.APBYTE) {
                return this.convertObjectToByteArray(object);
            }
            if (clazz == ClassConstants.ABYTE) {
                return this.convertObjectToByteObjectArray(object);
            }
            if (clazz == ClassConstants.APCHAR) {
                return this.convertObjectToCharArray(object);
            }
            if (clazz == ClassConstants.ACHAR) {
                return this.convertObjectToCharacterArray(object);
            }
            if (object.getClass() == ClassConstants.STRING && clazz == ClassConstants.CLASS) {
                return this.convertObjectToClass(object);
            }
        }
        catch (ConversionException conversionException) {
            throw conversionException;
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConverted(object, clazz, exception);
        }
        if (clazz.isInstance(object)) {
            return object;
        }
        throw ConversionException.couldNotBeConverted(object, clazz);
    }

    protected BigDecimal convertObjectToBigDecimal(Object object) throws ConversionException {
        BigDecimal bigDecimal;
        block5: {
            bigDecimal = null;
            try {
                if (object instanceof String) {
                    bigDecimal = new BigDecimal((String)object);
                    break block5;
                }
                if (object instanceof BigInteger) {
                    bigDecimal = new BigDecimal((BigInteger)object);
                    break block5;
                }
                if (object instanceof Number) {
                    bigDecimal = new BigDecimal(((Number)object).doubleValue());
                    break block5;
                }
                throw ConversionException.couldNotBeConverted(object, ClassConstants.BIGDECIMAL);
            }
            catch (NumberFormatException numberFormatException) {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.BIGDECIMAL, numberFormatException);
            }
        }
        return bigDecimal;
    }

    protected BigInteger convertObjectToBigInteger(Object object) throws ConversionException {
        BigInteger bigInteger;
        block6: {
            bigInteger = null;
            try {
                if (object instanceof BigInteger) {
                    bigInteger = (BigInteger)object;
                    break block6;
                }
                if (object instanceof String) {
                    bigInteger = new BigInteger((String)object);
                    break block6;
                }
                if (object instanceof BigDecimal) {
                    bigInteger = ((BigDecimal)object).toBigInteger();
                    break block6;
                }
                if (object instanceof Number) {
                    bigInteger = new BigInteger(new Long(((Number)object).longValue()).toString());
                    break block6;
                }
                throw ConversionException.couldNotBeConverted(object, ClassConstants.BIGINTEGER);
            }
            catch (NumberFormatException numberFormatException) {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.BIGINTEGER, numberFormatException);
            }
        }
        return bigInteger;
    }

    protected Boolean convertObjectToBoolean(Object object) {
        if (object instanceof Character) {
            switch (Character.toLowerCase(((Character)object).charValue())) {
                case '1': 
                case 't': {
                    return new Boolean(true);
                }
                case '0': 
                case 'f': {
                    return new Boolean(false);
                }
            }
        }
        if (object instanceof String) {
            String string = ((String)object).toLowerCase();
            if (string.equals("t") || string.equals("true") || string.equals("1")) {
                return new Boolean(true);
            }
            if (string.equals("f") || string.equals("false") || string.equals("0")) {
                return new Boolean(false);
            }
        }
        if (object instanceof Number) {
            int n = ((Number)object).intValue();
            if (n != 0) {
                return new Boolean(true);
            }
            if (n == 0) {
                return new Boolean(false);
            }
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.BOOLEAN);
    }

    protected Byte convertObjectToByte(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Byte((String)object);
            }
            if (object instanceof Number) {
                return new Byte(((Number)object).byteValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.BYTE, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.BYTE);
    }

    protected byte[] convertObjectToByteArray(Object object) throws ConversionException {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Byte[]) {
            Byte[] byteArray = (Byte[])object;
            byte[] byArray = new byte[byteArray.length];
            for (int i = 0; i < byteArray.length; ++i) {
                byArray[i] = byteArray[i];
            }
            return byArray;
        }
        if (object instanceof String) {
            return Helper.buildBytesFromHexString((String)object);
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                return blob.getBytes(1L, (int)blob.length());
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException);
            }
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.APBYTE);
    }

    protected Byte[] convertObjectToByteObjectArray(Object object) throws ConversionException {
        byte[] byArray = this.convertObjectToByteArray(object);
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = new Byte(byArray[i]);
        }
        return byteArray;
    }

    protected Calendar convertObjectToCalendar(Object object) throws ConversionException {
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        if (object instanceof java.util.Date) {
            return Helper.calendarFromUtilDate((java.util.Date)object);
        }
        return Helper.calendarFromUtilDate(this.convertObjectToUtilDate(object));
    }

    protected Character convertObjectToChar(Object object) throws ConversionException {
        if (object instanceof String) {
            if (((String)object).length() < 1) {
                return null;
            }
            return new Character(((String)object).charAt(0));
        }
        if (object instanceof Number) {
            return new Character((char)((Number)object).byteValue());
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.CHAR);
    }

    protected Character[] convertObjectToCharacterArray(Object object) throws ConversionException {
        String string = this.convertObjectToString(object);
        Character[] characterArray = new Character[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            characterArray[i] = new Character(string.charAt(i));
        }
        return characterArray;
    }

    protected char[] convertObjectToCharArray(Object object) throws ConversionException {
        if (object instanceof Character[]) {
            Character[] characterArray = (Character[])object;
            char[] cArray = new char[characterArray.length];
            for (int i = 0; i < characterArray.length; ++i) {
                cArray[i] = characterArray[i].charValue();
            }
            return cArray;
        }
        String string = this.convertObjectToString(object);
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            cArray[i] = string.charAt(i);
        }
        return cArray;
    }

    protected Class convertObjectToClass(Object object) throws ConversionException {
        Class<?> clazz = null;
        if (!(object instanceof String)) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.CLASS);
        }
        try {
            clazz = ConversionManager.getPrimitiveClass((String)object);
            if (clazz == null) {
                clazz = this.getLoader().loadClass((String)object);
            }
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConvertedToClass(object, ClassConstants.CLASS, exception);
        }
        return clazz;
    }

    protected Date convertObjectToDate(Object object) throws ConversionException {
        Date date = null;
        Class<?> clazz = object.getClass();
        if (object instanceof Date) {
            date = (Date)object;
        } else if (object instanceof Timestamp) {
            date = Helper.dateFromTimestamp((Timestamp)object);
        } else if (object.getClass() == ClassConstants.UTILDATE) {
            date = Helper.sqlDateFromUtilDate((java.util.Date)object);
        } else {
            if (object instanceof Calendar) {
                return Helper.dateFromCalendar((Calendar)object);
            }
            if (object instanceof String) {
                date = Helper.dateFromString((String)object);
            } else if (object instanceof Long) {
                date = Helper.dateFromLong((Long)object);
            } else {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.SQLDATE);
            }
        }
        return date;
    }

    protected Double convertObjectToDouble(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Double((String)object);
            }
            if (object instanceof Number) {
                return new Double(((Number)object).doubleValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.DOUBLE, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.DOUBLE);
    }

    protected Float convertObjectToFloat(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Float((String)object);
            }
            if (object instanceof Number) {
                return new Float(((Number)object).floatValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.FLOAT, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.FLOAT);
    }

    protected Integer convertObjectToInteger(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Integer((String)object);
            }
            if (object instanceof Number) {
                return new Integer(((Number)object).intValue());
            }
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.INTEGER, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.INTEGER);
    }

    protected Long convertObjectToLong(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Long((String)object);
            }
            if (object instanceof Number) {
                return new Long(((Number)object).longValue());
            }
            if (object instanceof java.util.Date) {
                return new Long(((java.util.Date)object).getTime());
            }
            if (object instanceof Calendar) {
                return new Long(JavaPlatform.getTimeInMillis((Calendar)object));
            }
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return new Long(1L);
                }
                return new Long(0L);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.LONG, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.LONG);
    }

    protected BigDecimal convertObjectToNumber(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new BigDecimal((String)object);
            }
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return new BigDecimal(1.0);
                }
                return new BigDecimal(0.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.NUMBER, numberFormatException);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.NUMBER);
    }

    protected Short convertObjectToShort(Object object) throws ConversionException {
        try {
            if (object instanceof String) {
                return new Short((String)object);
            }
            if (object instanceof Number) {
                return new Short(((Number)object).shortValue());
            }
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return new Short(1);
                }
                return new Short(0);
            }
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConverted(object, ClassConstants.SHORT, exception);
        }
        throw ConversionException.couldNotBeConverted(object, ClassConstants.SHORT);
    }

    protected String convertObjectToString(Object object) throws ConversionException {
        if (object.getClass() == ClassConstants.UTILDATE) {
            return Helper.printTimestamp(Helper.timestampFromDate((java.util.Date)object));
        }
        if (object instanceof Calendar) {
            return Helper.printCalendar((Calendar)object);
        }
        if (object instanceof Timestamp) {
            return Helper.printTimestamp((Timestamp)object);
        }
        if (object instanceof Date) {
            return Helper.printDate((Date)object);
        }
        if (object instanceof Time) {
            return Helper.printTime((Time)object);
        }
        if (object instanceof byte[]) {
            return Helper.buildHexStringFromBytes((byte[])object);
        }
        if (object instanceof Byte[]) {
            return Helper.buildHexStringFromBytes(this.convertObjectToByteArray(object));
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof Character[]) {
            return new String(this.convertObjectToCharArray(object));
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object instanceof Character) {
            return object.toString();
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            try {
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException);
            }
        }
        return object.toString();
    }

    protected Time convertObjectToTime(Object object) throws ConversionException {
        Time time = null;
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof String) {
            time = Helper.timeFromString((String)object);
        } else if (object.getClass() == ClassConstants.UTILDATE) {
            time = Helper.timeFromDate((java.util.Date)object);
        } else if (object instanceof Timestamp) {
            time = Helper.timeFromTimestamp((Timestamp)object);
        } else {
            if (object instanceof Calendar) {
                return Helper.timeFromCalendar((Calendar)object);
            }
            if (object instanceof Long) {
                time = Helper.timeFromLong((Long)object);
            } else {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.TIME);
            }
        }
        return time;
    }

    protected Timestamp convertObjectToTimestamp(Object object) throws ConversionException {
        Timestamp timestamp = null;
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof String) {
            timestamp = Helper.timestampFromString((String)object);
        } else if (object instanceof java.util.Date) {
            timestamp = Helper.timestampFromDate((java.util.Date)object);
        } else {
            if (object instanceof Calendar) {
                return Helper.timestampFromCalendar((Calendar)object);
            }
            if (object instanceof Long) {
                timestamp = Helper.timestampFromLong((Long)object);
            } else {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.TIMESTAMP);
            }
        }
        return timestamp;
    }

    protected java.util.Date convertObjectToUtilDate(Object object) throws ConversionException {
        java.util.Date date = null;
        if (object.getClass() == (class$java$util$Date == null ? (class$java$util$Date = ConversionManager.class$("java.util.Date")) : class$java$util$Date)) {
            date = (java.util.Date)object;
        } else if (object instanceof Date) {
            date = Helper.utilDateFromSQLDate((Date)object);
        } else if (object instanceof Time) {
            date = Helper.utilDateFromTime((Time)object);
        } else if (object instanceof String) {
            date = Helper.utilDateFromTimestamp(Helper.timestampFromString((String)object));
        } else if (object instanceof Timestamp) {
            date = Helper.utilDateFromTimestamp((Timestamp)object);
        } else {
            if (object instanceof Calendar) {
                return ((Calendar)object).getTime();
            }
            if (object instanceof Long) {
                date = Helper.utilDateFromLong((Long)object);
            } else {
                throw ConversionException.couldNotBeConverted(object, ClassConstants.UTILDATE);
            }
        }
        return date;
    }

    public Class convertClassNameToClass(String string) throws ConversionException {
        return this.convertObjectToClass(string);
    }

    public static ConversionManager getDefaultManager() {
        if (defaultManager == null) {
            ConversionManager.setDefaultManager(new ConversionManager());
            defaultManager.setShouldUseClassLoaderFromCurrentThread(true);
        }
        return defaultManager;
    }

    public Object getDefaultNullValue(Class clazz) {
        return this.getDefaultNullValues().get(clazz);
    }

    public Map getDefaultNullValues() {
        return this.defaultNullValues;
    }

    public ClassLoader getLoader() {
        if (this.shouldUseClassLoaderFromCurrentThread()) {
            return PrivilegedAccessController.getContextClassLoader(Thread.currentThread());
        }
        if (this.loader == null) {
            if (defaultLoader == null) {
                this.setLoader(PrivilegedAccessController.getClassLoaderForClass(ClassConstants.ConversionManager_Class));
            } else {
                this.setLoader(ConversionManager.getDefaultLoader());
            }
        }
        return this.loader;
    }

    public static Class loadClass(String string) {
        return (Class)ConversionManager.getDefaultManager().convertObject(string, ClassConstants.CLASS);
    }

    public static Class getObjectClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (clazz == ClassConstants.PCHAR) {
                return ClassConstants.CHAR;
            }
            if (clazz == ClassConstants.PINT) {
                return ClassConstants.INTEGER;
            }
            if (clazz == ClassConstants.PDOUBLE) {
                return ClassConstants.DOUBLE;
            }
            if (clazz == ClassConstants.PFLOAT) {
                return ClassConstants.FLOAT;
            }
            if (clazz == ClassConstants.PLONG) {
                return ClassConstants.LONG;
            }
            if (clazz == ClassConstants.PSHORT) {
                return ClassConstants.SHORT;
            }
            if (clazz == ClassConstants.PBYTE) {
                return ClassConstants.BYTE;
            }
            if (clazz == ClassConstants.PBOOLEAN) {
                return ClassConstants.BOOLEAN;
            }
            if (clazz == ClassConstants.APBYTE) {
                return ClassConstants.BYTE;
            }
        } else {
            return clazz;
        }
        return clazz;
    }

    public static Class getPrimitiveClass(String string) {
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        return null;
    }

    public static void setDefaultManager(ConversionManager conversionManager) {
        defaultManager = conversionManager;
    }

    public void setDefaultNullValue(Class clazz, Object object) {
        this.getDefaultNullValues().put(clazz, object);
    }

    public void setDefaultNullValues(Map map) {
        this.defaultNullValues = map;
    }

    public void setLoader(ClassLoader classLoader) {
        this.shouldUseClassLoaderFromCurrentThread = false;
        this.loader = classLoader;
    }

    public static void setDefaultLoader(ClassLoader classLoader) {
        defaultLoader = classLoader;
    }

    public static ClassLoader getDefaultLoader() {
        return defaultLoader;
    }

    public void setShouldUseClassLoaderFromCurrentThread(boolean bl) {
        this.shouldUseClassLoaderFromCurrentThread = bl;
    }

    public boolean shouldUseClassLoaderFromCurrentThread() {
        return this.shouldUseClassLoaderFromCurrentThread;
    }

    public Vector getDataTypesConvertedFrom(Class clazz) {
        if (this.dataTypesConvertedFromAClass.isEmpty()) {
            this.buildDataTypesConvertedFromAClass();
        }
        return (Vector)this.dataTypesConvertedFromAClass.get(clazz);
    }

    public Vector getDataTypesConvertedTo(Class clazz) {
        if (this.dataTypesConvertedToAClass.isEmpty()) {
            this.buildDataTypesConvertedToAClass();
        }
        return (Vector)this.dataTypesConvertedToAClass.get(clazz);
    }

    protected Vector buildNumberVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConversionManager.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        vector.addElement(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConversionManager.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        vector.addElement(class$java$lang$Byte == null ? (class$java$lang$Byte = ConversionManager.class$("java.lang.Byte")) : class$java$lang$Byte);
        vector.addElement(class$java$lang$Double == null ? (class$java$lang$Double = ConversionManager.class$("java.lang.Double")) : class$java$lang$Double);
        vector.addElement(class$java$lang$Float == null ? (class$java$lang$Float = ConversionManager.class$("java.lang.Float")) : class$java$lang$Float);
        vector.addElement(class$java$lang$Integer == null ? (class$java$lang$Integer = ConversionManager.class$("java.lang.Integer")) : class$java$lang$Integer);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$lang$Short == null ? (class$java$lang$Short = ConversionManager.class$("java.lang.Short")) : class$java$lang$Short);
        vector.addElement(class$java$lang$Number == null ? (class$java$lang$Number = ConversionManager.class$("java.lang.Number")) : class$java$lang$Number);
        return vector;
    }

    protected Vector buildDateTimeVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$util$Date == null ? (class$java$util$Date = ConversionManager.class$("java.util.Date")) : class$java$util$Date);
        vector.addElement(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ConversionManager.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        vector.addElement(class$java$util$Calendar == null ? (class$java$util$Calendar = ConversionManager.class$("java.util.Calendar")) : class$java$util$Calendar);
        return vector;
    }

    protected void buildDataTypesConvertedFromAClass() {
        this.dataTypesConvertedFromAClass.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConversionManager.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, this.buildFromBigDecimalVec());
        this.dataTypesConvertedFromAClass.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConversionManager.class$("java.math.BigInteger")) : class$java$math$BigInteger, this.buildFromBigIntegerVec());
        this.dataTypesConvertedFromAClass.put(class$java$sql$Blob == null ? (class$java$sql$Blob = ConversionManager.class$("java.sql.Blob")) : class$java$sql$Blob, this.buildFromBlobVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConversionManager.class$("java.lang.Boolean")) : class$java$lang$Boolean, this.buildFromBooleanVec());
        this.dataTypesConvertedFromAClass.put(array$B == null ? (array$B = ConversionManager.class$("[B")) : array$B, this.buildFromByteArrayVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ConversionManager.class$("java.lang.Byte")) : class$java$lang$Byte, this.buildFromByteVec());
        this.dataTypesConvertedFromAClass.put(class$java$util$Calendar == null ? (class$java$util$Calendar = ConversionManager.class$("java.util.Calendar")) : class$java$util$Calendar, this.buildFromCalendarVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$Character == null ? (class$java$lang$Character = ConversionManager.class$("java.lang.Character")) : class$java$lang$Character, this.buildFromCharacterVec());
        this.dataTypesConvertedFromAClass.put(class$java$sql$Clob == null ? (class$java$sql$Clob = ConversionManager.class$("java.sql.Clob")) : class$java$sql$Clob, this.buildFromClobVec());
        this.dataTypesConvertedFromAClass.put(class$java$sql$Date == null ? (class$java$sql$Date = ConversionManager.class$("java.sql.Date")) : class$java$sql$Date, this.buildFromDateVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$Double == null ? (class$java$lang$Double = ConversionManager.class$("java.lang.Double")) : class$java$lang$Double, this.buildFromDoubleVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$Float == null ? (class$java$lang$Float = ConversionManager.class$("java.lang.Float")) : class$java$lang$Float, this.buildFromFloatVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ConversionManager.class$("java.lang.Integer")) : class$java$lang$Integer, this.buildFromIntegerVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long, this.buildFromLongVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$Number == null ? (class$java$lang$Number = ConversionManager.class$("java.lang.Number")) : class$java$lang$Number, this.buildFromNumberVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$Short == null ? (class$java$lang$Short = ConversionManager.class$("java.lang.Short")) : class$java$lang$Short, this.buildFromShortVec());
        this.dataTypesConvertedFromAClass.put(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String, this.buildFromStringVec());
        this.dataTypesConvertedFromAClass.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ConversionManager.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, this.buildFromTimestampVec());
        this.dataTypesConvertedFromAClass.put(class$java$sql$Time == null ? (class$java$sql$Time = ConversionManager.class$("java.sql.Time")) : class$java$sql$Time, this.buildFromTimeVec());
        this.dataTypesConvertedFromAClass.put(class$java$util$Date == null ? (class$java$util$Date = ConversionManager.class$("java.util.Date")) : class$java$util$Date, this.buildFromUtilDateVec());
        this.dataTypesConvertedFromAClass.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = ConversionManager.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, this.buildFromByteObjectArraryVec());
        this.dataTypesConvertedFromAClass.put(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C, this.buildFromCharArrayVec());
        this.dataTypesConvertedFromAClass.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, this.buildFromCharacterArrayVec());
    }

    protected Vector buildFromBooleanVec() {
        Vector<Class<Comparable<Boolean>>> vector = new Vector<Class<Comparable<Boolean>>>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConversionManager.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        vector.addElement(class$java$lang$Integer == null ? (class$java$lang$Integer = ConversionManager.class$("java.lang.Integer")) : class$java$lang$Integer);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$lang$Short == null ? (class$java$lang$Short = ConversionManager.class$("java.lang.Short")) : class$java$lang$Short);
        vector.addElement(class$java$lang$Number == null ? (class$java$lang$Number = ConversionManager.class$("java.lang.Number")) : class$java$lang$Number);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        vector.addElement(Boolean.TYPE);
        vector.addElement(Integer.TYPE);
        vector.addElement(Long.TYPE);
        vector.addElement(Short.TYPE);
        return vector;
    }

    protected Vector buildFromNumberVec() {
        Vector vector = this.buildNumberVec();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Character == null ? (class$java$lang$Character = ConversionManager.class$("java.lang.Character")) : class$java$lang$Character);
        vector.addElement(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConversionManager.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        vector.addElement(Character.TYPE);
        vector.addElement(Integer.TYPE);
        vector.addElement(Double.TYPE);
        vector.addElement(Float.TYPE);
        vector.addElement(Long.TYPE);
        vector.addElement(Short.TYPE);
        vector.addElement(Byte.TYPE);
        vector.addElement(Boolean.TYPE);
        return vector;
    }

    protected Vector buildFromBigDecimalVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromBigIntegerVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromIntegerVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromFloatVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromDoubleVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromShortVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromByteVec() {
        return this.buildFromNumberVec();
    }

    protected Vector buildFromLongVec() {
        Vector vector = this.buildFromNumberVec();
        vector.addAll(this.buildDateTimeVec());
        vector.addElement(class$java$sql$Date == null ? (class$java$sql$Date = ConversionManager.class$("java.sql.Date")) : class$java$sql$Date);
        vector.addElement(class$java$sql$Time == null ? (class$java$sql$Time = ConversionManager.class$("java.sql.Time")) : class$java$sql$Time);
        return vector;
    }

    protected Vector buildFromStringVec() {
        Vector vector = this.buildFromLongVec();
        vector.addElement(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = ConversionManager.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        vector.addElement(array$B == null ? (array$B = ConversionManager.class$("[B")) : array$B);
        vector.addElement(class$java$sql$Clob == null ? (class$java$sql$Clob = ConversionManager.class$("java.sql.Clob")) : class$java$sql$Clob);
        return vector;
    }

    protected Vector buildFromCharacterVec() {
        Vector<Class<Comparable<Character>>> vector = new Vector<Class<Comparable<Character>>>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConversionManager.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(class$java$lang$Character == null ? (class$java$lang$Character = ConversionManager.class$("java.lang.Character")) : class$java$lang$Character);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        vector.addElement(Character.TYPE);
        vector.addElement(Boolean.TYPE);
        return vector;
    }

    protected Vector buildFromByteArrayVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(array$B == null ? (array$B = ConversionManager.class$("[B")) : array$B);
        vector.addElement(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = ConversionManager.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        return vector;
    }

    protected Vector buildFromClobVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        return vector;
    }

    protected Vector buildFromBlobVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = ConversionManager.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        vector.addElement(array$B == null ? (array$B = ConversionManager.class$("[B")) : array$B);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        return vector;
    }

    protected Vector buildFromUtilDateVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$sql$Date == null ? (class$java$sql$Date = ConversionManager.class$("java.sql.Date")) : class$java$sql$Date);
        vector.addElement(class$java$sql$Time == null ? (class$java$sql$Time = ConversionManager.class$("java.sql.Time")) : class$java$sql$Time);
        vector.addElement(Long.TYPE);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        return vector;
    }

    protected Vector buildFromTimestampVec() {
        return this.buildFromUtilDateVec();
    }

    protected Vector buildFromCalendarVec() {
        return this.buildFromUtilDateVec();
    }

    protected Vector buildFromDateVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$sql$Date == null ? (class$java$sql$Date = ConversionManager.class$("java.sql.Date")) : class$java$sql$Date);
        vector.addElement(Long.TYPE);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        return vector;
    }

    protected Vector buildFromTimeVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$sql$Time == null ? (class$java$sql$Time = ConversionManager.class$("java.sql.Time")) : class$java$sql$Time);
        vector.addElement(Long.TYPE);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        return vector;
    }

    protected Vector buildFromByteObjectArraryVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$sql$Blob == null ? (class$java$sql$Blob = ConversionManager.class$("java.sql.Blob")) : class$java$sql$Blob);
        vector.addElement(array$B == null ? (array$B = ConversionManager.class$("[B")) : array$B);
        return vector;
    }

    protected Vector buildFromCharArrayVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$sql$Clob == null ? (class$java$sql$Clob = ConversionManager.class$("java.sql.Clob")) : class$java$sql$Clob);
        return vector;
    }

    protected Vector buildFromCharacterArrayVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$sql$Clob == null ? (class$java$sql$Clob = ConversionManager.class$("java.sql.Clob")) : class$java$sql$Clob);
        return vector;
    }

    protected void buildDataTypesConvertedToAClass() {
        this.dataTypesConvertedToAClass.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConversionManager.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, this.buildToBigDecimalVec());
        this.dataTypesConvertedToAClass.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConversionManager.class$("java.math.BigInteger")) : class$java$math$BigInteger, this.buildToBigIntegerVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConversionManager.class$("java.lang.Boolean")) : class$java$lang$Boolean, this.buildToBooleanVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ConversionManager.class$("java.lang.Byte")) : class$java$lang$Byte, this.buildToByteVec());
        this.dataTypesConvertedToAClass.put(array$B == null ? (array$B = ConversionManager.class$("[B")) : array$B, this.buildToByteArrayVec());
        this.dataTypesConvertedToAClass.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = ConversionManager.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, this.buildToByteObjectArrayVec());
        this.dataTypesConvertedToAClass.put(class$java$util$Calendar == null ? (class$java$util$Calendar = ConversionManager.class$("java.util.Calendar")) : class$java$util$Calendar, this.buildToCalendarVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$Character == null ? (class$java$lang$Character = ConversionManager.class$("java.lang.Character")) : class$java$lang$Character, this.buildToCharacterVec());
        this.dataTypesConvertedToAClass.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, this.buildToCharacterArrayVec());
        this.dataTypesConvertedToAClass.put(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C, this.buildToCharArrayVec());
        this.dataTypesConvertedToAClass.put(class$java$sql$Date == null ? (class$java$sql$Date = ConversionManager.class$("java.sql.Date")) : class$java$sql$Date, this.buildToDateVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$Double == null ? (class$java$lang$Double = ConversionManager.class$("java.lang.Double")) : class$java$lang$Double, this.buildToDoubleVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$Float == null ? (class$java$lang$Float = ConversionManager.class$("java.lang.Float")) : class$java$lang$Float, this.buildToFloatVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ConversionManager.class$("java.lang.Integer")) : class$java$lang$Integer, this.buildToIntegerVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long, this.buildToLongVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$Number == null ? (class$java$lang$Number = ConversionManager.class$("java.lang.Number")) : class$java$lang$Number, this.buildToNumberVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$Short == null ? (class$java$lang$Short = ConversionManager.class$("java.lang.Short")) : class$java$lang$Short, this.buildToShortVec());
        this.dataTypesConvertedToAClass.put(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String, this.buildToStringVec());
        this.dataTypesConvertedToAClass.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ConversionManager.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, this.buildToTimestampVec());
        this.dataTypesConvertedToAClass.put(class$java$sql$Time == null ? (class$java$sql$Time = ConversionManager.class$("java.sql.Time")) : class$java$sql$Time, this.buildToTimeVec());
        this.dataTypesConvertedToAClass.put(class$java$util$Date == null ? (class$java$util$Date = ConversionManager.class$("java.util.Date")) : class$java$util$Date, this.buildToUtilDateVec());
        this.dataTypesConvertedToAClass.put(class$java$sql$Clob == null ? (class$java$sql$Clob = ConversionManager.class$("java.sql.Clob")) : class$java$sql$Clob, this.buildToClobVec());
        this.dataTypesConvertedToAClass.put(class$java$sql$Blob == null ? (class$java$sql$Blob = ConversionManager.class$("java.sql.Blob")) : class$java$sql$Blob, this.buildToBlobVec());
    }

    protected Vector buildAllTypesToAClassVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Integer == null ? (class$java$lang$Integer = ConversionManager.class$("java.lang.Integer")) : class$java$lang$Integer);
        vector.addElement(class$java$util$Date == null ? (class$java$util$Date = ConversionManager.class$("java.util.Date")) : class$java$util$Date);
        vector.addElement(class$java$sql$Date == null ? (class$java$sql$Date = ConversionManager.class$("java.sql.Date")) : class$java$sql$Date);
        vector.addElement(class$java$sql$Time == null ? (class$java$sql$Time = ConversionManager.class$("java.sql.Time")) : class$java$sql$Time);
        vector.addElement(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ConversionManager.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        vector.addElement(class$java$util$Calendar == null ? (class$java$util$Calendar = ConversionManager.class$("java.util.Calendar")) : class$java$util$Calendar);
        vector.addElement(class$java$lang$Character == null ? (class$java$lang$Character = ConversionManager.class$("java.lang.Character")) : class$java$lang$Character);
        vector.addElement(class$java$lang$Double == null ? (class$java$lang$Double = ConversionManager.class$("java.lang.Double")) : class$java$lang$Double);
        vector.addElement(class$java$lang$Float == null ? (class$java$lang$Float = ConversionManager.class$("java.lang.Float")) : class$java$lang$Float);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$lang$Short == null ? (class$java$lang$Short = ConversionManager.class$("java.lang.Short")) : class$java$lang$Short);
        vector.addElement(class$java$lang$Byte == null ? (class$java$lang$Byte = ConversionManager.class$("java.lang.Byte")) : class$java$lang$Byte);
        vector.addElement(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ConversionManager.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        vector.addElement(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ConversionManager.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        vector.addElement(class$java$lang$Number == null ? (class$java$lang$Number = ConversionManager.class$("java.lang.Number")) : class$java$lang$Number);
        vector.addElement(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConversionManager.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        vector.addElement(class$java$sql$Blob == null ? (class$java$sql$Blob = ConversionManager.class$("java.sql.Blob")) : class$java$sql$Blob);
        vector.addElement(class$java$sql$Clob == null ? (class$java$sql$Clob = ConversionManager.class$("java.sql.Clob")) : class$java$sql$Clob);
        return vector;
    }

    protected Vector buildToBigDecimalVec() {
        Vector vector = this.buildNumberVec();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        return vector;
    }

    protected Vector buildToBigIntegerVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToBooleanVec() {
        Vector vector = this.buildToBigDecimalVec();
        vector.addElement(class$java$lang$Character == null ? (class$java$lang$Character = ConversionManager.class$("java.lang.Character")) : class$java$lang$Character);
        vector.addElement(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConversionManager.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        return vector;
    }

    protected Vector buildToByteVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToDoubleVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToFloatVec() {
        return this.buildToBigDecimalVec();
    }

    protected Vector buildToIntegerVec() {
        Vector vector = this.buildToBigDecimalVec();
        vector.addElement(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConversionManager.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        return vector;
    }

    protected Vector buildToLongVec() {
        Vector vector = this.buildToIntegerVec();
        vector.addElement(class$java$util$Calendar == null ? (class$java$util$Calendar = ConversionManager.class$("java.util.Calendar")) : class$java$util$Calendar);
        vector.addElement(class$java$util$Date == null ? (class$java$util$Date = ConversionManager.class$("java.util.Date")) : class$java$util$Date);
        return vector;
    }

    protected Vector buildToNumberVec() {
        return this.buildToIntegerVec();
    }

    protected Vector buildToShortVec() {
        return this.buildToIntegerVec();
    }

    protected Vector buildToByteArrayVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$sql$Blob == null ? (class$java$sql$Blob = ConversionManager.class$("java.sql.Blob")) : class$java$sql$Blob);
        vector.addElement(array$B == null ? (array$B = ConversionManager.class$("[B")) : array$B);
        vector.addElement(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = ConversionManager.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        return vector;
    }

    protected Vector buildToByteObjectArrayVec() {
        Vector vector = this.buildToByteArrayVec();
        vector.addElement(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = ConversionManager.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        return vector;
    }

    protected Vector buildToCharacterVec() {
        Vector vector = this.buildToBigDecimalVec();
        vector.addElement(class$java$lang$Character == null ? (class$java$lang$Character = ConversionManager.class$("java.lang.Character")) : class$java$lang$Character);
        return vector;
    }

    protected Vector buildToCharacterArrayVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected Vector buildToCharArrayVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected Vector buildToStringVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected Vector buildToCalendarVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$sql$Date == null ? (class$java$sql$Date = ConversionManager.class$("java.sql.Date")) : class$java$sql$Date);
        vector.addElement(class$java$sql$Time == null ? (class$java$sql$Time = ConversionManager.class$("java.sql.Time")) : class$java$sql$Time);
        return vector;
    }

    protected Vector buildToTimestampVec() {
        return this.buildToCalendarVec();
    }

    protected Vector buildToUtilDateVec() {
        return this.buildToCalendarVec();
    }

    protected Vector buildToDateVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$sql$Date == null ? (class$java$sql$Date = ConversionManager.class$("java.sql.Date")) : class$java$sql$Date);
        return vector;
    }

    protected Vector buildToTimeVec() {
        Vector vector = this.buildDateTimeVec();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(class$java$lang$Long == null ? (class$java$lang$Long = ConversionManager.class$("java.lang.Long")) : class$java$lang$Long);
        vector.addElement(class$java$sql$Time == null ? (class$java$sql$Time = ConversionManager.class$("java.sql.Time")) : class$java$sql$Time);
        return vector;
    }

    protected Vector buildToBlobVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = ConversionManager.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        vector.addElement(array$B == null ? (array$B = ConversionManager.class$("[B")) : array$B);
        return vector;
    }

    protected Vector buildToClobVec() {
        Vector<Class> vector = new Vector<Class>();
        vector.addElement(class$java$lang$String == null ? (class$java$lang$String = ConversionManager.class$("java.lang.String")) : class$java$lang$String);
        vector.addElement(array$C == null ? (array$C = ConversionManager.class$("[C")) : array$C);
        vector.addElement(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = ConversionManager.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

