/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.internal.helper.DeferredLockManager;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.logging.AbstractSessionLog;

public class ConcurrencyManager
implements Serializable {
    protected int numberOfReaders = 0;
    protected int depth = 0;
    protected int numberOfWritersWaiting = 0;
    protected transient Thread activeThread;
    public static Hashtable deferredLockManagers;
    protected boolean lockedByMergeManager;
    protected CacheKey ownerCacheKey;

    public ConcurrencyManager() {
    }

    public ConcurrencyManager(CacheKey cacheKey) {
        this();
        this.ownerCacheKey = cacheKey;
    }

    public synchronized void acquire() throws ConcurrencyException {
        this.acquire(false);
    }

    public synchronized void acquire(boolean bl) throws ConcurrencyException {
        while (this.getActiveThread() != Thread.currentThread() && (this.getActiveThread() != null || this.getNumberOfReaders() != 0)) {
            try {
                this.setNumberOfWritersWaiting(this.getNumberOfWritersWaiting() + 1);
                this.wait();
                this.setNumberOfWritersWaiting(this.getNumberOfWritersWaiting() - 1);
            }
            catch (InterruptedException interruptedException) {
                throw ConcurrencyException.waitWasInterrupted(interruptedException.getMessage());
            }
        }
        if (this.getActiveThread() == null) {
            this.setActiveThread(Thread.currentThread());
        }
        this.setIsLockedByMergeManager(bl);
        this.setDepth(this.getDepth() + 1);
    }

    public synchronized boolean acquireNoWait() throws ConcurrencyException {
        if (!this.isAcquired() || this.getActiveThread() == Thread.currentThread()) {
            this.acquire(false);
            return true;
        }
        return false;
    }

    public synchronized boolean acquireNoWait(boolean bl) throws ConcurrencyException {
        if (!this.isAcquired() || this.getActiveThread() == Thread.currentThread()) {
            this.acquire(bl);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDeferredLock() throws ConcurrencyException {
        Thread thread = Thread.currentThread();
        DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (deferredLockManager == null) {
            deferredLockManager = new DeferredLockManager();
            this.putDeferredLock(thread, deferredLockManager);
        }
        deferredLockManager.incrementDepth();
        ConcurrencyManager concurrencyManager = this;
        synchronized (concurrencyManager) {
            while (this.getNumberOfReaders() != 0) {
                try {
                    this.setNumberOfWritersWaiting(this.getNumberOfWritersWaiting() + 1);
                    this.wait();
                    this.setNumberOfWritersWaiting(this.getNumberOfWritersWaiting() - 1);
                }
                catch (InterruptedException interruptedException) {
                    throw ConcurrencyException.waitWasInterrupted(interruptedException.getMessage());
                }
            }
            if (this.getActiveThread() == thread || !this.isAcquired()) {
                deferredLockManager.addActiveLock(this);
                this.acquire();
            } else {
                deferredLockManager.addDeferredLock(this);
                AbstractSessionLog.getLog().log(2, "acquiring_deferred_lock", this.getOwnerCacheKey().getObject(), thread.getName());
            }
        }
    }

    public void checkReadLock() throws ConcurrencyException {
        if (this.getActiveThread() == null) {
            return;
        }
        this.acquireReadLock();
        this.releaseReadLock();
    }

    public synchronized void acquireReadLock() throws ConcurrencyException {
        while (this.getActiveThread() != Thread.currentThread() && this.getActiveThread() != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw ConcurrencyException.waitWasInterrupted(interruptedException.getMessage());
            }
        }
        this.setNumberOfReaders(this.getNumberOfReaders() + 1);
    }

    public synchronized boolean acquireReadLockNoWait() {
        if (!this.isAcquired()) {
            this.acquireReadLock();
            return true;
        }
        return false;
    }

    public Thread getActiveThread() {
        return this.activeThread;
    }

    public static synchronized DeferredLockManager getDeferredLockManager(Thread thread) {
        return (DeferredLockManager)ConcurrencyManager.getDeferredLockManagers().get(thread);
    }

    protected static Hashtable getDeferredLockManagers() {
        if (deferredLockManagers == null) {
            deferredLockManagers = new Hashtable(50);
        }
        return deferredLockManagers;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNumberOfReaders() {
        return this.numberOfReaders;
    }

    public int getNumberOfWritersWaiting() {
        return this.numberOfWritersWaiting;
    }

    public CacheKey getOwnerCacheKey() {
        return this.ownerCacheKey;
    }

    public boolean isAcquired() {
        return this.depth > 0;
    }

    public boolean isLockedByMergeManager() {
        return this.lockedByMergeManager;
    }

    public static synchronized boolean isBuildObjectOnThreadComplete(Thread thread, IdentityHashtable identityHashtable) {
        if (identityHashtable.containsKey(thread)) {
            return true;
        }
        identityHashtable.put(thread, thread);
        DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (deferredLockManager == null) {
            return true;
        }
        Vector vector = deferredLockManager.getDeferredLocks();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ConcurrencyManager concurrencyManager = (ConcurrencyManager)enumeration.nextElement();
            Thread thread2 = null;
            if (!concurrencyManager.isAcquired() || (thread2 = concurrencyManager.getActiveThread()) == null) continue;
            DeferredLockManager deferredLockManager2 = ConcurrencyManager.getDeferredLockManager(thread2);
            if (deferredLockManager2 == null) {
                return false;
            }
            if (deferredLockManager2.isThreadComplete()) {
                thread2 = concurrencyManager.getActiveThread();
                if (thread2 == null || ConcurrencyManager.isBuildObjectOnThreadComplete(thread2, identityHashtable)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isNested() {
        return this.depth > 1;
    }

    public synchronized void putDeferredLock(Thread thread, DeferredLockManager deferredLockManager) {
        ConcurrencyManager.getDeferredLockManagers().put(thread, deferredLockManager);
    }

    public synchronized void release() throws ConcurrencyException {
        if (this.getDepth() == 0) {
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        this.setDepth(this.getDepth() - 1);
        if (this.getDepth() == 0) {
            this.setActiveThread(null);
            this.setIsLockedByMergeManager(false);
            this.notifyAll();
        }
    }

    public void releaseDeferredLock() throws ConcurrencyException {
        Thread thread = Thread.currentThread();
        DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(thread);
        if (deferredLockManager == null) {
            return;
        }
        int n = deferredLockManager.getThreadDepth();
        if (n > 1) {
            deferredLockManager.decrementDepth();
            return;
        }
        if (!deferredLockManager.hasDeferredLock()) {
            deferredLockManager.releaseActiveLocksOnThread();
            ConcurrencyManager.removeDeferredLockManager(thread);
            return;
        }
        deferredLockManager.setIsThreadComplete(true);
        while (true) {
            IdentityHashtable identityHashtable;
            if (ConcurrencyManager.isBuildObjectOnThreadComplete(thread, identityHashtable = new IdentityHashtable())) {
                deferredLockManager.releaseActiveLocksOnThread();
                ConcurrencyManager.removeDeferredLockManager(thread);
                AbstractSessionLog.getLog().log(2, "deferred_locks_released", thread.getName());
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized void releaseReadLock() throws ConcurrencyException {
        if (this.getNumberOfReaders() == 0) {
            throw ConcurrencyException.signalAttemptedBeforeWait();
        }
        this.setNumberOfReaders(this.getNumberOfReaders() - 1);
        if (this.getNumberOfReaders() == 0) {
            this.notifyAll();
        }
    }

    public static synchronized DeferredLockManager removeDeferredLockManager(Thread thread) {
        return (DeferredLockManager)ConcurrencyManager.getDeferredLockManagers().remove(thread);
    }

    public void setActiveThread(Thread thread) {
        this.activeThread = thread;
    }

    protected void setDepth(int n) {
        this.depth = n;
    }

    public void setIsLockedByMergeManager(boolean bl) {
        this.lockedByMergeManager = bl;
    }

    protected void setNumberOfReaders(int n) {
        this.numberOfReaders = n;
    }

    protected void setNumberOfWritersWaiting(int n) {
        this.numberOfWritersWaiting = n;
    }

    public String toString() {
        Object[] objectArray = new Object[]{new Integer(this.getDepth())};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("nest_level", objectArray);
    }
}

