/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.expressions.ExpressionIterator;
import oracle.toplink.internal.expressions.ExpressionNormalizer;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.LogicalExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.expressions.RelationExpression;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.internal.queryframework.StatementQueryMechanism;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReportQuery;
import oracle.toplink.queryframework.SQLCall;

public class SubSelectExpression
extends Expression {
    protected Expression baseExpression;
    protected ReportQuery subQuery;

    public SubSelectExpression() {
    }

    public SubSelectExpression(ReportQuery reportQuery, Expression expression) {
        this();
        this.subQuery = reportQuery;
        this.baseExpression = expression;
    }

    public String descriptionOfNodeType() {
        return "SubSelect";
    }

    public Expression getBaseExpression() {
        return this.baseExpression;
    }

    public ExpressionBuilder getBuilder() {
        return this.getBaseExpression().getBuilder();
    }

    public ReportQuery getSubQuery() {
        return this.subQuery;
    }

    public void iterateOn(ExpressionIterator expressionIterator) {
        super.iterateOn(expressionIterator);
        if (this.baseExpression != null) {
            this.baseExpression.iterateOn(expressionIterator);
        }
        if (expressionIterator.shouldIterateOverSubSelects()) {
            if (this.getSubQuery().getSelectionCriteria() != null) {
                this.getSubQuery().getSelectionCriteria().iterateOn(expressionIterator);
            } else {
                this.getSubQuery().getExpressionBuilder().iterateOn(expressionIterator);
            }
        }
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        this.validateNode();
        expressionNormalizer.addSubSelectExpression(this);
        expressionNormalizer.getStatement().setRequiresAliases(true);
        return this;
    }

    public Expression normalizeSubSelect(ExpressionNormalizer expressionNormalizer, Dictionary dictionary) {
        Cloneable cloneable;
        if (!this.getSubQuery().isCallQuery() && this.getSubQuery().getReferenceClass() == null) {
            Expression expression;
            cloneable = this.getSubQuery();
            Expression expression2 = ((DatabaseQuery)cloneable).getSelectionCriteria();
            if (expression2 instanceof LogicalExpression) {
                expression2 = ((LogicalExpression)expression2).getFirstChild();
            }
            if (expression2 instanceof RelationExpression && (expression = ((RelationExpression)expression2).getSecondChild()) instanceof QueryKeyExpression) {
                ((ObjectLevelReadQuery)cloneable).setReferenceClass(((QueryKeyExpression)expression).getDescriptor().getJavaClass());
            }
        }
        this.validateNode();
        this.getSubQuery().prepareSubSelect(expressionNormalizer.getSession(), null, dictionary);
        if (!this.getSubQuery().isCallQuery()) {
            cloneable = (SQLSelectStatement)((StatementQueryMechanism)this.getSubQuery().getQueryMechanism()).getSQLStatement();
            ((SQLSelectStatement)cloneable).setRequiresAliases(true);
            ((SQLSelectStatement)cloneable).setParentStatement(expressionNormalizer.getStatement());
            ((SQLSelectStatement)cloneable).normalize(expressionNormalizer.getSession(), this.getSubQuery().getDescriptor(), dictionary);
        }
        return this;
    }

    protected void postCopyIn(Dictionary dictionary) {
        super.postCopyIn(dictionary);
        this.setBaseExpression(this.getBaseExpression().copiedVersionFrom(dictionary));
        ReportQuery reportQuery = (ReportQuery)this.getSubQuery().clone();
        if (!reportQuery.isCallQuery() && reportQuery.getSelectionCriteria() != null) {
            reportQuery.setSelectionCriteria(this.getSubQuery().getSelectionCriteria().copiedVersionFrom(dictionary));
            if (dictionary.get(dictionary) != null) {
                reportQuery.copyReportItems(dictionary);
            }
        }
        this.setSubQuery(reportQuery);
    }

    protected void printCustomSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        SQLCall sQLCall = (SQLCall)this.getSubQuery().getCall();
        sQLCall.translateCustomQuery();
        expressionSQLPrinter.getCall().getParameters().addAll(sQLCall.getParameters());
        expressionSQLPrinter.getCall().getParameterTypes().addAll(sQLCall.getParameterTypes());
        expressionSQLPrinter.printString(sQLCall.getCallString());
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        ReportQuery reportQuery = this.getSubQuery();
        expressionSQLPrinter.printString("(");
        if (reportQuery.isCallQuery()) {
            this.printCustomSQL(expressionSQLPrinter);
        } else {
            SQLSelectStatement sQLSelectStatement = (SQLSelectStatement)((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).getSQLStatement();
            boolean bl = expressionSQLPrinter.isFirstElementPrinted();
            expressionSQLPrinter.setIsFirstElementPrinted(false);
            boolean bl2 = expressionSQLPrinter.requiresDistinct();
            sQLSelectStatement.printSQL(expressionSQLPrinter);
            expressionSQLPrinter.setIsFirstElementPrinted(bl);
            expressionSQLPrinter.setRequiresDistinct(bl2);
        }
        expressionSQLPrinter.printString(")");
    }

    public Expression rebuildOn(Expression expression) {
        return this;
    }

    protected void setBaseExpression(Expression expression) {
        this.baseExpression = expression;
    }

    public void setSubQuery(ReportQuery reportQuery) {
        this.subQuery = reportQuery;
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(String.valueOf(this.getSubQuery()));
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
        if (this.getSubQuery().getSelectionCriteria() != null) {
            this.getSubQuery().getSelectionCriteria().toString(bufferedWriter, n);
        }
    }
}

