/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.Serializable;
import java.io.StringWriter;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessions.DatabaseLogin;

public abstract class SQLStatement
implements Serializable,
Cloneable {
    protected Expression whereClause;
    protected ExpressionBuilder builder;
    protected DatabaseRow translationRow;
    protected String hintString;

    public abstract DatabaseCall buildCall(Session var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ExpressionBuilder getBuilder() {
        return this.builder;
    }

    public ExpressionBuilder getExpressionBuilder() {
        return this.builder;
    }

    public String getHintString() {
        return this.hintString;
    }

    public DatabaseRow getTranslationRow() {
        return this.translationRow;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public void setHintString(String string) {
        this.hintString = string;
    }

    protected void setBuilder(ExpressionBuilder expressionBuilder) {
        this.builder = expressionBuilder;
    }

    public void setTranslationRow(DatabaseRow databaseRow) {
        this.translationRow = databaseRow;
    }

    public void setWhereClause(Expression expression) {
        this.whereClause = expression;
        if (expression != null) {
            this.builder = expression.getBuilder();
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.getShortClassName(this.getClass()));
        stringWriter.write("(");
        try {
            DatabaseCall databaseCall = this.buildCall(new DatabaseSessionImpl(new DatabaseLogin()));
            stringWriter.write(databaseCall.getSQLString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringWriter.write(")");
        return stringWriter.toString();
    }
}

