/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.expressions.DataExpression;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;

public class ParameterExpression
extends Expression {
    protected DatabaseField field;
    protected Expression localBase;
    protected Expression baseExpression;

    public ParameterExpression() {
    }

    public ParameterExpression(String string) {
        this(new DatabaseField(string));
    }

    public ParameterExpression(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public ParameterExpression(String string, Expression expression) {
        this(new DatabaseField(string), expression);
    }

    public ParameterExpression(DatabaseField databaseField, Expression expression) {
        this.field = databaseField;
        this.localBase = expression;
    }

    public String basicDescription() {
        return String.valueOf(this.getField());
    }

    public String descriptionOfNodeType() {
        return "Parameter";
    }

    public Expression get(String string) {
        ParameterExpression parameterExpression = new ParameterExpression(string);
        parameterExpression.setBaseExpression(this);
        return parameterExpression;
    }

    public Expression getBaseExpression() {
        return this.baseExpression;
    }

    public ExpressionBuilder getBuilder() {
        if (this.localBase == null) {
            return null;
        }
        return this.localBase.getBuilder();
    }

    public DatabaseField getField() {
        return this.field;
    }

    public Expression getField(DatabaseField databaseField) {
        ParameterExpression parameterExpression = new ParameterExpression(databaseField);
        parameterExpression.setBaseExpression(this);
        return parameterExpression;
    }

    public Expression getLocalBase() {
        return this.localBase;
    }

    public Object getValue(DatabaseRow databaseRow, Session session) {
        if (this.getField() == null) {
            return null;
        }
        Object object = null;
        if (this.getBaseExpression() != null) {
            object = ((ParameterExpression)this.getBaseExpression()).getValue(databaseRow, session);
            if (object == null) {
                return null;
            }
            Descriptor descriptor = session.getDescriptor(object);
            if (descriptor != null) {
                object = descriptor.getObjectBuilder().unwrapObject(object, session);
                databaseRow.put(((ParameterExpression)this.getBaseExpression()).getField(), object);
                DatabaseMapping databaseMapping = descriptor.getObjectBuilder().getMappingForField(this.getField());
                if (databaseMapping != null) {
                    object = databaseMapping.valueFromObject(object, this.getField(), session);
                } else {
                    databaseMapping = descriptor.getObjectBuilder().getMappingForAttributeName(this.getField().getName());
                    if (databaseMapping != null) {
                        object = databaseMapping.getRealAttributeValueFromObject(object, session);
                    } else {
                        DatabaseField databaseField = descriptor.getObjectBuilder().getFieldForQueryKeyName(this.getField().getName());
                        if (databaseField != null && (databaseMapping = descriptor.getObjectBuilder().getMappingForField(this.getField())) != null) {
                            object = databaseMapping.valueFromObject(object, this.getField(), session);
                        }
                    }
                }
            }
        } else {
            object = databaseRow == null ? DatabaseRow.noEntry : databaseRow.getIndicatingNoEntry(this.getField());
            if (object == DatabaseRow.noEntry) {
                throw QueryException.parameterNameMismatch(this.getField().getName());
            }
        }
        if (this.getLocalBase() != null) {
            object = this.getLocalBase().getFieldValue(object);
        }
        return object;
    }

    public boolean isParameterExpression() {
        return true;
    }

    public boolean isValueExpression() {
        return true;
    }

    protected void postCopyIn(Dictionary dictionary) {
        super.postCopyIn(dictionary);
        if (this.getLocalBase() != null) {
            this.setLocalBase(this.getLocalBase().copiedVersionFrom(dictionary));
        }
        if (this.getBaseExpression() != null) {
            this.setBaseExpression(this.getBaseExpression().copiedVersionFrom(dictionary));
        }
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        if (expressionSQLPrinter.shouldPrintParameterValues()) {
            Object object = this.getValue(expressionSQLPrinter.getTranslationRow(), expressionSQLPrinter.getSession());
            expressionSQLPrinter.printPrimitive(object);
        } else if (this.getField() != null) {
            expressionSQLPrinter.printParameter(this);
        }
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        ((DataExpression)this.getLocalBase()).getBaseExpression().printJava(expressionJavaPrinter);
        expressionJavaPrinter.printString(".getParameter(\"" + this.getField().getQualifiedName() + "\")");
    }

    public Expression rebuildOn(Expression expression) {
        ParameterExpression parameterExpression = (ParameterExpression)this.clone();
        parameterExpression.setLocalBase(this.localBase.rebuildOn(expression));
        return parameterExpression;
    }

    protected void setBaseExpression(Expression expression) {
        this.baseExpression = expression;
    }

    public void setLocalBase(Expression expression) {
        this.localBase = expression;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        return expression2.getField(this.getField());
    }

    public Object valueFromObject(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        if (this.getField() != null) {
            return this.getValue(databaseRow, session);
        }
        throw QueryException.cannotConformExpression();
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.basicDescription());
    }

    public void writeSubexpressionsTo(BufferedWriter bufferedWriter, int n) throws IOException {
        if (this.getBaseExpression() != null) {
            this.getBaseExpression().toString(bufferedWriter, n);
        }
    }
}

