/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.DataExpression;
import oracle.toplink.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;

public class FieldExpression
extends DataExpression {
    protected DatabaseField field;
    protected transient DatabaseField aliasedField;

    public FieldExpression() {
    }

    public FieldExpression(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public FieldExpression(DatabaseField databaseField, Expression expression) {
        this.field = databaseField;
        this.baseExpression = expression;
    }

    public void clearAliases() {
        super.clearAliases();
        this.aliasedField = null;
    }

    public String descriptionOfNodeType() {
        return "Field";
    }

    public DatabaseField getAliasedField() {
        if (this.aliasedField == null) {
            this.initializeAliasedField();
        }
        return this.aliasedField;
    }

    private DatabaseTable getAliasedTable() {
        DatabaseTable databaseTable;
        DataExpression dataExpression = (DataExpression)this.getBaseExpression();
        if (!this.getField().hasTableName()) {
            dataExpression.getDescriptor().buildField(this.getField());
        }
        if ((databaseTable = dataExpression.aliasForTable(this.getField().getTable())) == null) {
            return this.getField().getTable();
        }
        return databaseTable;
    }

    public DatabaseField getClonedField() {
        return (DatabaseField)this.getField().clone();
    }

    public Vector getClonedFields() {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(this.getField().clone());
        return vector;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public Vector getFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    private void initializeAliasedField() {
        DatabaseField databaseField = (DatabaseField)this.getField().clone();
        DatabaseTable databaseTable = this.getAliasedTable();
        this.aliasedField = databaseField;
        this.aliasedField.setTable(databaseTable);
    }

    public boolean isAttribute() {
        return true;
    }

    public boolean isFieldExpression() {
        return true;
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        expressionSQLPrinter.printField(this.getAliasedField());
    }

    public void printJava(ExpressionJavaPrinter expressionJavaPrinter) {
        this.getBaseExpression().printJava(expressionJavaPrinter);
        expressionJavaPrinter.printString(".getField(\"" + this.getField().getQualifiedName() + "\")");
    }

    public Expression rebuildOn(Expression expression) {
        FieldExpression fieldExpression = new FieldExpression(this.getField(), this.getBaseExpression().rebuildOn(expression));
        fieldExpression.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return fieldExpression;
    }

    public void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        Expression expression3 = this.getBaseExpression().twistedForBaseAndContext(expression, expression2);
        return expression3.getField(this.getField());
    }

    public void validateNode() {
        Vector vector;
        DataExpression dataExpression = (DataExpression)this.getBaseExpression();
        if (this.getField().getTable().hasName() && (vector = dataExpression.getOwnedTables()) != null && !vector.contains(this.getField().getTable())) {
            throw QueryException.invalidTableForFieldInExpression(this.getField());
        }
    }

    public Object valueFromObject(Object object, Session session, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        if (this.getBuilder() != this.getBaseExpression()) {
            throw QueryException.cannotConformExpression();
        }
        DatabaseMapping databaseMapping = session.getDescriptor(object.getClass()).getObjectBuilder().getMappingForField(this.getField());
        if (databaseMapping == null) {
            throw QueryException.cannotConformExpression();
        }
        return databaseMapping.valueFromObject(object, this.getField(), session);
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.getField().toString());
    }

    public void writeFields(ExpressionSQLPrinter expressionSQLPrinter, Vector vector, SQLSelectStatement sQLSelectStatement) {
        DatabaseField databaseField = this.getField();
        if (databaseField != null) {
            vector.addElement(databaseField);
            this.writeField(expressionSQLPrinter, databaseField, sQLSelectStatement);
        }
    }
}

