/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp3.base;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.ClassDescriptor;
import oracle.toplink.ejb.cmp3.base.EntityManagerFactoryProvider;
import oracle.toplink.exceptions.EntityManagerSetupException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.ejb.cmp3.base.CMP3Policy;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.platform.server.CustomServerPlatform;
import oracle.toplink.platform.server.NoServerPlatform;
import oracle.toplink.platform.server.ServerPlatform;
import oracle.toplink.platform.server.ServerPlatformBase;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.sessions.Connector;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DefaultConnector;
import oracle.toplink.sessions.Project;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public class EntityManagerSetupImpl {
    public static String EJB30_SESSIONS_XML_NAME = "META-INF/ejb3-toplink-sessions.xml";
    public static final String DEFAULT_SESSION_NAME = "default";
    protected String sessionName = null;
    protected String sessionsXMLName = null;
    protected String deployedSessionName = null;
    static /* synthetic */ Class class$oracle$toplink$sessions$DatabaseSession;

    protected ServerSession loadSessionFromXML(ClassLoader classLoader) {
        ValidationException validationException;
        ServerSession serverSession;
        block14: {
            if (this.sessionsXMLName == null) {
                this.sessionsXMLName = EJB30_SESSIONS_XML_NAME;
            }
            serverSession = null;
            SessionManager sessionManager = new SessionManager();
            validationException = null;
            try {
                XMLSessionConfigLoader xMLSessionConfigLoader;
                block13: {
                    xMLSessionConfigLoader = new XMLSessionConfigLoader(this.sessionsXMLName);
                    if (this.sessionName != null) {
                        try {
                            serverSession = (ServerSession)sessionManager.getSession(xMLSessionConfigLoader, this.sessionName, classLoader, false, true, false);
                        }
                        catch (ValidationException validationException2) {
                            if (!this.sessionMustBeDefinedInSessionsXML()) break block13;
                            throw EntityManagerSetupException.sessionXMLValidationException(this.sessionName, this.sessionsXMLName, validationException2);
                        }
                    }
                }
                if (serverSession != null) break block14;
                try {
                    serverSession = (ServerSession)sessionManager.getSession(xMLSessionConfigLoader, DEFAULT_SESSION_NAME, classLoader, false, true, false);
                }
                catch (ValidationException validationException3) {
                    validationException = validationException3;
                }
                if (serverSession == null && sessionManager.getSessions().size() == 1) {
                    serverSession = (ServerSession)sessionManager.getSessions().values().iterator().next();
                }
            }
            catch (ClassCastException classCastException) {
                throw EntityManagerSetupException.wrongSessionTypeException(this.sessionName, this.sessionsXMLName, classCastException);
            }
            finally {
                sessionManager.getSessions().clear();
            }
        }
        if (serverSession == null && this.sessionMustBeDefinedInSessionsXML() && validationException != null) {
            throw EntityManagerSetupException.sessionXMLValidationException(DEFAULT_SESSION_NAME, this.sessionsXMLName, validationException);
        }
        return serverSession;
    }

    protected static void assignCMP3Policy(Project project) {
        Iterator iterator = project.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            if (descriptor.getCMPPolicy() != null) continue;
            descriptor.setCMPPolicy(new CMP3Policy());
        }
    }

    public ServerSession getServerSession(Map map, ClassLoader classLoader) {
        ServerSession serverSession;
        if (this.deployedSessionName == null) {
            this.sessionName = EntityManagerFactoryProvider.getConfigProperty("toplink.session.name", map);
            this.sessionsXMLName = EntityManagerFactoryProvider.getConfigProperty("ejb30.sessions.xml.name", map);
            serverSession = this.loadSessionFromXML(classLoader);
            EntityManagerSetupImpl.addSessionToGlobalSessionManager(serverSession);
            this.addNamedQueriesToSession(serverSession);
            this.deployedSessionName = serverSession.getName();
        } else {
            serverSession = (ServerSession)SessionManager.getManager().getSession(this.deployedSessionName, false);
        }
        return EntityManagerSetupImpl.updateServerSession(serverSession, map);
    }

    public void undeploy() {
        if (this.deployedSessionName != null) {
            ServerSession serverSession = (ServerSession)SessionManager.getManager().getSessions().remove(this.deployedSessionName);
            if (serverSession != null && serverSession.isConnected()) {
                serverSession.logout();
            }
            this.deployedSessionName = null;
        }
    }

    protected static ServerSession updateServerSession(ServerSession serverSession, Map map) {
        Object object;
        if (serverSession == null || serverSession.isConnected()) {
            return serverSession;
        }
        EntityManagerSetupImpl.assignCMP3Policy(serverSession.getProject());
        String string = EntityManagerFactoryProvider.getConfigProperty("datasource.jndi.name", map);
        DatabaseLogin databaseLogin = serverSession.getLogin();
        if (string != null && !string.equals("")) {
            if (!(databaseLogin.getConnector() instanceof JNDIConnector)) {
                object = new JNDIConnector(string);
                databaseLogin.setConnector((Connector)object);
                databaseLogin.setUsesExternalConnectionPooling(true);
                databaseLogin.setUsesExternalTransactionController(true);
            }
        } else if (databaseLogin.getConnector() instanceof DefaultConnector) {
            object = EntityManagerFactoryProvider.getConfigProperty("jdbc.driver", map);
            String string2 = EntityManagerFactoryProvider.getConfigProperty("jdbc.user", map);
            String string3 = EntityManagerFactoryProvider.getConfigProperty("jdbc.password", map);
            String string4 = EntityManagerFactoryProvider.getConfigProperty("jdbc.connection.string", map);
            if (string2 != null && !string2.equals("")) {
                databaseLogin.setUserName(string2);
            }
            if (string3 != null && !string3.equals("")) {
                databaseLogin.setPassword(string3);
            }
            if (string4 != null && !string4.equals("")) {
                databaseLogin.setConnectionString(string4);
            }
            if (object != null && !((String)object).equals("")) {
                databaseLogin.setDriverClassName((String)object);
            }
        }
        if ((object = EntityManagerFactoryProvider.getConfigProperty("toplink.platform.class.name", map)) != null && !((String)object).equals("")) {
            databaseLogin.setPlatformClassName((String)object);
        }
        if (databaseLogin.shouldUseExternalTransactionController() && serverSession.getServerPlatform() instanceof NoServerPlatform) {
            EntityManagerSetupImpl.assignServerPlatform(serverSession, map);
        }
        return serverSession;
    }

    protected static void assignServerPlatform(ServerSession serverSession, Map map) {
        Object object;
        Object object2;
        String string = EntityManagerFactoryProvider.getConfigProperty("toplink.server.platform.class.name", map);
        if (string == null || string.equals("")) {
            return;
        }
        ServerPlatform serverPlatform = null;
        try {
            object2 = Class.forName(string);
            object = ((Class)object2).getConstructor(class$oracle$toplink$sessions$DatabaseSession == null ? (class$oracle$toplink$sessions$DatabaseSession = EntityManagerSetupImpl.class$("oracle.toplink.sessions.DatabaseSession")) : class$oracle$toplink$sessions$DatabaseSession);
            serverPlatform = (ServerPlatform)((Constructor)object).newInstance(serverSession);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw EntityManagerSetupException.classNotFoundForProperty(string, "toplink.server.platform.class.name", classNotFoundException);
        }
        catch (Exception exception) {
            throw EntityManagerSetupException.failedToInstantiateServerPlatform(string, "toplink.server.platform.class.name", exception);
        }
        if (serverPlatform instanceof CustomServerPlatform) {
            object2 = (CustomServerPlatform)serverPlatform;
            object = EntityManagerFactoryProvider.getConfigProperty("toplink.external.transaction.controller.class.name", map);
            if (object != null && !((String)object).equals("")) {
                try {
                    ((ServerPlatformBase)object2).setExternalTransactionControllerClass(Class.forName((String)object));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw EntityManagerSetupException.classNotFoundForProperty((String)object, "toplink.external.transaction.controller.class.name", classNotFoundException);
                }
            }
        }
        serverSession.setServerPlatform(serverPlatform);
    }

    protected boolean sessionMustBeDefinedInSessionsXML() {
        return true;
    }

    protected static void addSessionToGlobalSessionManager(ServerSession serverSession) {
        Session session = (Session)SessionManager.getManager().getSessions().get(serverSession.getName());
        if (session != null) {
            if (session.isDatabaseSession() && session.isConnected()) {
                ((DatabaseSession)session).logout();
            }
            SessionManager.getManager().getSessions().remove(serverSession.getName());
        }
        SessionManager.getManager().addSession(serverSession);
    }

    protected void addNamedQueriesToSession(ServerSession serverSession) {
        Map map = serverSession.getDescriptors();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            Vector vector = classDescriptor.getQueryManager().getAllQueries();
            for (int i = 0; i < vector.size(); ++i) {
                DatabaseQuery databaseQuery = (DatabaseQuery)vector.get(i);
                if (serverSession.getQuery(databaseQuery.getName()) != null) {
                    throw ValidationException.namedQueryAlreadyExists(databaseQuery.getName());
                }
                serverSession.addQuery(databaseQuery.getName(), databaseQuery);
                serverSession.log(1, "ejb", "named_query_added_to_session", databaseQuery.getName(), serverSession.getName());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

