/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.wls;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.toplink.ejb.DeploymentException;
import oracle.toplink.internal.ejb.cmp.CmpEntityResolver;
import oracle.toplink.internal.ejb.cmp.XMLErrorHandler;
import oracle.toplink.internal.ejb.cmp.api.impl.AbstractCmpDom;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WlsCmpDom
extends AbstractCmpDom {
    public static final String SESSION = "session";
    public static final String PROJECT_ID = "name";
    public static final String PROJECT_FILE = "project-xml";
    public static final String PROJECT_CLASS = "project-class";
    public static final String LOGIN = "login";
    public static final String DATA_SOURCE = "datasource";
    public static final String NON_JTS_DATA_SOURCE = "non-jts-datasource";
    public static final String CONNECTION_POOL = "connection-pool";
    public static final String BIND_ALL_PARAMETERS = "should-bind-all-parameters";
    public static final String BYTE_ARRAY_BINDING = "uses-byte-array-binding";
    public static final String STRING_BINDING = "uses-string-binding";
    public static final String CACHE_SYNCHRONIZATION = "cache-synchronization";
    public static final String IS_ASYNCHRONOUS = "is-asynchronous";
    public static final String REMOVE_CONN_ON_ERROR = "should-remove-connection-on-error";
    public static final String USE_REMOTE_RELATIONSHIPS = "use-remote-relationships";
    public static final String CUSTOMIZATION_CLASS = "customization-class";
    public static final String CMP_DTD_NAME = "toplink-wls-ejb-jar_903.dtd";
    public static final String CMP_DTD_NAME_904 = "toplink-wls-ejb-jar_904.dtd";
    public static final String CMP_DTD_NAME_10 = "toplink-wls-ejb-jar_10_1_3.dtd";
    public static final String TOPLINK_EJB_JAR_FILENAME = "toplink-ejb-jar.xml";
    public static String DOCTYPE_DESC = "-//Oracle Corp.//DTD TopLink 4.0 CMP for WebLogic//EN";
    public static String DOCTYPE_DESC_904 = "-//Oracle Corp.//DTD TopLink CMP WebLogic 9.0.4//EN";
    public static String DOCTYPE_DESC_10 = "-//Oracle Corp.//DTD TopLink CMP WebLogic 10.1.3 Developer Preview//EN";
    protected String connectionPool;
    protected Boolean shouldBindAllParameters;
    protected Boolean shouldUseByteArrayBinding;
    protected Boolean shouldUseStringBinding;
    protected Boolean removeConnectionOnError;

    protected WlsCmpDom() {
    }

    public WlsCmpDom(InputStream inputStream) {
        this.initialize(inputStream);
    }

    public String getConnectionPoolName() {
        return this.connectionPool;
    }

    public Boolean shouldBindAllParameters() {
        return this.shouldBindAllParameters;
    }

    public Boolean shouldUseByteArrayBinding() {
        return this.shouldUseByteArrayBinding;
    }

    public Boolean shouldUseStringBinding() {
        return this.shouldUseStringBinding;
    }

    public Boolean removeConnectionOnError() {
        return this.removeConnectionOnError;
    }

    protected void initialize(InputStream inputStream) {
        Element element = this.loadXMLInput(inputStream);
        Element element2 = this.getFirstElementByTagName(SESSION, element);
        this.sessionName = this.getTextValue(this.getFirstElementByTagName(PROJECT_ID, element2));
        this.projectClass = this.getTextValue(this.getFirstElementByTagName(PROJECT_CLASS, element2));
        this.projectFileName = this.getTextValue(this.getFirstElementByTagName(PROJECT_FILE, element2));
        this.customizationClass = this.getTextValue(this.getFirstElementByTagName(CUSTOMIZATION_CLASS, element2));
        Element element3 = this.getFirstElementByTagName(LOGIN, element2);
        this.projectDataSource = this.getTextValue(this.getFirstElementByTagName(DATA_SOURCE, element3));
        this.nonJtsDataSource = this.getTextValue(this.getFirstElementByTagName(NON_JTS_DATA_SOURCE, element3));
        this.connectionPool = this.getTextValue(this.getFirstElementByTagName(CONNECTION_POOL, element3));
        this.shouldBindAllParameters = this.getBooleanValue(this.getFirstElementByTagName(BIND_ALL_PARAMETERS, element3));
        this.shouldUseByteArrayBinding = this.getBooleanValue(this.getFirstElementByTagName(BYTE_ARRAY_BINDING, element3));
        this.shouldUseStringBinding = this.getBooleanValue(this.getFirstElementByTagName(STRING_BINDING, element3));
        Element element4 = this.getFirstElementByTagName(CACHE_SYNCHRONIZATION, element2);
        this.cacheSyncEnabled = element4 != null;
        this.isAsynchronous = this.getBooleanValue(this.getFirstElementByTagName(IS_ASYNCHRONOUS, element4));
        this.removeConnectionOnError = this.getBooleanValue(this.getFirstElementByTagName(REMOVE_CONN_ON_ERROR, element4));
        this.shouldUseRemoteRelationships = this.getRemoteRelationshipsValue(this.getFirstElementByTagName(USE_REMOTE_RELATIONSHIPS, element2));
    }

    private Element loadXMLInput(InputStream inputStream) {
        if (inputStream == null) {
            throw DeploymentException.noDeploymentDescriptor(TOPLINK_EJB_JAR_FILENAME);
        }
        try {
            Document document = this.getDocumentBuilder().parse(inputStream);
            Element element = document.getDocumentElement();
            inputStream.close();
            return element;
        }
        catch (Exception exception) {
            throw DeploymentException.errorInDeploymentDescriptor(TOPLINK_EJB_JAR_FILENAME, exception);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(this.buildEntityResolver());
        documentBuilder.setErrorHandler(new XMLErrorHandler());
        return documentBuilder;
    }

    private CmpEntityResolver buildEntityResolver() {
        CmpEntityResolver cmpEntityResolver = new CmpEntityResolver();
        this.addLocalDtdResources(cmpEntityResolver);
        return cmpEntityResolver;
    }

    private void addLocalDtdResources(CmpEntityResolver cmpEntityResolver) {
        cmpEntityResolver.addLocalResource(DOCTYPE_DESC, CMP_DTD_NAME);
        cmpEntityResolver.addLocalResource(DOCTYPE_DESC_904, CMP_DTD_NAME_904);
        cmpEntityResolver.addLocalResource(DOCTYPE_DESC_10, CMP_DTD_NAME_10);
    }
}

