/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.finders;

import java.rmi.NoSuchObjectException;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.finders.FinderManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;

public class Finder
implements Cloneable {
    protected String queryName = null;
    protected DatabaseQuery cachedQuery = null;
    protected FinderManager finderManager = null;
    protected boolean local = false;
    protected boolean hasLockQuery = false;
    protected Object inputParams = null;
    protected Object result = null;
    protected DatabaseQuery query = null;
    protected Vector args = null;
    protected Session session = null;

    public Finder(DatabaseQuery databaseQuery, FinderManager finderManager) {
        this.query = databaseQuery;
        this.cachedQuery = databaseQuery;
        this.finderManager = finderManager;
        if (databaseQuery != null) {
            this.queryName = databaseQuery.getName();
            this.checkLockQuery();
        }
    }

    public Object execute(boolean bl, Object object, boolean bl2) throws FinderException, ObjectNotFoundException {
        try {
            return this.internalExecute(bl, object, null, bl2);
        }
        catch (Error error) {
            this.getSession().log(6, "ejb", "an_error_executing_finder", this.getQueryName());
            this.getSession().logThrowable(6, "ejb", error);
            throw error;
        }
        catch (QueryException queryException) {
            if (queryException.getErrorCode() == 6100) {
                throw EJBExceptionFactory.multipleResultsForSingleFinder(this.getBeanName(), this.getQueryName());
            }
            throw queryException;
        }
        catch (TopLinkException topLinkException) {
            this.getSession().logThrowable(6, "ejb", topLinkException);
            throw (FinderException)new FinderException().initCause((Throwable)topLinkException);
        }
        catch (RuntimeException runtimeException) {
            EJBException eJBException = EJBExceptionFactory.errorDuringFind(this.getQueryName(), this.getBeanName(), runtimeException);
            this.getSession().logThrowable(6, "ejb", eJBException);
            throw eJBException;
        }
    }

    public Object executeFindByPk(boolean bl, Object object, boolean bl2) throws ObjectNotFoundException, FinderException {
        throw new UnsupportedOperationException("Developer error - Can only be called for FindByPrimaryKey");
    }

    public Object executeLookup(boolean bl, Object object, Session session) throws NoSuchObjectException {
        throw new UnsupportedOperationException("Developer error - Can only be called for SystemLookupFinder");
    }

    protected Object internalExecute(boolean bl, Object object, Session session, boolean bl2) throws ObjectNotFoundException {
        this.initialize(bl, object, session);
        this.getSession().log(1, "ejb", "executeFinder_query", this.getQueryName(), this.getInputParams());
        if (!this.checkEarlyReturn()) {
            this.prepareQuery(bl2);
            this.prepareSessionOrUow(bl2);
            this.executeQuery();
        }
        this.processResults();
        this.getSession().log(1, "ejb", "executeFinder_finder_execution_results", this.getResult());
        return this.getResult();
    }

    protected void initialize(boolean bl, Object object, Session session) {
        this.local = bl;
        this.inputParams = object;
        this.session = session;
        if (session == null) {
            this.session = this.getFinderManager().getPersistenceManager().getSessionOrUnitOfWork();
        }
        this.prepareArgs();
    }

    protected void prepareArgs() {
        this.args = (Vector)this.inputParams;
    }

    protected boolean checkEarlyReturn() {
        return false;
    }

    protected void executeQuery() {
        this.result = this.getArgs() == null ? this.getSession().executeQuery(this.getQuery()) : this.getSession().executeQuery(this.getQuery(), this.getArgs());
    }

    protected void prepareQuery(boolean bl) {
        if (this.shouldCloneQuery(bl)) {
            this.query = (DatabaseQuery)this.getQuery().clone();
            this.query.setIsExecutionClone(true);
            if (this.hasLockQuery() && bl) {
                ((ObjectLevelReadQuery)this.getQuery()).dontAcquireLocks();
            }
        }
    }

    protected boolean shouldCloneQuery() {
        return false;
    }

    protected boolean shouldCloneQuery(boolean bl) {
        return bl && this.hasLockQuery() || this.shouldCloneQuery();
    }

    protected void prepareSessionOrUow(boolean bl) {
        if (bl || this.getSession().isUnitOfWork()) {
            return;
        }
        if (this.hasLockQuery()) {
            this.session = this.getFinderManager().getPersistenceManager().getUOWManager().getOrCreateActiveUnitOfWork();
        } else if (this.getQuery().isObjectLevelReadQuery() && ((ObjectLevelReadQuery)this.getQuery()).shouldProcessResultsInUnitOfWork()) {
            this.session = this.getFinderManager().getPersistenceManager().getUOWManager().getOrCreateActiveUnitOfWork();
        }
    }

    protected void processResults() throws ObjectNotFoundException {
        this.checkNullResult();
        this.result = this.getFinderManager().wrapFinderResults(this.isLocal(), this.getResult(), this.getSession());
    }

    protected void checkNullResult() throws ObjectNotFoundException {
        if (this.getResult() == null && this.getQuery().getProperty("return null if primary key is null") == null) {
            throw EJBExceptionFactory.objectNotFound(this.getBeanName(), this.getQueryName());
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected FinderManager getFinderManager() {
        return this.finderManager;
    }

    protected String getBeanName() {
        return this.getFinderManager().getBeanName();
    }

    protected String getQueryName() {
        return this.queryName;
    }

    protected DatabaseQuery getQuery() {
        return this.query;
    }

    protected boolean isLocal() {
        return this.local;
    }

    protected boolean hasLockQuery() {
        return this.hasLockQuery;
    }

    protected Session getSession() {
        if (this.session == null) {
            this.session = this.getFinderManager().getPersistenceManager().getSessionOrUnitOfWork();
        }
        return this.session;
    }

    protected Vector getArgs() {
        return this.args;
    }

    protected Object getResult() {
        return this.result;
    }

    protected Object getInputParams() {
        return this.inputParams;
    }

    protected void checkLockQuery() {
        if (this.query != null && this.query.isObjectLevelReadQuery()) {
            this.hasLockQuery = ((ObjectLevelReadQuery)this.getQuery()).isLockQuery(this.getFinderManager().getPersistenceManager().getSession());
        }
    }
}

