/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.codegen;

import java.util.Collection;
import java.util.Iterator;
import oracle.toplink.internal.ejb.cmp.CmpHelper;
import oracle.toplink.internal.ejb.cmp.api.CmrField;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.ejb.cmp.codegen.CMPCodeGenHelper;
import oracle.toplink.internal.ejb.cmp.codegen.CmrCollectionFieldCodeGenerator;
import oracle.toplink.tools.codegen.AccessLevel;
import oracle.toplink.tools.codegen.ClassDefinition;
import oracle.toplink.tools.codegen.MethodDefinition;
import oracle.toplink.tools.codegen.NonreflectiveMethodDefinition;

public class CmrCollectionClassCodeGenerator {
    private CmrCollectionFieldCodeGenerator cmrGenerator;

    public CmrCollectionClassCodeGenerator(CmrCollectionFieldCodeGenerator cmrCollectionFieldCodeGenerator) {
        this.cmrGenerator = cmrCollectionFieldCodeGenerator;
    }

    protected CmrField getCmrField() {
        return this.cmrGenerator.getCmrField();
    }

    protected CmrField getPartnerCmrField(CmrField cmrField) {
        return this.cmrGenerator.getPartnerCmrField(cmrField);
    }

    protected CmrField getPartnerCmrField() {
        return this.cmrGenerator.getPartnerCmrField();
    }

    protected String getCollectionName() {
        return this.cmrGenerator.getCollectionName();
    }

    protected Collection getAllTargetDescriptors() {
        return this.cmrGenerator.getAllTargetDescriptors();
    }

    protected Collection getAllBackpointers() {
        return this.cmrGenerator.getAllBackpointers();
    }

    public void generateCode(ClassDefinition classDefinition) {
        classDefinition.addInnerClass(this.buildCollectionClass());
    }

    protected ClassDefinition buildCollectionClass() {
        ClassDefinition classDefinition = new ClassDefinition();
        classDefinition.setAccessLevel(new AccessLevel(AccessLevel.PUBLIC));
        classDefinition.setSuperClass("CmrCollectionImpl");
        classDefinition.setName(this.getCollectionName());
        classDefinition.addMethod(this.buildConstructor1());
        classDefinition.addMethod(this.buildConstructor2());
        classDefinition.addMethod(this.buildGetAttributeName());
        classDefinition.addMethod(this.buildCheckReadOnlyMethod());
        classDefinition.addMethod(this.buildRelMaintAddRemoveMethod(false));
        classDefinition.addMethod(this.buildRelMaintAddRemoveMethod(true));
        return classDefinition;
    }

    protected MethodDefinition buildConstructor1() {
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName(this.getCollectionName());
        nonreflectiveMethodDefinition.setIsConstructor(true);
        nonreflectiveMethodDefinition.addArgument("int", "initialCapacity");
        nonreflectiveMethodDefinition.addLine("this(null, initialCapacity);");
        return nonreflectiveMethodDefinition;
    }

    protected MethodDefinition buildConstructor2() {
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName(this.getCollectionName());
        nonreflectiveMethodDefinition.setIsConstructor(true);
        nonreflectiveMethodDefinition.addArgument("TopLinkCmpEntity", "newOwner");
        nonreflectiveMethodDefinition.addArgument("int", "initialCapacity");
        nonreflectiveMethodDefinition.addLine("super(newOwner, initialCapacity);");
        if (this.getPartnerCmrField().getEntityDescriptor().usesLocalRelationships()) {
            nonreflectiveMethodDefinition.addLine("collectionType = " + this.getPartnerCmrField().getEntityDescriptor().getLocalInterfaceClass().getName() + ".class;");
        } else {
            nonreflectiveMethodDefinition.addLine("collectionType = " + this.getPartnerCmrField().getEntityDescriptor().getRemoteInterfaceClass().getName() + ".class;");
        }
        return nonreflectiveMethodDefinition;
    }

    protected MethodDefinition buildGetAttributeName() {
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName("getAttributeName");
        nonreflectiveMethodDefinition.setReturnType("String");
        nonreflectiveMethodDefinition.addLine("return \"" + this.getCmrField().getName() + "\";");
        return nonreflectiveMethodDefinition;
    }

    protected MethodDefinition buildCheckReadOnlyMethod() {
        boolean bl;
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName("checkReadOnly");
        nonreflectiveMethodDefinition.addArgument("String", "methodName");
        nonreflectiveMethodDefinition.addLine("if (this.getOwner() != null) {");
        nonreflectiveMethodDefinition.addLine("    PersistenceManagerBase pm = this.getOwner()." + CMPCodeGenHelper.getPMString() + ";");
        nonreflectiveMethodDefinition.addLine("    pm.checkReadOnly(methodName, \"" + this.getCmrField().getName() + "\");");
        if (!(this.getCmrField().getMapping() == null || (bl = this.getPartnerCmrField().isSynthetic()) && this.getCmrField().getMapping().isManyToManyMapping())) {
            nonreflectiveMethodDefinition.addLine("    pm.checkTargetReadOnly(methodName, \"" + this.getCmrField().getName() + "\", \"" + this.getPartnerCmrField().getEntityDescriptor().getBeanName() + "\");");
        }
        nonreflectiveMethodDefinition.addLine("}");
        return nonreflectiveMethodDefinition;
    }

    protected MethodDefinition buildRelMaintAddRemoveMethod(boolean bl) {
        String string = "relMaintAdd";
        String string2 = "ownerWrapped";
        String string3 = "relMaintenanceCollectionAddException";
        if (bl) {
            string = "relMaintRemove";
            string2 = "null";
            string3 = "relMaintenanceCollectionRemoveException";
        }
        String string4 = "newValue";
        String string5 = "Object";
        if (!this.getCmrField().getRoleDescriptor().isMany()) {
            string5 = this.getPartnerCmrField().getType().getName();
        }
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName(string);
        nonreflectiveMethodDefinition.setReturnType("boolean");
        nonreflectiveMethodDefinition.addArgument("Object", string4);
        nonreflectiveMethodDefinition.addLine("try {");
        nonreflectiveMethodDefinition.addLine("// 1. if object already added/removed nothing to do");
        if (bl) {
            nonreflectiveMethodDefinition.addLine("if (this.relationshipMaintenanceCheckAlreadyRemoved(" + string4 + ")) {");
        } else {
            nonreflectiveMethodDefinition.addLine("if (this.relationshipMaintenanceCheckAlreadyAdded(" + string4 + ")) {");
        }
        nonreflectiveMethodDefinition.addLine("    return false;");
        nonreflectiveMethodDefinition.addLine("}");
        nonreflectiveMethodDefinition.addLine("");
        nonreflectiveMethodDefinition.addLine("// 2. add/remove the new value now to avoid infinite loop as we perform rel. maintenance");
        nonreflectiveMethodDefinition.addLine("boolean result = super." + string + "(" + string4 + ");");
        nonreflectiveMethodDefinition.addLine("");
        nonreflectiveMethodDefinition.addLine("// 3. mark dirty and update all references");
        nonreflectiveMethodDefinition.addLine("PersistenceManagerBase pm = this.getOwner()." + CMPCodeGenHelper.getPMString() + ";");
        nonreflectiveMethodDefinition.addLine("UnitOfWork uow = pm.getUOWForRelMaintenance();");
        nonreflectiveMethodDefinition.addLine("pm.getUOWManager().incrementCallDepthIfRequired(uow);");
        nonreflectiveMethodDefinition.addLine("pm.getUOWManager().markObjectForUpdateIfRequired(owner, uow);");
        if (!bl || this.getCmrField().getMapping() == null || !this.getCmrField().getMapping().isPrivateOwned()) {
            nonreflectiveMethodDefinition.addLine("");
            nonreflectiveMethodDefinition.addLine(string5 + " ownerWrapped = " + CMPCodeGenHelper.buildWrapObjectString(string5, "owner"));
            nonreflectiveMethodDefinition.addLine("Object genericNewValueUnwrapped = " + CMPCodeGenHelper.buildUnwrapObjectString("Object", string4));
            Iterator iterator = this.getAllTargetDescriptors().iterator();
            while (iterator.hasNext()) {
                EntityDescriptor entityDescriptor = (EntityDescriptor)iterator.next();
                nonreflectiveMethodDefinition.addLine("if (genericNewValueUnwrapped instanceof " + entityDescriptor.getConcreteBeanClassName() + ") {");
                nonreflectiveMethodDefinition.addLine("    " + entityDescriptor.getConcreteBeanClassName() + " newValueUnwrapped = (" + entityDescriptor.getConcreteBeanClassName() + ")genericNewValueUnwrapped;");
                Iterator iterator2 = this.getAllBackpointers().iterator();
                while (iterator2.hasNext()) {
                    CmrField cmrField = (CmrField)iterator2.next();
                    if (cmrField.getRoleDescriptor().getPartnerRole().isMany()) {
                        nonreflectiveMethodDefinition.addLine("    ((CmrCollection)newValueUnwrapped." + CmpHelper.buildGetterMethodName(cmrField.getName()) + "())." + string + "(ownerWrapped);");
                        continue;
                    }
                    nonreflectiveMethodDefinition.addLine("    newValueUnwrapped." + CMPCodeGenHelper.generateInternalSetMethodName(cmrField.getName()) + "(" + string2 + ");");
                }
                if (iterator.hasNext()) {
                    nonreflectiveMethodDefinition.addLine("} else ");
                    continue;
                }
                nonreflectiveMethodDefinition.addLine("}");
            }
        }
        nonreflectiveMethodDefinition.addLine("pm.getUOWManager().writeChangesIfRequired(uow);");
        nonreflectiveMethodDefinition.addLine("");
        nonreflectiveMethodDefinition.addLine("return result;");
        nonreflectiveMethodDefinition.addLine("} catch (Exception exception) {");
        nonreflectiveMethodDefinition.addLine("    oracle.toplink.logging.AbstractSessionLog.getLog().throwing(exception);");
        nonreflectiveMethodDefinition.addLine("    throw EJBExceptionFactory." + string3 + "(" + string4 + ", \"" + this.getCmrField().getEntityDescriptor().getBeanName() + "." + this.getCmrField().getName() + "\", exception);");
        nonreflectiveMethodDefinition.addLine("}");
        return nonreflectiveMethodDefinition;
    }
}

