/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import oracle.toplink.descriptors.WrapperPolicy;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.ejb.cmp.CmpWrapperPolicy;
import oracle.toplink.internal.ejb.cmp.EJBExceptionFactory;
import oracle.toplink.internal.ejb.cmp.EJBFactory;
import oracle.toplink.internal.ejb.cmp.EntityDescriptorValidator;
import oracle.toplink.internal.ejb.cmp.LifeCycleManager;
import oracle.toplink.internal.ejb.cmp.ProjectDeployment;
import oracle.toplink.internal.ejb.cmp.TopLinkCmpEntity;
import oracle.toplink.internal.ejb.cmp.UOWManager;
import oracle.toplink.internal.ejb.cmp.api.CmpDom;
import oracle.toplink.internal.ejb.cmp.api.CmrField;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.internal.ejb.cmp.api.RelationshipRoleDescriptor;
import oracle.toplink.internal.ejb.cmp.cmr.CmrCollection;
import oracle.toplink.internal.ejb.cmp.codegen.CMPCodeGenHelper;
import oracle.toplink.internal.ejb.cmp.codegen.ConcreteClassGenerator;
import oracle.toplink.internal.ejb.cmp.finders.FinderManager;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ReadAllQuery;

public abstract class PersistenceManagerBase {
    protected boolean usesRemoteRelationships = false;
    protected TopLinkCmpEntity homeBean;
    protected EJBFactory ejbFactory = null;
    protected UOWManager uowManager = null;
    protected FinderManager finderManager = null;
    protected EntityDescriptor entityDescriptor;
    protected ProjectDeployment projectDeployment = null;
    protected Descriptor descriptor = null;
    protected WrapperPolicy localWrapperPolicy = null;
    protected WrapperPolicy remoteWrapperPolicy = null;
    static /* synthetic */ Class class$java$lang$Object;

    public void initialize(CmpDom cmpDom, ClassLoader classLoader, String string, Object object) {
        AbstractSessionLog.getLog().log(1, "PM_initialize_enter", new Object[]{string});
        if (this.getProjectDeployment() == null) {
            ProjectDeployment.setProjectDeploymentClass(this.getProjectDeploymentClass());
            ProjectDeployment projectDeployment = ProjectDeployment.getDeploymentFor(cmpDom.getSessionName());
            projectDeployment.setJarLoader(classLoader);
            projectDeployment.addPersistenceManager(string, this);
            projectDeployment.setCmpDom(cmpDom);
            projectDeployment.convertOldEntityDescriptors(object);
            this.setProjectDeployment(projectDeployment);
            this.setEntityDescriptor((EntityDescriptor)projectDeployment.getEntityDescriptors().get(string));
        } else {
            this.getProjectDeployment().setJarLoader(classLoader);
        }
        AbstractSessionLog.getLog().log(1, "PM_initialize_return", new Object[]{string});
    }

    protected void preDeploy(Object object, Object object2) {
        AbstractSessionLog.getLog().log(1, "PM_preDeploy_enter", new Object[]{this.getBeanName()});
        try {
            this.setEJBFactory(this.createEJBFactory(object, object2));
            this.initializeWrapperPolicies();
            this.validateDescriptors();
            this.getProjectDeployment().deployEJB(this);
        }
        catch (RuntimeException runtimeException) {
            AbstractSessionLog.getLog().log(6, "error_during_PersistenceManager_setup_for_bean", new Object[]{this.getBeanName()});
            AbstractSessionLog.getLog().throwing(runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            AbstractSessionLog.getLog().log(6, "error_during_PersistenceManager_setup_for_bean", new Object[]{this.getBeanName()});
            AbstractSessionLog.getLog().throwing(error);
            throw error;
        }
        AbstractSessionLog.getLog().log(1, "PM_preDeploy_return", new Object[]{this.getBeanName()});
    }

    protected void validateDescriptors() {
        if (this.getEntityDescriptor().getProperties().containsKey("entityDescriptorValidatedFlag")) {
            return;
        }
        new EntityDescriptorValidator().configureAndValidateDescriptors(this.getProjectDeployment().getCmpDom().shouldUseRemoteRelationships(), this.getProjectDeployment().getProject(), this.getEntityDescriptor().getEntityDescriptors());
    }

    protected void postDeploy() {
        AbstractSessionLog.getLog().log(1, "PM_postDeploy_enter", new Object[]{this.getBeanName()});
        this.setUsesRemoteRelationships(this.getProjectDeployment().getCmpDom().shouldUseRemoteRelationships());
        this.setDescriptor(this.getSession().getDescriptor(this.getEntityDescriptor().getConcreteBeanClass()));
        this.setFinderManager(new FinderManager(this));
        this.getDescriptor().getCMPPolicy().setLifeCycleListener(this.createLifeCycleManager());
        this.setUOWManager(UOWManager.getOrCreateManager(this.getSessionName(), this.getSession()));
        AbstractSessionLog.getLog().log(1, "PM_postDeploy_return", new Object[]{this.getBeanName()});
    }

    protected abstract EJBFactory createEJBFactory(Object var1, Object var2);

    protected abstract LifeCycleManager createLifeCycleManager();

    protected abstract Class getProjectDeploymentClass();

    public void generateBeanSubclass(Writer writer) {
        AbstractSessionLog.getLog().log(1, "generateBeanSubclass_call", new Object[]{this.getBeanName()});
        AbstractSessionLog.getLog().log(1, "remote_and_local_homes", new Object[]{this.getEntityDescriptor().getHomeInterfaceClass(), this.getEntityDescriptor().getLocalHomeInterfaceClass()});
        try {
            this.validateDescriptors();
            ConcreteClassGenerator concreteClassGenerator = this.buildConcreteClassGenerator();
            concreteClassGenerator.generateConcreteClass(writer);
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().warning("error_in_codegen");
            AbstractSessionLog.getLog().throwing(exception);
            throw EJBExceptionFactory.errorDuringCodeGen(exception);
        }
        AbstractSessionLog.getLog().log(1, "generateBeanSubclass_return", new Object[]{this.getEntityDescriptor().getConcreteBeanClassName()});
    }

    protected abstract ConcreteClassGenerator buildConcreteClassGenerator();

    protected boolean isInTransaction() {
        return true;
    }

    protected boolean checkForExistence(UnitOfWork unitOfWork, Object object) {
        Object object2 = unitOfWork.checkExistence(object);
        if (object2 != null && unitOfWork != null && unitOfWork.shouldPerformDeletesFirst()) {
            Vector vector = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
            if (unitOfWork.getDeletedObjects().contains(vector)) {
                object2 = null;
            }
        }
        return object2 != null;
    }

    protected void assignSequenceNumbers(UnitOfWork unitOfWork, EntityBean entityBean) {
        try {
            if (this.shouldAssignSequenceNumbers(entityBean)) {
                unitOfWork.assignSequenceNumber(entityBean);
            }
        }
        catch (RuntimeException runtimeException) {
            throw EJBExceptionFactory.errorAssigningSequences(this.getBeanName(), runtimeException);
        }
    }

    protected boolean shouldAssignSequenceNumbers(Object object) {
        return this.getDescriptor().usesSequenceNumbers() && !this.getSession().getSequencing().shouldAcquireValueAfterInsert(object.getClass());
    }

    protected void updateRelationshipsOnRemove(Object object, UnitOfWork unitOfWork) throws RemoveException {
        CmrField cmrField;
        Object object2;
        Iterator iterator = this.getDescriptor().getMappings().iterator();
        HashMap hashMap = new HashMap(this.getEntityDescriptor().getCmrFields());
        while (iterator.hasNext()) {
            object2 = (DatabaseMapping)iterator.next();
            try {
                cmrField = (CmrField)hashMap.remove(((DatabaseMapping)object2).getAttributeName());
                if (!((DatabaseMapping)object2).isForeignReferenceMapping() || cmrField == null) continue;
                if (((DatabaseMapping)object2).isPrivateOwned() || cmrField.getRoleDescriptor().getPartnerRole().isCascadeDelete()) {
                    this.cascadeDeleteToPrivateOwned(object, (DatabaseMapping)object2, unitOfWork);
                    continue;
                }
                this.nullOutPartnerReferences(object, (DatabaseMapping)object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                EJBException eJBException = EJBExceptionFactory.errorPerformingRelMaintenance(this.getBeanName(), ((DatabaseMapping)object2).getAttributeName(), illegalAccessException);
                AbstractSessionLog.getLog().logThrowable(6, eJBException);
                throw eJBException;
            }
            catch (InvocationTargetException invocationTargetException) {
                EJBException eJBException = EJBExceptionFactory.errorPerformingRelMaintenance(this.getBeanName(), ((DatabaseMapping)object2).getAttributeName(), invocationTargetException);
                AbstractSessionLog.getLog().logThrowable(6, eJBException);
                throw eJBException;
            }
        }
        object2 = hashMap.values().iterator();
        while (object2.hasNext()) {
            cmrField = (CmrField)object2.next();
            try {
                this.updateSyntheticOneToManyOnRemove(object, cmrField, unitOfWork);
            }
            catch (IllegalAccessException illegalAccessException) {
                EJBException eJBException = EJBExceptionFactory.errorPerformingRelMaintenance(this.getBeanName(), cmrField.getName(), illegalAccessException);
                AbstractSessionLog.getLog().logThrowable(6, eJBException);
                throw eJBException;
            }
            catch (InvocationTargetException invocationTargetException) {
                EJBException eJBException = EJBExceptionFactory.errorPerformingRelMaintenance(this.getBeanName(), cmrField.getName(), invocationTargetException);
                AbstractSessionLog.getLog().logThrowable(6, eJBException);
                throw eJBException;
            }
        }
    }

    protected void nullOutPartnerReferences(Object object, DatabaseMapping databaseMapping) throws IllegalAccessException, InvocationTargetException {
        if (databaseMapping.isObjectReferenceMapping()) {
            Class[] classArray = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = PersistenceManagerBase.class$("java.lang.Object")) : class$java$lang$Object};
            Object[] objectArray = new Object[]{null};
            try {
                Method method = PrivilegedAccessController.getMethod(object.getClass(), CMPCodeGenHelper.generateInternalSetMethodName(databaseMapping.getAttributeName()), classArray, false);
                PrivilegedAccessController.invokeMethod(method, object, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                AbstractSessionLog.getLog().logThrowable(6, noSuchMethodException);
            }
        } else if (databaseMapping.isCollectionMapping()) {
            CmrCollection cmrCollection = (CmrCollection)databaseMapping.getRealCollectionAttributeValueFromObject(object, this.getSessionOrUnitOfWork());
            cmrCollection.setOwner((TopLinkCmpEntity)object);
            cmrCollection.clear();
        }
    }

    protected void updateSyntheticOneToManyOnRemove(Object object, CmrField cmrField, UnitOfWork unitOfWork) throws IllegalAccessException, InvocationTargetException, RemoveException {
        RelationshipRoleDescriptor relationshipRoleDescriptor = cmrField.getRoleDescriptor().getPartnerRole();
        DatabaseMapping databaseMapping = relationshipRoleDescriptor.getCmrField().getMapping();
        Class clazz = databaseMapping.getDescriptor().getJavaClass();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = expressionBuilder.get(databaseMapping.getAttributeName()).equal(object);
        ReadAllQuery readAllQuery = new ReadAllQuery(clazz, expression);
        readAllQuery.setShouldUseWrapperPolicy(relationshipRoleDescriptor.isCascadeDelete());
        readAllQuery.conformResultsInUnitOfWork();
        Collection collection = (Collection)unitOfWork.executeQuery(readAllQuery);
        Iterator iterator = collection.iterator();
        if (relationshipRoleDescriptor.isCascadeDelete()) {
            if (this.usesRemoteRelationships()) {
                try {
                    while (iterator.hasNext()) {
                        ((EJBObject)iterator.next()).remove();
                    }
                }
                catch (RemoteException remoteException) {
                    throw EJBExceptionFactory.errorCascadingDelete(this.getBeanName(), cmrField.getName(), remoteException);
                }
            } else {
                while (iterator.hasNext()) {
                    ((EJBLocalObject)iterator.next()).remove();
                }
            }
        } else {
            while (iterator.hasNext()) {
                this.nullOutPartnerReferences(iterator.next(), databaseMapping);
            }
        }
    }

    protected void cascadeDeleteToPrivateOwned(Object object, DatabaseMapping databaseMapping, UnitOfWork unitOfWork) throws RemoveException {
        Object object2 = databaseMapping.getAttributeValueFromObject(object);
        if (object2 instanceof ValueHolderInterface) {
            object2 = ((ValueHolderInterface)object2).getValue();
        }
        try {
            ObjectBuilder objectBuilder = databaseMapping.getReferenceDescriptor().getObjectBuilder();
            if (object2 != null && databaseMapping.isObjectReferenceMapping()) {
                if (!unitOfWork.isObjectDeleted(objectBuilder.unwrapObject(object2, unitOfWork))) {
                    if (this.usesRemoteRelationships()) {
                        ((EJBObject)object2).remove();
                    } else {
                        ((EJBLocalObject)object2).remove();
                    }
                }
            } else if (databaseMapping.isCollectionMapping() && object2 != null) {
                boolean bl = this.usesRemoteRelationships();
                Collection collection = (Collection)object2;
                Iterator iterator = new ArrayList(collection).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (unitOfWork.isObjectDeleted(objectBuilder.unwrapObject(e, unitOfWork))) continue;
                    if (bl) {
                        ((EJBObject)e).remove();
                        continue;
                    }
                    ((EJBLocalObject)e).remove();
                }
            }
        }
        catch (RemoteException remoteException) {
            throw EJBExceptionFactory.errorCascadingDelete(this.getBeanName(), databaseMapping.getAttributeName(), remoteException);
        }
    }

    public boolean usesRemoteRelationships() {
        return this.usesRemoteRelationships;
    }

    protected void setUsesRemoteRelationships(boolean bl) {
        this.usesRemoteRelationships = bl;
    }

    public Object ejbSelect(boolean bl, Class clazz, String string, Vector vector) throws FinderException {
        return this.getFinderManager().ejbSelect(bl, clazz, string, vector);
    }

    public Session getSession() {
        return this.getProjectDeployment().getSession();
    }

    public Session getSessionOrUnitOfWork() {
        UnitOfWork unitOfWork = this.getUOWManager().getActiveUnitOfWork();
        if (unitOfWork == null) {
            return this.getSession();
        }
        return unitOfWork;
    }

    protected TopLinkCmpEntity getHomeBean() {
        if (this.homeBean == null) {
            this.homeBean = this.getEJBFactory().createBean();
            this.getEJBFactory().allocateContextIfRequired(this.homeBean, (EJBObject)null);
        }
        return this.homeBean;
    }

    public Object getReadOnlyClone(Object object, Session session) {
        return object;
    }

    public ProjectDeployment getProjectDeployment() {
        return this.projectDeployment;
    }

    protected void setProjectDeployment(ProjectDeployment projectDeployment) {
        this.projectDeployment = projectDeployment;
    }

    public String getBeanName() {
        return this.getEntityDescriptor().getBeanName();
    }

    protected String getSessionName() {
        return this.getProjectDeployment().getSessionName();
    }

    public boolean isEJB20() {
        return this.getEntityDescriptor().isEJB20();
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public void setEntityDescriptor(EntityDescriptor entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
    }

    public FinderManager getFinderManager() {
        return this.finderManager;
    }

    protected void setFinderManager(FinderManager finderManager) {
        this.finderManager = finderManager;
    }

    public EJBFactory getEJBFactory() {
        return this.ejbFactory;
    }

    protected void setEJBFactory(EJBFactory eJBFactory) {
        this.ejbFactory = eJBFactory;
    }

    public UOWManager getUOWManager() {
        return this.uowManager;
    }

    protected void setUOWManager(UOWManager uOWManager) {
        this.uowManager = uOWManager;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public WrapperPolicy getLocalWrapperPolicy() {
        return this.localWrapperPolicy;
    }

    protected void setLocalWrapperPolicy(WrapperPolicy wrapperPolicy) {
        this.localWrapperPolicy = wrapperPolicy;
    }

    public WrapperPolicy getRemoteWrapperPolicy() {
        return this.remoteWrapperPolicy;
    }

    protected void setRemoteWrapperPolicy(WrapperPolicy wrapperPolicy) {
        this.remoteWrapperPolicy = wrapperPolicy;
    }

    protected void initializeWrapperPolicies() {
        EntityDescriptor entityDescriptor = this.getEntityDescriptor();
        if (entityDescriptor.getLocalImplClass() != null) {
            this.setLocalWrapperPolicy(this.createWrapperPolicy(false));
        }
        if (entityDescriptor.getRemoteImplClass() != null) {
            this.setRemoteWrapperPolicy(this.createWrapperPolicy(true));
        }
    }

    protected CmpWrapperPolicy createWrapperPolicy(boolean bl) {
        return new CmpWrapperPolicy(this.getEntityDescriptor(), this.getEJBFactory(), bl);
    }

    public void setCollectionAttribute(Collection collection, Collection arrayList) {
        if (arrayList == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("argument_collection_was_null"));
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList instanceof CmrCollection || arrayList == collection) {
            arrayList2 = new ArrayList(arrayList);
        }
        collection.clear();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EJBObject) && !(e instanceof EJBLocalObject)) {
                collection.add(this.mergeNonBeanAttribute(e));
                continue;
            }
            collection.add(e);
        }
    }

    public void setBeanAttribute(ValueHolderInterface valueHolderInterface, Object object) {
        valueHolderInterface.setValue(object);
    }

    public Object mergeNonBeanAttribute(Object object) {
        if (object == null || this.getSessionOrUnitOfWork().getDescriptor(object) == null) {
            return object;
        }
        UnitOfWork unitOfWork = this.getUOWManager().getOrCreateActiveUnitOfWork();
        if (this.checkForExistence(unitOfWork, object)) {
            return unitOfWork.mergeCloneWithReferences(object);
        }
        return object;
    }

    public UnitOfWork getUOWForRelMaintenance() {
        try {
            return (UnitOfWork)this.getSessionOrUnitOfWork();
        }
        catch (ClassCastException classCastException) {
            throw EJBExceptionFactory.modifyingRelNeedsTxException();
        }
    }

    public void checkIfParameterRemoved(Object object, String string) {
    }

    public void checkReadOnly(String string) {
    }

    public void checkReadOnly(String string, String string2) {
    }

    public void checkTargetReadOnly(String string, String string2) {
    }

    public void checkTargetReadOnly(String string, String string2, String string3) {
    }

    public void copyInto(PersistenceManagerBase persistenceManagerBase) {
        persistenceManagerBase.usesRemoteRelationships = this.usesRemoteRelationships;
        persistenceManagerBase.homeBean = this.homeBean;
        persistenceManagerBase.ejbFactory = this.ejbFactory;
        persistenceManagerBase.uowManager = this.uowManager;
        persistenceManagerBase.finderManager = this.finderManager;
        persistenceManagerBase.entityDescriptor = this.entityDescriptor;
        persistenceManagerBase.projectDeployment = this.projectDeployment;
        persistenceManagerBase.descriptor = this.descriptor;
        persistenceManagerBase.localWrapperPolicy = this.localWrapperPolicy;
        persistenceManagerBase.remoteWrapperPolicy = this.remoteWrapperPolicy;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

