/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import java.rmi.RemoteException;
import java.util.Vector;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import oracle.toplink.descriptors.WrapperPolicy;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.ejb.cmp.EJBFactory;
import oracle.toplink.internal.ejb.cmp.TopLinkCmpEntity;
import oracle.toplink.internal.ejb.cmp.api.EntityDescriptor;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.ReadObjectQuery;

public class CmpWrapperPolicy
implements WrapperPolicy {
    protected boolean isRemote;
    protected Class concreteClass;
    protected Descriptor descriptor;
    protected EJBFactory ejbFactory = null;

    protected CmpWrapperPolicy() {
    }

    public CmpWrapperPolicy(EntityDescriptor entityDescriptor, EJBFactory eJBFactory, boolean bl) {
        this.isRemote = bl;
        this.setEJBFactory(eJBFactory);
        this.setConcreteClass(entityDescriptor.getConcreteBeanClass());
    }

    protected EJBFactory getEJBFactory() {
        return this.ejbFactory;
    }

    public Class getConcreteClass() {
        return this.concreteClass;
    }

    protected void setEJBFactory(EJBFactory eJBFactory) {
        this.ejbFactory = eJBFactory;
    }

    public void setConcreteClass(Class clazz) {
        this.concreteClass = clazz;
    }

    public boolean isTraversable() {
        return false;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void initialize(Session session) {
    }

    public boolean isWrapped(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass() == this.getConcreteClass()) {
            return false;
        }
        return !(object instanceof TopLinkCmpEntity);
    }

    protected Object getPrimaryKey(Object object) throws RemoteException {
        if (object instanceof EJBObject) {
            return ((EJBObject)object).getPrimaryKey();
        }
        return ((EJBLocalObject)object).getPrimaryKey();
    }

    public Object unwrapObject(Object object, Session session) {
        if (object == null || !this.isWrapped(object)) {
            return object;
        }
        session.startOperationProfile("wrapping");
        Object object2 = this.getCachedObjectFromWrapper(object);
        Vector vector = null;
        if (object2 == null) {
            try {
                vector = this.getEJBFactory().createPkVectorFromKey(this.getPrimaryKey(object));
            }
            catch (Exception exception) {
                return session.handleException(ValidationException.ejbContainerExceptionRaised(exception));
            }
            object2 = session.getIdentityMapAccessorInstance().getFromIdentityMap(vector, this.getDescriptor().getJavaClass());
            if (object2 == null) {
                ReadObjectQuery readObjectQuery = new ReadObjectQuery();
                readObjectQuery.setShouldUseWrapperPolicy(false);
                readObjectQuery.setReferenceClass(this.getDescriptor().getJavaClass());
                readObjectQuery.setSelectionKey(vector);
                object2 = session.executeQuery(readObjectQuery);
                if (object2 == null) {
                    throw OptimisticLockException.unwrappingObjectDeletedSinceLastRead(vector, this.getDescriptor().getJavaClassName());
                }
            }
        }
        session.endOperationProfile("wrapping");
        return object2;
    }

    protected Object getCachedObjectFromWrapper(Object object) {
        return null;
    }

    public Object wrapObject(Object object, Session session) {
        if (this.isWrapped(object)) {
            return object;
        }
        if (this.getDescriptor() != null && this.getDescriptor().shouldBeReadOnly()) {
            this.getEJBFactory().setPKInReadOnlyBean((TopLinkCmpEntity)object);
        }
        if (this.isRemote) {
            return this.wrapObjectRemote((TopLinkCmpEntity)object, session);
        }
        return this.wrapObjectLocal((TopLinkCmpEntity)object, session);
    }

    protected Object wrapObjectRemote(TopLinkCmpEntity topLinkCmpEntity, Session session) {
        EJBObject eJBObject = this.getEJBFactory().getEJBObjectFor(topLinkCmpEntity);
        if (eJBObject == null) {
            eJBObject = this.getEJBFactory().allocateEJBObject(this.buildPrimaryKey(topLinkCmpEntity), topLinkCmpEntity);
        }
        return eJBObject;
    }

    protected Object wrapObjectLocal(TopLinkCmpEntity topLinkCmpEntity, Session session) {
        EJBLocalObject eJBLocalObject = this.getEJBFactory().getEJBLocalObjectFor(topLinkCmpEntity);
        if (eJBLocalObject == null) {
            eJBLocalObject = this.getEJBFactory().allocateEJBLocalObject(this.buildPrimaryKey(topLinkCmpEntity), topLinkCmpEntity);
        }
        return eJBLocalObject;
    }

    protected Object buildPrimaryKey(TopLinkCmpEntity topLinkCmpEntity) {
        return this.getEJBFactory().createKeyUsingBean(topLinkCmpEntity);
    }
}

