/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp;

import javax.transaction.TransactionManager;
import oracle.toplink.Version;
import oracle.toplink.ejb.cmp.SessionAccessor;
import oracle.toplink.internal.ejb.cmp.CmpHelper;
import oracle.toplink.internal.ejb.cmp.SessionAccessorHelper;
import oracle.toplink.internal.ejb.cmp.finders.CollectionFactory;
import oracle.toplink.internal.ejb.cmp.finders.CollectionFactoryHelper;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.logging.DefaultSessionLog;
import oracle.toplink.logging.JavaLog;
import oracle.toplink.logging.SessionLog;
import oracle.toplink.platform.server.ServerLog;
import oracle.toplink.sessions.DatasourceLogin;

public abstract class CmpEnvironment {
    protected static final String TOPLINK_HOME_DIR = "toplink.home";
    protected static final String TOPLINK_LOG_DESTINATION = "toplink.log.destination";
    protected static final String TOPLINK_LOG_LEVEL = "toplink.log.level";
    public static final String TOPLINK_UOW_CHANGE_POLICY = "toplink.changePolicy";
    public static final String TOPLINK_CTS_COLLECTION_CHECK_PARAMETERS = "toplink.cts.collection.checkParameters";
    public static final String TOPLINK_CTS_COLLECTION_CHECK_TRANSACTION = "toplink.cts.collection.checkTransaction";
    public static final String TOPLINK_CTS_CHECK_MULTIPLE_ROWS = "toplink.cts.checkMultipleRows";
    public static final String TOPLINK_CONSOLE_DEST = "SYSOUT";
    public static final String TOPLINK_SERVER_DEST = "SERVER";
    public static final String TOPLINK_JAVA_DEST = "JAVA";
    public static final String TOPLINK_LOG_NONE = "NONE";
    public static final String TOPLINK_LOG_ERROR = "ERROR";
    public static final String TOPLINK_LOG_WARNING = "WARNING";
    public static final String TOPLINK_LOG_INFO = "INFO";
    public static final String TOPLINK_LOG_CONFIG = "CONFIG";
    public static final String TOPLINK_LOG_FINE = "FINE";
    public static final String TOPLINK_LOG_FINER = "FINER";
    public static final String TOPLINK_LOG_FINEST = "FINEST";
    public static final String TOPLINK_LOG_DEBUG = "DEBUG";
    public static final String TOPLINK_LOG_ALL = "ALL";
    public static final String TOPLINK_UOW_CHANGE_TRACKCHANGES = "TRACKCHANGES";
    public static final String TOPLINK_UOW_CHANGE_DEFER = "DEFER";
    public static CmpEnvironment env;
    public static final String UNKNOWN_PK_CLASS_FIELD_NAME = "tl_unknown_pk";
    public static final Class UNKNOWN_PK_CLASS_FIELD_TYPE;
    public static final String DEFAULTMAPPING_TABLE_GEN_SETTING = "toplink.defaultmapping.dbTableGenSetting";
    public static final String DEFAULTMAPPING_USE_EXTENDED_TABLE_NAME = "toplink.defaultmapping.useExtendedTableNames";
    public static final String MIGRATIONTOOL_GENERATE_WORKBENCH_PROJECT = "toplink.migrationtool.generateWorkbenchProject";
    public static final String MIGRATIONTOOL_GENERATE_PROJECT_CLASS = "toplink.migrationtool.generateProjectClass";
    protected int logLevel = -1;
    protected Boolean shouldCheckCollectionParameters = null;
    protected Boolean shouldCheckCollectionTransaction = null;
    protected Boolean shouldCheckMultipleRows = null;
    protected TransactionManager transactionManager = null;

    public static CmpEnvironment getEnv() {
        return env;
    }

    public static void initializeEnv(CmpEnvironment cmpEnvironment) {
        cmpEnvironment.initialize();
        env = cmpEnvironment;
    }

    public void initialize() {
        Version.setProduct(this.getProductLabel());
        DatasourceLogin.versionString = null;
        SessionAccessor.setAccessorHelper(this.getSessionAccessorHelper());
        this.initializeLog();
        CollectionFactory.setHelper(this.getCollectionFactoryHelper());
    }

    public TransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = (TransactionManager)CmpHelper.getFromJndi(this.getTransactionManagerJndiName());
        }
        return this.transactionManager;
    }

    protected abstract String getTransactionManagerJndiName();

    public abstract String getProductLabel();

    protected void initializeLog() {
        AbstractSessionLog.setLog(this.getNewLog());
        AbstractSessionLog.getLog().setLevel(this.getLogLevel());
    }

    protected SessionLog getNewLog() {
        String string = this.getTopLinkLogDestination();
        if (string == null || string.equalsIgnoreCase(TOPLINK_CONSOLE_DEST)) {
            return new DefaultSessionLog();
        }
        if (string.equalsIgnoreCase(TOPLINK_SERVER_DEST)) {
            return this.newOutputLog();
        }
        if (string.equalsIgnoreCase(TOPLINK_JAVA_DEST)) {
            return new JavaLog();
        }
        DefaultSessionLog defaultSessionLog = new DefaultSessionLog();
        defaultSessionLog.setWriter(string);
        return defaultSessionLog;
    }

    protected int getLogLevel() {
        if (this.logLevel == -1) {
            String string = this.getTopLinkLogLevel();
            if (string == null || string.equalsIgnoreCase(TOPLINK_LOG_WARNING)) {
                this.logLevel = 6;
            } else if (string.equalsIgnoreCase(TOPLINK_LOG_INFO)) {
                this.logLevel = 5;
            } else if (string.equalsIgnoreCase(TOPLINK_LOG_ERROR)) {
                this.logLevel = 7;
            } else if (string.equalsIgnoreCase(TOPLINK_LOG_DEBUG) || string.equalsIgnoreCase(TOPLINK_LOG_FINEST)) {
                this.logLevel = 1;
            } else if (string.equalsIgnoreCase(TOPLINK_LOG_FINER)) {
                this.logLevel = 2;
            } else if (string.equalsIgnoreCase(TOPLINK_LOG_FINE)) {
                this.logLevel = 3;
            } else if (string.equalsIgnoreCase(TOPLINK_LOG_NONE)) {
                this.logLevel = 8;
            } else if (string.equalsIgnoreCase(TOPLINK_LOG_ALL)) {
                this.logLevel = 0;
            }
        }
        return this.logLevel;
    }

    protected SessionLog newOutputLog() {
        return new ServerLog();
    }

    public String getTopLinkHomeDir() {
        return System.getProperty(TOPLINK_HOME_DIR);
    }

    public String getTopLinkLogDestination() {
        return System.getProperty(TOPLINK_LOG_DESTINATION);
    }

    public String getTopLinkLogLevel() {
        return System.getProperty(TOPLINK_LOG_LEVEL);
    }

    protected abstract SessionAccessorHelper getSessionAccessorHelper();

    public boolean shouldUOWTrackChanges() {
        return System.getProperty(TOPLINK_UOW_CHANGE_POLICY, TOPLINK_UOW_CHANGE_TRACKCHANGES).equalsIgnoreCase(TOPLINK_UOW_CHANGE_TRACKCHANGES);
    }

    protected CollectionFactoryHelper getCollectionFactoryHelper() {
        return new CollectionFactoryHelper();
    }

    public boolean shouldCheckCollectionParameters() {
        if (this.shouldCheckCollectionParameters == null) {
            this.shouldCheckCollectionParameters = new Boolean(System.getProperty(TOPLINK_CTS_COLLECTION_CHECK_PARAMETERS, "false").equalsIgnoreCase("true"));
        }
        return this.shouldCheckCollectionParameters;
    }

    public boolean shouldCheckCollectionTransaction() {
        if (this.shouldCheckCollectionTransaction == null) {
            this.shouldCheckCollectionTransaction = new Boolean(System.getProperty(TOPLINK_CTS_COLLECTION_CHECK_TRANSACTION, "false").equalsIgnoreCase("true"));
        }
        return this.shouldCheckCollectionTransaction;
    }

    public boolean shouldCheckMultipleRows() {
        if (this.shouldCheckMultipleRows == null) {
            this.shouldCheckMultipleRows = new Boolean(System.getProperty(TOPLINK_CTS_CHECK_MULTIPLE_ROWS, "false").equalsIgnoreCase("true"));
        }
        return this.shouldCheckMultipleRows;
    }

    static {
        UNKNOWN_PK_CLASS_FIELD_TYPE = ClassConstants.BIGDECIMAL;
    }
}

