/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.internal.databaseaccess.BatchWritingMechanism;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.ModifyQuery;

public class ParameterizedSQLBatchWritingMechanism
implements BatchWritingMechanism {
    protected DatabaseAccessor databaseAccessor;
    protected DatabaseCall previousCall;
    protected ArrayList parameters;
    protected DatabaseCall lastCallAppended;
    protected int executionCount;
    protected int statementCount;

    public ParameterizedSQLBatchWritingMechanism(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
        this.parameters = new ArrayList(10);
    }

    public void appendCall(Session session, DatabaseCall databaseCall) {
        if (databaseCall.hasParameters()) {
            if (this.previousCall == null) {
                this.previousCall = databaseCall;
                this.parameters.add(databaseCall.getParameters());
            } else if (this.previousCall.getSQLString().equals(databaseCall.getSQLString()) && this.parameters.size() < this.databaseAccessor.getLogin().getPlatform().getMaxBatchWritingSize()) {
                this.parameters.add(databaseCall.getParameters());
            } else {
                this.executeBatchedStatements(session);
                this.appendCall(session, databaseCall);
            }
            this.lastCallAppended = databaseCall;
            if (((ModifyQuery)databaseCall.getQuery()).forceBatchStatementExecution()) {
                this.executeBatchedStatements(session);
            }
        } else {
            this.executeBatchedStatements(session);
            this.switchMechanisms(session, databaseCall);
        }
    }

    public void clear() {
        this.previousCall = null;
        this.parameters.clear();
        this.executionCount = 0;
        this.statementCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatchedStatements(Session session) {
        Object object;
        if (this.parameters.isEmpty()) {
            return;
        }
        session.log(2, "sql", "begin_batch_statements", null, this.databaseAccessor);
        if (session.shouldLog(3, "sql")) {
            session.log(3, "sql", this.previousCall.getSQLString(), null, this.databaseAccessor, false);
            object = this.parameters.iterator();
            while (object.hasNext()) {
                StringWriter stringWriter = new StringWriter();
                DatabaseCall.appendLogParameters((Collection)object.next(), this.databaseAccessor, stringWriter, session);
                session.log(3, "sql", stringWriter.toString(), null, this.databaseAccessor, false);
            }
        }
        session.log(2, "sql", "end_batch_statements", null, this.databaseAccessor);
        try {
            this.databaseAccessor.incrementCallCount(session);
            object = this.prepareBatchStatements(session);
            this.executionCount += this.databaseAccessor.executeJDK12BatchStatement((Statement)object, this.lastCallAppended, session, true);
            if (this.previousCall.hasOptimisticLock() && this.executionCount != this.statementCount) {
                throw OptimisticLockException.batchStatementExecutionFailure();
            }
        }
        finally {
            this.clear();
        }
    }

    protected void switchMechanisms(Session session, DatabaseCall databaseCall) {
        this.databaseAccessor.setActiveBatchWritingMechanismToDynamicSQL();
        this.databaseAccessor.getActiveBatchWritingMechanism().appendCall(session, databaseCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement prepareBatchStatements(Session session) throws DatabaseException {
        PreparedStatement preparedStatement = null;
        try {
            session.startOperationProfile("sql prepare");
            try {
                boolean bl = session.getPlatform().usesNativeBatchWriting();
                preparedStatement = (PreparedStatement)this.databaseAccessor.prepareStatement(this.previousCall, session, bl);
                this.databaseAccessor.getPlatform().prepareBatchStatement(preparedStatement);
                for (int i = 0; i < this.parameters.size(); ++i) {
                    Vector vector = (Vector)this.parameters.get(i);
                    for (int j = 0; j < vector.size(); ++j) {
                        session.getPlatform().setParameterValueInDatabaseCall(vector, preparedStatement, j, session);
                    }
                    ++this.statementCount;
                    this.executionCount += this.databaseAccessor.getPlatform().addBatch(preparedStatement);
                }
            }
            finally {
                session.endOperationProfile("sql prepare");
            }
        }
        catch (SQLException sQLException) {
            try {
                this.databaseAccessor.closeStatement(preparedStatement, session);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw DatabaseException.sqlException(sQLException, this.databaseAccessor, session);
        }
        catch (RuntimeException runtimeException) {
            try {
                this.databaseAccessor.closeStatement(preparedStatement, session);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw runtimeException;
        }
        return preparedStatement;
    }

    public void setAccessor(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }
}

