/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.IOException;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.ValueReadQuery;
import oracle.toplink.sequencing.DefaultSequence;
import oracle.toplink.sequencing.QuerySequence;
import oracle.toplink.sequencing.Sequence;

public class DatasourcePlatform
implements Platform {
    protected String tableQualifier = "";
    protected transient ConversionManager conversionManager;
    protected ValueReadQuery timestampQuery;
    protected transient Map platformOperators;
    protected Hashtable dataTypesConvertedFromAClass;
    protected Hashtable dataTypesConvertedToAClass;
    protected Sequence defaultSequence;
    protected Map sequences;

    protected void addOperator(ExpressionOperator expressionOperator) {
        this.platformOperators.put(new Integer(expressionOperator.getSelector()), expressionOperator);
    }

    public void appendParameter(Call call, Writer writer, Object object) {
        String string = (String)this.getConversionManager().convertObject(object, ClassConstants.STRING);
        if (string == null) {
            string = "";
        }
        try {
            writer.write(string);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public Object getCustomModifyValueForCall(Call call, Object object, DatabaseField databaseField, boolean bl) {
        return object;
    }

    public boolean shouldUseCustomModifyForCall(DatabaseField databaseField) {
        return false;
    }

    public Object clone() {
        try {
            DatasourcePlatform datasourcePlatform = (DatasourcePlatform)super.clone();
            datasourcePlatform.sequencesAfterCloneCleanup();
            return datasourcePlatform;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void sequencesAfterCloneCleanup() {
        Sequence sequence = null;
        if (this.hasDefaultSequence()) {
            sequence = (Sequence)this.getDefaultSequence().clone();
            this.setDefaultSequence(sequence);
        }
        HashMap<String, Sequence> hashMap = null;
        if (this.getSequences() != null) {
            hashMap = new HashMap<String, Sequence>(this.getSequences().size());
            Iterator iterator = this.getSequences().values().iterator();
            while (iterator.hasNext()) {
                Sequence sequence2 = (Sequence)iterator.next();
                if (sequence != null && sequence2 == this.getDefaultSequence()) {
                    hashMap.put(sequence.getName(), sequence);
                    continue;
                }
                Sequence sequence3 = (Sequence)sequence2.clone();
                if (sequence3 instanceof DefaultSequence && !((DefaultSequence)sequence3).hasPreallocationSize()) continue;
                hashMap.put(sequence3.getName(), sequence3);
            }
            this.setSequences(hashMap);
        }
    }

    public Object convertObject(Object object, Class clazz) throws ConversionException {
        return this.getConversionManager().convertObject(object, clazz);
    }

    public void copyInto(Platform platform) {
        if (!(platform instanceof DatasourcePlatform)) {
            return;
        }
        DatasourcePlatform datasourcePlatform = (DatasourcePlatform)platform;
        datasourcePlatform.setTableQualifier(this.getTableQualifier());
        datasourcePlatform.setTimestampQuery(this.timestampQuery);
        datasourcePlatform.setConversionManager(this.getConversionManager());
        if (this.hasDefaultSequence()) {
            datasourcePlatform.setDefaultSequence(this.getDefaultSequence());
        }
        datasourcePlatform.setSequences(this.getSequences());
    }

    public ConversionManager getConversionManager() {
        if (this.conversionManager == null) {
            this.conversionManager = (ConversionManager)ConversionManager.getDefaultManager().clone();
        }
        return this.conversionManager;
    }

    public void setConversionManager(ConversionManager conversionManager) {
        this.conversionManager = conversionManager;
    }

    public ExpressionOperator getOperator(int n) {
        return (ExpressionOperator)this.getPlatformOperators().get(new Integer(n));
    }

    public synchronized Map getPlatformOperators() {
        if (this.platformOperators == null) {
            this.initializePlatformOperators();
        }
        return this.platformOperators;
    }

    public ValueReadQuery getSelectSequenceQuery() {
        if (this.getDefaultSequence() instanceof QuerySequence) {
            return ((QuerySequence)this.getDefaultSequence()).getSelectQuery();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getSelectQuery");
    }

    public int getSequencePreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public String getTableQualifier() {
        return this.tableQualifier;
    }

    public Timestamp getTimestampFromServer(Session session, String string) {
        if (this.getTimestampQuery() == null) {
            return new Timestamp(System.currentTimeMillis());
        }
        this.getTimestampQuery().setSessionName(string);
        return (Timestamp)session.executeQuery(this.getTimestampQuery());
    }

    public ValueReadQuery getTimestampQuery() {
        return this.timestampQuery;
    }

    public DataModifyQuery getUpdateSequenceQuery() {
        if (this.getDefaultSequence() instanceof QuerySequence) {
            return ((QuerySequence)this.getDefaultSequence()).getUpdateQuery();
        }
        throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "getUpdateQuery");
    }

    protected void initializePlatformOperators() {
        this.platformOperators = new HashMap();
        this.addOperator(ExpressionOperator.equalOuterJoin());
        this.addOperator(ExpressionOperator.toUpperCase());
        this.addOperator(ExpressionOperator.toLowerCase());
        this.addOperator(ExpressionOperator.chr());
        this.addOperator(ExpressionOperator.concat());
        this.addOperator(ExpressionOperator.hexToRaw());
        this.addOperator(ExpressionOperator.initcap());
        this.addOperator(ExpressionOperator.instring());
        this.addOperator(ExpressionOperator.soundex());
        this.addOperator(ExpressionOperator.leftPad());
        this.addOperator(ExpressionOperator.leftTrim());
        this.addOperator(ExpressionOperator.replace());
        this.addOperator(ExpressionOperator.rightPad());
        this.addOperator(ExpressionOperator.rightTrim());
        this.addOperator(ExpressionOperator.rightTrim2());
        this.addOperator(ExpressionOperator.substring());
        this.addOperator(ExpressionOperator.toNumber());
        this.addOperator(ExpressionOperator.toChar());
        this.addOperator(ExpressionOperator.toCharWithFormat());
        this.addOperator(ExpressionOperator.translate());
        this.addOperator(ExpressionOperator.trim());
        this.addOperator(ExpressionOperator.ascii());
        this.addOperator(ExpressionOperator.length());
        this.addOperator(ExpressionOperator.locate());
        this.addOperator(ExpressionOperator.locate2());
        this.addOperator(ExpressionOperator.addMonths());
        this.addOperator(ExpressionOperator.dateToString());
        this.addOperator(ExpressionOperator.lastDay());
        this.addOperator(ExpressionOperator.monthsBetween());
        this.addOperator(ExpressionOperator.nextDay());
        this.addOperator(ExpressionOperator.roundDate());
        this.addOperator(ExpressionOperator.toDate());
        this.addOperator(ExpressionOperator.today());
        this.addOperator(ExpressionOperator.simpleMath(78, "+"));
        this.addOperator(ExpressionOperator.simpleMath(79, "-"));
        this.addOperator(ExpressionOperator.simpleMath(81, "*"));
        this.addOperator(ExpressionOperator.simpleMath(80, "/"));
        this.addOperator(ExpressionOperator.ceil());
        this.addOperator(ExpressionOperator.cos());
        this.addOperator(ExpressionOperator.cosh());
        this.addOperator(ExpressionOperator.abs());
        this.addOperator(ExpressionOperator.acos());
        this.addOperator(ExpressionOperator.asin());
        this.addOperator(ExpressionOperator.atan());
        this.addOperator(ExpressionOperator.exp());
        this.addOperator(ExpressionOperator.sqrt());
        this.addOperator(ExpressionOperator.floor());
        this.addOperator(ExpressionOperator.ln());
        this.addOperator(ExpressionOperator.log());
        this.addOperator(ExpressionOperator.mod());
        this.addOperator(ExpressionOperator.power());
        this.addOperator(ExpressionOperator.round());
        this.addOperator(ExpressionOperator.sign());
        this.addOperator(ExpressionOperator.sin());
        this.addOperator(ExpressionOperator.sinh());
        this.addOperator(ExpressionOperator.tan());
        this.addOperator(ExpressionOperator.tanh());
        this.addOperator(ExpressionOperator.trunc());
        this.addOperator(ExpressionOperator.greatest());
        this.addOperator(ExpressionOperator.least());
        this.addOperator(ExpressionOperator.deref());
        this.addOperator(ExpressionOperator.ref());
        this.addOperator(ExpressionOperator.refToHex());
        this.addOperator(ExpressionOperator.value());
    }

    public boolean isAccess() {
        return false;
    }

    public boolean isAttunity() {
        return false;
    }

    public boolean isCloudscape() {
        return false;
    }

    public boolean isDB2() {
        return false;
    }

    public boolean isDBase() {
        return false;
    }

    public boolean isHSQL() {
        return false;
    }

    public boolean isInformix() {
        return false;
    }

    public boolean isMySQL() {
        return false;
    }

    public boolean isODBC() {
        return false;
    }

    public boolean isOracle() {
        return false;
    }

    public boolean isPointBase() {
        return false;
    }

    public boolean isSQLAnywhere() {
        return false;
    }

    public boolean isSQLServer() {
        return false;
    }

    public boolean isSybase() {
        return false;
    }

    public boolean isTimesTen() {
        return false;
    }

    public void setSelectSequenceNumberQuery(ValueReadQuery valueReadQuery) {
        if (!(this.getDefaultSequence() instanceof QuerySequence)) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setSelectQuery");
        }
        ((QuerySequence)this.getDefaultSequence()).setSelectQuery(valueReadQuery);
    }

    public void setSequencePreallocationSize(int n) {
        this.getDefaultSequence().setPreallocationSize(n);
    }

    public void setTableQualifier(String string) {
        this.tableQualifier = string;
    }

    public void setTimestampQuery(ValueReadQuery valueReadQuery) {
        this.timestampQuery = valueReadQuery;
    }

    public void setUpdateSequenceQuery(DataModifyQuery dataModifyQuery) {
        if (!(this.getDefaultSequence() instanceof QuerySequence)) {
            throw ValidationException.wrongSequenceType(Helper.getShortClassName(this.getDefaultSequence()), "setUpdateQuery");
        }
        ((QuerySequence)this.getDefaultSequence()).setUpdateQuery(dataModifyQuery);
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass());
    }

    public Vector getDataTypesConvertedFrom(Class clazz) {
        return this.getConversionManager().getDataTypesConvertedFrom(clazz);
    }

    public Vector getDataTypesConvertedTo(Class clazz) {
        return this.getConversionManager().getDataTypesConvertedTo(clazz);
    }

    public Sequence getDefaultSequence() {
        if (!this.hasDefaultSequence()) {
            this.setDefaultSequence(this.createPlatformDefaultSequence());
        }
        return this.defaultSequence;
    }

    public boolean hasDefaultSequence() {
        return this.defaultSequence != null;
    }

    public void setDefaultSequence(Sequence sequence) {
        if (sequence instanceof DefaultSequence) {
            Sequence sequence2 = this.createPlatformDefaultSequence();
            if (sequence2 != null) {
                sequence2.setName(sequence.getName());
                if (((DefaultSequence)sequence).hasPreallocationSize()) {
                    sequence2.setPreallocationSize(sequence.getPreallocationSize());
                }
            }
            this.defaultSequence = sequence2;
        } else {
            this.defaultSequence = sequence;
        }
    }

    public void addSequence(Sequence sequence) {
        if (this.getSequences() == null) {
            this.createSequences();
        }
        this.getSequences().put(sequence.getName(), sequence);
    }

    public Sequence getSequence(String string) {
        if (string == null) {
            return this.getDefaultSequence();
        }
        if (this.getSequences() != null) {
            return (Sequence)this.getSequences().get(string);
        }
        return null;
    }

    protected Sequence createPlatformDefaultSequence() {
        throw ValidationException.createPlatformDefaultSequenceUndefined(Helper.getShortClassName(this));
    }

    protected synchronized void createSequences() {
        if (this.getSequences() == null) {
            this.setSequences(new HashMap());
        }
    }

    public Sequence removeSequence(String string) {
        if (this.getSequences() != null) {
            return (Sequence)this.getSequences().remove(string);
        }
        return null;
    }

    public void removeAllSequences() {
        this.sequences = null;
    }

    public Map getSequences() {
        return this.sequences;
    }

    public Map getSequencesToWrite() {
        if (this.getSequences() == null || this.getSequences().isEmpty()) {
            return null;
        }
        HashMap<String, Sequence> hashMap = new HashMap<String, Sequence>();
        Iterator iterator = this.getSequences().values().iterator();
        while (iterator.hasNext()) {
            Sequence sequence = (Sequence)iterator.next();
            if (sequence instanceof DefaultSequence && !((DefaultSequence)sequence).hasPreallocationSize()) continue;
            hashMap.put(sequence.getName(), sequence);
        }
        return hashMap;
    }

    public Sequence getDefaultSequenceToWrite() {
        if (this.usesPlatformDefaultSequence()) {
            return null;
        }
        return this.getDefaultSequence();
    }

    public void setSequences(Map map) {
        this.sequences = map;
    }

    public boolean usesPlatformDefaultSequence() {
        if (!this.hasDefaultSequence()) {
            return true;
        }
        return this.getDefaultSequence().equals(this.createPlatformDefaultSequence());
    }

    public String getIdentifierQuoteCharacter() {
        return "";
    }
}

