/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.annotations;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import oracle.toplink.descriptors.DescriptorEvent;
import oracle.toplink.descriptors.DescriptorEventAdapter;
import oracle.toplink.exceptions.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBListener
extends DescriptorEventAdapter {
    public static final String PRE_UPDATE_WITH_CHANGES = "preUpdateWithChanges";
    public static final String POST_CLONE = "postClone";
    public static final String POST_DELETE = "postDelete";
    public static final String POST_INSERT = "postInsert";
    public static final String POST_UPDATE = "postUpdate";
    public static final String PRE_PERSIST = "prePersist";
    public static final String PRE_REMOVE = "preRemove";
    protected Object m_listener;
    private Hashtable<String, HashSet<Method>> m_methods = new Hashtable();

    protected CBListener() {
    }

    public CBListener(Class clazz) {
        this();
        try {
            this.m_listener = clazz.newInstance();
        }
        catch (Exception exception) {
            ValidationException.errorInstantiatingEntityListener(clazz, exception);
        }
    }

    public void addEventMethod(String string, Method method) {
        if (!this.m_methods.contains(string)) {
            this.m_methods.put(string, new HashSet());
        }
        this.m_methods.get(string).add(method);
    }

    public Class getListenerClass() {
        return this.m_listener.getClass();
    }

    public boolean hasCallbackMethods() {
        return this.m_methods.size() > 0;
    }

    protected void invokeMethods(HashSet<Method> hashSet, DescriptorEvent descriptorEvent) {
        if (hashSet != null) {
            for (Method method : hashSet) {
                try {
                    Object[] objectArray = new Object[]{descriptorEvent.getSource()};
                    method.invoke(this.m_listener, objectArray);
                }
                catch (Exception exception) {
                    throw ValidationException.invalidCallbackMethod(this.m_listener.getClass(), method.toString());
                }
            }
        }
    }

    @Override
    public void postClone(DescriptorEvent descriptorEvent) {
        this.invokeMethods(this.m_methods.get(POST_CLONE), descriptorEvent);
    }

    @Override
    public void postDelete(DescriptorEvent descriptorEvent) {
        this.invokeMethods(this.m_methods.get(POST_DELETE), descriptorEvent);
    }

    @Override
    public void postInsert(DescriptorEvent descriptorEvent) {
        this.invokeMethods(this.m_methods.get(POST_INSERT), descriptorEvent);
    }

    @Override
    public void postUpdate(DescriptorEvent descriptorEvent) {
        this.invokeMethods(this.m_methods.get(POST_UPDATE), descriptorEvent);
    }

    @Override
    public void prePersist(DescriptorEvent descriptorEvent) {
        this.invokeMethods(this.m_methods.get(PRE_PERSIST), descriptorEvent);
    }

    @Override
    public void preRemove(DescriptorEvent descriptorEvent) {
        this.invokeMethods(this.m_methods.get(PRE_REMOVE), descriptorEvent);
    }

    @Override
    public void preUpdateWithChanges(DescriptorEvent descriptorEvent) {
        this.invokeMethods(this.m_methods.get(PRE_UPDATE_WITH_CHANGES), descriptorEvent);
    }

    public void setPostCloneMethod(Method method) {
        this.validateMethod(method);
        this.addEventMethod(POST_CLONE, method);
    }

    public void setPostDeleteMethod(Method method) {
        this.validateMethod(method);
        this.addEventMethod(POST_DELETE, method);
    }

    public void setPostInsertMethod(Method method) {
        this.validateMethod(method);
        this.addEventMethod(POST_INSERT, method);
    }

    public void setPostUpdateMethod(Method method) {
        this.validateMethod(method);
        this.addEventMethod(POST_UPDATE, method);
    }

    public void setPrePersistMethod(Method method) {
        this.validateMethod(method);
        this.addEventMethod(PRE_PERSIST, method);
    }

    public void setPreRemoveMethod(Method method) {
        this.validateMethod(method);
        this.addEventMethod(PRE_REMOVE, method);
    }

    public void setPreUpdateWithChangesMethod(Method method) {
        this.validateMethod(method);
        this.addEventMethod(PRE_UPDATE_WITH_CHANGES, method);
    }

    protected void validateMethod(Method method) {
        int n = method.getParameterTypes().length;
        if (n != 1 || method.getParameterTypes()[0] != Object.class) {
            throw ValidationException.invalidEntityListenerCallbackMethodArguments(this.m_listener.getClass(), method.getName());
        }
    }
}

