/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.indirection;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.toplink.descriptors.changetracking.CollectionChangeEvent;
import oracle.toplink.descriptors.changetracking.CollectionChangeTracker;
import oracle.toplink.descriptors.changetracking.MapChangeEvent;
import oracle.toplink.indirection.IndirectCollection;
import oracle.toplink.indirection.ValueHolder;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.helper.Helper;

public class IndirectMap
extends Hashtable
implements CollectionChangeTracker,
IndirectCollection {
    protected Hashtable delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    protected int initialCapacity = 11;
    protected float loadFactor = 0.75f;

    public IndirectMap() {
        this(11);
    }

    public IndirectMap(int n) {
        this(n, 0.75f);
    }

    public IndirectMap(int n, float f) {
        super(0);
        this.initialize(n, f);
    }

    public IndirectMap(Map map) {
        super(0);
        this.initialize(map);
    }

    protected Hashtable buildDelegate() {
        return (Hashtable)this.getValueHolder().getValue();
    }

    public synchronized void clear() {
        if (this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                iterator.remove();
                this.raiseRemoveChangeEvent(e, this.get(e));
            }
        } else {
            this.getDelegate().clear();
        }
    }

    public synchronized Object clone() {
        IndirectMap indirectMap = (IndirectMap)super.clone();
        indirectMap.delegate = (Hashtable)this.getDelegate().clone();
        return indirectMap;
    }

    public synchronized boolean contains(Object object) {
        return this.getDelegate().contains(object);
    }

    public synchronized boolean containsKey(Object object) {
        return this.getDelegate().containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.getDelegate().containsValue(object);
    }

    public synchronized Enumeration elements() {
        return this.getDelegate().elements();
    }

    public Set entrySet() {
        return new Set(){
            Set delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().entrySet();
            }

            public int size() {
                return this.delegateSet.size();
            }

            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            public boolean contains(Object object) {
                return this.delegateSet.contains(object);
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Iterator delegateIterator;
                    Object currentObject;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.delegateIterator = this.this$1.delegateSet.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    public void remove() {
                        1.access$000(this.this$1).raiseRemoveChangeEvent(((Map.Entry)this.currentObject).getKey(), ((Map.Entry)this.currentObject).getValue());
                        this.delegateIterator.remove();
                    }
                };
            }

            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            public Object[] toArray(Object[] objectArray) {
                return this.delegateSet.toArray(objectArray);
            }

            public boolean add(Object object) {
                return this.delegateSet.add(object);
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return IndirectMap.this.remove(((Map.Entry)object).getKey()) != null;
            }

            public boolean containsAll(Collection collection) {
                return this.delegateSet.containsAll(collection);
            }

            public boolean addAll(Collection collection) {
                return this.delegateSet.addAll(collection);
            }

            public boolean retainAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = this.delegateSet.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (collection.contains(entry)) continue;
                    iterator.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                    bl = true;
                }
                return bl;
            }

            public boolean removeAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object e = iterator.next();
                    if (!(e instanceof Map.Entry) || (object = IndirectMap.this.remove(((Map.Entry)e).getKey())) == null) continue;
                    bl = true;
                }
                return bl;
            }

            public void clear() {
                IndirectMap.this.clear();
            }

            public boolean equals(Object object) {
                return ((Object)this.delegateSet).equals(object);
            }

            public int hashCode() {
                return ((Object)this.delegateSet).hashCode();
            }

            static /* synthetic */ IndirectMap access$000(1 var0) {
                return var0.IndirectMap.this;
            }
        };
    }

    public synchronized boolean equals(Object object) {
        return this.getDelegate().equals(object);
    }

    public synchronized Object get(Object object) {
        return this.getDelegate().get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getDelegate() {
        if (this.delegate == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    public String getTopLinkAttributeName() {
        return this.attributeName;
    }

    public PropertyChangeListener getTopLinkPropertyChangeListener() {
        return this.changeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Hashtable(this.initialCapacity, this.loadFactor));
                }
            }
        }
        return this.valueHolder;
    }

    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean hasTopLinkPropertyChangeListener() {
        return this.changeListener != null;
    }

    protected void initialize(int n, float f) {
        this.delegate = null;
        this.loadFactor = f;
        this.initialCapacity = n;
        this.valueHolder = null;
    }

    protected void initialize(Map map) {
        this.delegate = null;
        Hashtable hashtable = new Hashtable(map);
        this.valueHolder = new ValueHolder(hashtable);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public synchronized Enumeration keys() {
        return this.getDelegate().keys();
    }

    public Set keySet() {
        return new Set(){
            Set delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().keySet();
            }

            public int size() {
                return this.delegateSet.size();
            }

            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            public boolean contains(Object object) {
                return this.delegateSet.contains(object);
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Iterator delegateIterator;
                    Object currentObject;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.delegateIterator = this.this$1.delegateSet.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    public void remove() {
                        3.access$100(this.this$1).raiseRemoveChangeEvent(this.currentObject, 3.access$100(this.this$1).getDelegate().get(this.currentObject));
                        this.delegateIterator.remove();
                    }
                };
            }

            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            public Object[] toArray(Object[] objectArray) {
                return this.delegateSet.toArray(objectArray);
            }

            public boolean add(Object object) {
                return this.delegateSet.add(object);
            }

            public boolean remove(Object object) {
                return IndirectMap.this.remove(object) != null;
            }

            public boolean containsAll(Collection collection) {
                return this.delegateSet.containsAll(collection);
            }

            public boolean addAll(Collection collection) {
                return this.delegateSet.addAll(collection);
            }

            public boolean retainAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = this.delegateSet.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (collection.contains(e)) continue;
                    iterator.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(e, IndirectMap.this.getDelegate().get(e));
                    bl = true;
                }
                return bl;
            }

            public boolean removeAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (IndirectMap.this.remove(iterator.next()) == null) continue;
                    bl = true;
                }
                return bl;
            }

            public void clear() {
                IndirectMap.this.clear();
            }

            public boolean equals(Object object) {
                return ((Object)this.delegateSet).equals(object);
            }

            public int hashCode() {
                return ((Object)this.delegateSet).hashCode();
            }

            static /* synthetic */ IndirectMap access$100(3 var0) {
                return var0.IndirectMap.this;
            }
        };
    }

    public synchronized Object put(Object object, Object object2) {
        Object object3 = this.getDelegate().put(object, object2);
        if (object3 != null) {
            this.raiseRemoveChangeEvent(object, object3);
        }
        this.raiseAddChangeEvent(object, object2);
        return object3;
    }

    public synchronized void putAll(Map map) {
        if (this.hasTopLinkPropertyChangeListener()) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                this.put(k, map.get(k));
            }
        } else {
            this.getDelegate().putAll(map);
        }
    }

    protected void rehash() {
        throw new InternalError("unsupported");
    }

    protected void raiseAddChangeEvent(Object object, Object object2) {
        if (this.hasTopLinkPropertyChangeListener()) {
            this.getTopLinkPropertyChangeListener().propertyChange(new MapChangeEvent(this, this.getTopLinkAttributeName(), this, object, object2, CollectionChangeEvent.ADD));
        }
    }

    protected void raiseRemoveChangeEvent(Object object, Object object2) {
        if (this.hasTopLinkPropertyChangeListener()) {
            this.getTopLinkPropertyChangeListener().propertyChange(new MapChangeEvent(this, this.getTopLinkAttributeName(), this, object, object2, CollectionChangeEvent.REMOVE));
        }
    }

    public synchronized Object remove(Object object) {
        Object v = this.getDelegate().remove(object);
        if (v != null) {
            this.raiseRemoveChangeEvent(object, v);
        }
        return v;
    }

    public void setTopLinkAttributeName(String string) {
        this.attributeName = string;
    }

    public void setTopLinkPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    public void setValueHolder(ValueHolderInterface valueHolderInterface) {
        this.delegate = null;
        this.valueHolder = valueHolderInterface;
    }

    public int size() {
        return this.getDelegate().size();
    }

    public Collection getRemovedElements() {
        return null;
    }

    public Collection getAddedElements() {
        return null;
    }

    public boolean hasDeferredChanges() {
        return false;
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    public Collection values() {
        return new Collection(){
            protected Collection delegateCollection;
            {
                this.delegateCollection = IndirectMap.this.getDelegate().values();
            }

            public int size() {
                return this.delegateCollection.size();
            }

            public boolean isEmpty() {
                return this.delegateCollection.isEmpty();
            }

            public boolean contains(Object object) {
                return this.delegateCollection.contains(object);
            }

            public Iterator iterator() {
                return new Iterator(this){
                    Iterator delegateIterator;
                    Object currentObject;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                        this.delegateIterator = this.this$1.delegateCollection.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    public void remove() {
                        Iterator<Map.Entry<K, V>> iterator = 5.access$200(this.this$1).getDelegate().entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> entry = iterator.next();
                            if (!entry.getValue().equals(this.currentObject)) continue;
                            5.access$200(this.this$1).raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                        }
                        this.delegateIterator.remove();
                    }
                };
            }

            public Object[] toArray() {
                return this.delegateCollection.toArray();
            }

            public Object[] toArray(Object[] objectArray) {
                return this.delegateCollection.toArray(objectArray);
            }

            public boolean add(Object object) {
                return this.delegateCollection.add(object);
            }

            public boolean remove(Object object) {
                Iterator iterator = IndirectMap.this.getDelegate().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue().equals(object)) {
                        IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                    }
                    return true;
                }
                return false;
            }

            public boolean containsAll(Collection collection) {
                return this.delegateCollection.containsAll(collection);
            }

            public boolean addAll(Collection collection) {
                return this.delegateCollection.addAll(collection);
            }

            public boolean removeAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (!this.remove(iterator.next())) continue;
                    bl = true;
                }
                return bl;
            }

            public boolean retainAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = IndirectMap.this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (collection.contains(entry.getValue())) continue;
                    iterator.remove();
                    bl = true;
                }
                return bl;
            }

            public void clear() {
                IndirectMap.this.clear();
            }

            public boolean equals(Object object) {
                return ((Object)this.delegateCollection).equals(object);
            }

            public int hashCode() {
                return ((Object)this.delegateCollection).hashCode();
            }

            static /* synthetic */ IndirectMap access$200(5 var0) {
                return var0.IndirectMap.this;
            }
        };
    }
}

