/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import oracle.toplink.exceptions.i18n.ExceptionMessageGenerator;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.JavaPlatform;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessions.DatabaseLogin;

public abstract class TopLinkException
extends RuntimeException {
    protected transient Session session;
    protected Throwable internalException;
    protected static Boolean shouldPrintInternalException = null;
    protected String indentationString = "";
    protected int errorCode;
    protected static final String CR = System.getProperty("line.separator");
    protected boolean hasBeenLogged = false;

    public TopLinkException() {
        this("");
    }

    public TopLinkException(String string) {
        super(string);
    }

    public TopLinkException(String string, Throwable throwable) {
        this(string);
        this.setInternalException(throwable);
    }

    protected static String cr() {
        return Helper.cr();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getIndentationString() {
        return this.indentationString;
    }

    public Throwable getInternalException() {
        return this.internalException;
    }

    public String getMessage() {
        StringWriter stringWriter = new StringWriter(100);
        if (this.getInternalException() == null || !super.getMessage().equals(this.getInternalException().toString())) {
            stringWriter.write(TopLinkException.cr());
            stringWriter.write(this.getIndentationString());
            stringWriter.write(ExceptionMessageGenerator.getHeader("DescriptionHeader"));
            stringWriter.write(super.getMessage());
        }
        if (this.getInternalException() != null) {
            stringWriter.write(TopLinkException.cr());
            stringWriter.write(this.getIndentationString());
            stringWriter.write(ExceptionMessageGenerator.getHeader("InternalExceptionHeader"));
            stringWriter.write(this.getInternalException().toString());
            if (this.getInternalException() instanceof InvocationTargetException && ((InvocationTargetException)this.getInternalException()).getTargetException() != null) {
                stringWriter.write(TopLinkException.cr());
                stringWriter.write(this.getIndentationString());
                stringWriter.write(ExceptionMessageGenerator.getHeader("TargetInvocationExceptionHeader"));
                stringWriter.write(((InvocationTargetException)this.getInternalException()).getTargetException().toString());
            }
        }
        return stringWriter.toString();
    }

    public Session getSession() {
        return this.session;
    }

    public boolean hasBeenLogged() {
        return this.hasBeenLogged;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.write(ExceptionMessageGenerator.getHeader("LocalExceptionStackHeader"));
        printWriter.write(TopLinkException.cr());
        super.printStackTrace(printWriter);
        if (this.getInternalException() != null && TopLinkException.shouldPrintInternalException()) {
            printWriter.write(ExceptionMessageGenerator.getHeader("InternalExceptionStackHeader"));
            printWriter.write(TopLinkException.cr());
            this.getInternalException().printStackTrace(printWriter);
            if (this.getInternalException() instanceof InvocationTargetException && ((InvocationTargetException)this.getInternalException()).getTargetException() != null) {
                printWriter.write(ExceptionMessageGenerator.getHeader("TargetInvocationExceptionStackHeader"));
                printWriter.write(TopLinkException.cr());
                ((InvocationTargetException)this.getInternalException()).getTargetException().printStackTrace(printWriter);
            }
        }
        printWriter.flush();
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    public void setHasBeenLogged(boolean bl) {
        this.hasBeenLogged = bl;
    }

    public void setIndentationString(String string) {
        this.indentationString = string;
    }

    public void setInternalException(Throwable throwable) {
        this.internalException = throwable;
        JavaPlatform.setExceptionCause(this, throwable);
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public static void setShouldPrintInternalException(boolean bl) {
        shouldPrintInternalException = new Boolean(bl);
    }

    public static boolean shouldPrintInternalException() {
        if (shouldPrintInternalException == null) {
            shouldPrintInternalException = new Boolean(JavaPlatform.shouldPrintInternalException());
        }
        return shouldPrintInternalException;
    }

    public String toString() {
        return this.getIndentationString() + ExceptionMessageGenerator.getHeader("ExceptionHeader") + this.getErrorCode() + "] (" + DatabaseLogin.getVersion() + "): " + this.getClass().getName() + this.getMessage();
    }
}

