/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ejb.cmp.was;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.persistence.EJSFinder;
import com.ibm.ejs.persistence.EJSJDBCPersister;
import com.ibm.websphere.cpi.PersisterHome;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.sql.DataSource;
import oracle.toplink.Version;
import oracle.toplink.ejb.EJBDataStore;
import oracle.toplink.ejb.EJBWrapperPolicy;
import oracle.toplink.ejb.cmp.was.SessionLookupHelper;
import oracle.toplink.ejb.cmp.was.WSFinderEnumeration;
import oracle.toplink.ejb.cmp.was.WSWrapperPolicy;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.tools.sessionconfiguration.WASXMLSessionConfigLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public abstract class WSDataStore
extends EJSJDBCPersister {
    protected EJBDataStore dataStore = new EJBDataStore();
    public static final String TLWAS_PRODUCT = "TopLink (WAS CMP)";

    public WSDataStore() {
        this("Avoid super constructor");
    }

    protected WSDataStore(String string) {
        this.dataStore.setXMLSessionConfigLoader(new WASXMLSessionConfigLoader());
        this.dataStore.setSessionName("UNINITIALIZED_WAS_CMP_SESSION");
    }

    public void appendVersionString() {
        Version.setProduct(TLWAS_PRODUCT);
        DatabaseLogin.versionString = null;
    }

    public void _create(EntityBean entityBean) throws Exception {
    }

    public void create(EntityBean entityBean) throws Exception {
        this.getDataStore().create(entityBean);
    }

    public EJSFinder findAll() throws RemoteException, FinderException {
        return this.findAll(new ReadAllQuery(this.getBeanClass()));
    }

    public EJSFinder findAll(Expression expression) throws RemoteException, FinderException {
        return this.findAll(new ReadAllQuery(this.getBeanClass(), expression));
    }

    public EJSFinder findAll(Call call) throws RemoteException, FinderException {
        return this.findAll(new ReadAllQuery(this.getBeanClass(), call));
    }

    public EJSFinder findAll(ReadAllQuery readAllQuery) throws RemoteException, FinderException {
        Vector vector = this.getDataStore().findAllObjects(readAllQuery);
        return new WSFinderEnumeration(vector, this);
    }

    public EJSFinder findAllByNamedQuery(String string, Vector vector) throws RemoteException, FinderException {
        Vector vector2 = this.getDataStore().findAllObjectsByNamedQuery(string, vector);
        return new WSFinderEnumeration(vector2, this);
    }

    public Object findByPrimaryKey(Object object) throws RemoteException, FinderException {
        Object object2 = this.getDataStore().getWrapperPolicy().buildBeanFromPrimaryKey(object, this.getDataStore().getSession());
        return this.findOneInternal(new ReadObjectQuery(object2));
    }

    public Object findOneByNamedQueryInternal(String string, Vector vector) throws RemoteException, FinderException {
        Object object = this.getDataStore().findObjectByNamedQuery(string, vector);
        Object object2 = this.getDataStore().getWrapperPolicy().buildPrimaryKeyFromBean(object, this.getDataStore().getSession());
        return this.lookupRemoteForBean(object, object2);
    }

    public Object findOneInternal(Expression expression) throws RemoteException, FinderException {
        return this.findOneInternal(new ReadObjectQuery(this.getBeanClass(), expression));
    }

    public Object findOneInternal(Call call) throws RemoteException, FinderException {
        return this.findOneInternal(new ReadObjectQuery(this.getBeanClass(), call));
    }

    public Object findOneInternal(ReadObjectQuery readObjectQuery) throws RemoteException, FinderException {
        Object object = this.getDataStore().findObject(readObjectQuery);
        Object object2 = this.getDataStore().getWrapperPolicy().buildPrimaryKeyFromBean(object, this.getDataStore().getSession());
        return this.lookupRemoteForBean(object, object2);
    }

    public Class getBeanClass() {
        return this.getDataStore().getBeanClass();
    }

    public EJBDataStore getDataStore() {
        return this.dataStore;
    }

    public EJSHome getEJSHome() {
        return (EJSHome)this.home;
    }

    public PersisterHome getHome() {
        return this.home;
    }

    public Object getPrimaryKey(Object object) throws Exception {
        return object;
    }

    public abstract boolean hasCompoundKey();

    public void hydrate(EntityBean entityBean, Object object, Object object2) throws Exception {
        Session session = this.getDataStore().getActiveSession();
        session.logDebug("EJB#hydrate");
        Object object3 = object;
        if (session.isUnitOfWork()) {
            UnitOfWork unitOfWork = (UnitOfWork)session;
            object3 = unitOfWork.getContainerUnitOfWork().registerExistingObject(object3);
            unitOfWork.getContainerBeans().put(entityBean, object);
        }
        this.getDataStore().getDescriptor().getObjectBuilder().copyInto(object3, entityBean);
    }

    private void initializeSession(BeanMetaData beanMetaData) {
        this.appendVersionString();
        this.setBeanClass(beanMetaData.enterpriseBeanClass);
        DatabaseSession databaseSession = (DatabaseSession)SessionManager.getManager().getWASSession((WASXMLSessionConfigLoader)this.getDataStore().getXMLSessionConfigLoader(), PrivilegedAccessController.getClassLoaderForClass(this.getBeanClass()));
        if (databaseSession == null) {
            throw ValidationException.ejbNoSuchSessionSpecifiedInProperties(this.getDataStore().getSessionName(), this.getBeanClass());
        }
        this.getDataStore().setSessionName(databaseSession.getName());
        if (databaseSession.getLogin().shouldUseExternalConnectionPooling()) {
            JNDIConnector jNDIConnector = new JNDIConnector((DataSource)this.dataSource);
            databaseSession.getLogin().setConnector(jNDIConnector);
            if (this.dbUser != null) {
                databaseSession.getLogin().setUserName(this.dbUser);
            }
            if (this.dbPassword != null) {
                databaseSession.getLogin().setPassword(this.dbPassword);
            }
        }
        if (!databaseSession.isConnected()) {
            databaseSession.logMessage("TopLink session: " + databaseSession.getName());
            databaseSession.login();
        }
        this.initializeDescriptor(beanMetaData);
        SessionLookupHelper.getHelper().mapBeanClassToSession(this.getBeanClass(), databaseSession);
    }

    public void initializeDescriptor(BeanMetaData beanMetaData) {
        Object object;
        Descriptor descriptor = this.getDataStore().getDescriptor();
        if (descriptor == null) {
            throw ValidationException.ejbDescriptorNotFoundInSession(this.getBeanClass(), this.getDataStore().getSessionName());
        }
        WSWrapperPolicy wSWrapperPolicy = new WSWrapperPolicy();
        wSWrapperPolicy.setDataStore(this);
        try {
            wSWrapperPolicy.setRemoteInterface(beanMetaData.remoteInterfaceClass);
            wSWrapperPolicy.setHomeInterface(beanMetaData.homeInterfaceClass);
            wSWrapperPolicy.setPrimaryKeyClass(beanMetaData.pKeyClass);
            wSWrapperPolicy.setHasCustomPrimaryKey(this.hasCompoundKey());
            object = Helper.getShortClassName(beanMetaData.remoteInterfaceClass);
            wSWrapperPolicy.setHomeName((String)object);
            descriptor.setWrapperPolicy(wSWrapperPolicy);
            wSWrapperPolicy.initialize(this.getDataStore().getSession());
        }
        catch (Exception exception) {
            this.getDataStore().getSession().handleException(ValidationException.ejbContainerExceptionRaised(exception));
        }
        object = descriptor.getQueryManager().getAllQueries().elements();
        while (object.hasMoreElements()) {
            DatabaseQuery databaseQuery = (DatabaseQuery)object.nextElement();
            databaseQuery.setShouldUseWrapperPolicy(false);
        }
    }

    public void load(EntityBean entityBean, Object object, boolean bl) throws Exception {
        try {
            this.getDataStore().getWrapperPolicy().dumpPrimaryKeyIntoBean(object, entityBean, this.getDataStore().getSession());
            this.getDataStore().load(entityBean);
        }
        catch (ValidationException validationException) {
            if (validationException.getInternalException() instanceof FinderException) {
                throw (FinderException)validationException.getInternalException();
            }
            throw validationException;
        }
    }

    public Object lookupRemoteForBean(Object object, Object object2) {
        try {
            if (this.getEJSHome() != null && object.getClass() != this.getDataStore().getDescriptor().getJavaClass()) {
                Descriptor descriptor = this.getDataStore().getSession().getDescriptor(object.getClass());
                return this.getEJSHome().getBean(((EJBWrapperPolicy)descriptor.getWrapperPolicy()).getHomeName(), object2, object);
            }
            return this.getHome().getBean(object2, object);
        }
        catch (Exception exception) {
            return this.getDataStore().getSession().handleException(ValidationException.ejbContainerExceptionRaised(exception));
        }
    }

    public void refresh(EntityBean entityBean, boolean bl) throws Exception {
        this.getDataStore().load(entityBean);
    }

    public void remove(EntityBean entityBean) throws Exception {
        this.getDataStore().remove(entityBean);
    }

    public void setBeanClass(Class clazz) {
        this.getDataStore().setBeanClass(clazz);
    }

    public void setDataStore(EJBDataStore eJBDataStore) {
        this.dataStore = eJBDataStore;
    }

    public void setHome(PersisterHome persisterHome) {
        this.setHome((EJSHome)persisterHome);
    }

    public void setHome(EJSHome eJSHome) {
        this.home = eJSHome;
        this.initializeSession(eJSHome.getBeanMetaData(null));
    }

    public void store(EntityBean entityBean) throws Exception {
        this.getDataStore().store(entityBean);
    }
}

