/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.eis.mappings.EISMapping;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ObjectReferenceMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.ReadQuery;

public class EISOneToOneMapping
extends ObjectReferenceMapping
implements EISMapping {
    protected Map sourceToTargetKeyFields;
    protected Map targetToSourceKeyFields;
    protected boolean shouldVerifyDelete;
    protected transient Expression privateOwnedCriteria;

    public EISOneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.sourceToTargetKeyFields = new HashMap(2);
        this.targetToSourceKeyFields = new HashMap(2);
    }

    public boolean isEISMapping() {
        return true;
    }

    public boolean isOneToOneMapping() {
        return true;
    }

    public void addForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getSourceToTargetKeyFields().put(databaseField, databaseField2);
        this.getTargetToSourceKeyFields().put(databaseField2, databaseField);
        this.getForeignKeyFields().add(databaseField);
        this.setIsForeignKeyRelationship(true);
    }

    public void addForeignKeyFieldName(String string, String string2) {
        this.addForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    public Object clone() {
        DatabaseField databaseField;
        DatabaseField databaseField2;
        DatabaseField databaseField3;
        Object object;
        EISOneToOneMapping eISOneToOneMapping = (EISOneToOneMapping)super.clone();
        eISOneToOneMapping.setForeignKeyFields(NonSynchronizedVector.newInstance(this.getForeignKeyFields().size()));
        eISOneToOneMapping.setSourceToTargetKeyFields(new HashMap(this.getSourceToTargetKeyFields().size()));
        eISOneToOneMapping.setTargetToSourceKeyFields(new HashMap(this.getTargetToSourceKeyFields().size()));
        HashMap<Object, DatabaseField> hashMap = new HashMap<Object, DatabaseField>(this.getTargetToSourceKeyFields().size());
        Object object2 = this.getForeignKeyFields().elements();
        while (object2.hasMoreElements()) {
            object = (DatabaseField)object2.nextElement();
            databaseField3 = (DatabaseField)((DatabaseField)object).clone();
            hashMap.put(object, databaseField3);
            eISOneToOneMapping.getForeignKeyFields().addElement(databaseField3);
        }
        object2 = this.getSourceToTargetKeyFields().keySet().iterator();
        while (object2.hasNext()) {
            object = (DatabaseField)object2.next();
            databaseField3 = (DatabaseField)this.getSourceToTargetKeyFields().get(object);
            databaseField2 = (DatabaseField)hashMap.get(databaseField3);
            if (databaseField2 == null) {
                databaseField2 = (DatabaseField)databaseField3.clone();
                hashMap.put(databaseField3, databaseField2);
            }
            if ((databaseField = (DatabaseField)((DatabaseField)object).clone()) == null) {
                databaseField = (DatabaseField)((DatabaseField)object).clone();
                hashMap.put(object, databaseField);
            }
            eISOneToOneMapping.getSourceToTargetKeyFields().put(databaseField, databaseField2);
        }
        object = this.getTargetToSourceKeyFields().keySet().iterator();
        while (object.hasNext()) {
            DatabaseField databaseField4;
            databaseField3 = (DatabaseField)object.next();
            databaseField2 = (DatabaseField)this.getTargetToSourceKeyFields().get(databaseField3);
            databaseField = (DatabaseField)hashMap.get(databaseField3);
            if (databaseField == null) {
                databaseField = (DatabaseField)databaseField3.clone();
                hashMap.put(databaseField3, databaseField);
            }
            if ((databaseField4 = (DatabaseField)hashMap.get(databaseField2)) == null) {
                databaseField4 = (DatabaseField)databaseField2.clone();
                hashMap.put(databaseField2, databaseField4);
            }
            eISOneToOneMapping.getTargetToSourceKeyFields().put(databaseField, databaseField4);
        }
        return eISOneToOneMapping;
    }

    protected Vector extractForeignKeyFromRow(DatabaseRow databaseRow, Session session) {
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            Object object = databaseRow.get(databaseField);
            try {
                object = session.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractKeyFromReferenceObject(Object object, Session session) {
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            if (object == null) {
                vector.addElement(null);
                continue;
            }
            vector.addElement(this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, session));
        }
        return vector;
    }

    public Vector extractPrimaryKeysForReferenceObjectFromRow(DatabaseRow databaseRow) {
        List list = this.getReferenceDescriptor().getPrimaryKeyFields();
        Vector<Object> vector = new Vector<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DatabaseField databaseField = (DatabaseField)list.get(i);
            DatabaseField databaseField2 = (DatabaseField)this.getTargetToSourceKeyFields().get(databaseField);
            if (databaseField2 == null) {
                return new Vector(1);
            }
            vector.addElement(databaseRow.get(databaseField2));
        }
        return vector;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        Enumeration enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            this.getDescriptor().buildField(databaseField);
        }
        this.initializeForeignKeys(session);
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
        } else {
            this.setShouldVerifyDelete(false);
        }
        this.setFields(this.collectFields());
    }

    protected void initializeForeignKeys(Session session) {
        Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        Iterator iterator2 = this.getTargetToSourceKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            DatabaseField databaseField2 = (DatabaseField)iterator2.next();
            this.getDescriptor().buildField(databaseField);
            this.getReferenceDescriptor().buildField(databaseField2);
        }
    }

    protected void initializeSelectionCriteria(Session session) {
        if (this.getSourceToTargetKeyFields().isEmpty()) {
            throw DescriptorException.noForeignKeysAreSpecified(this);
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
            Expression expression = ((Expression)expressionBuilder).getField(databaseField2).equal(expressionBuilder.getParameter(databaseField));
            Expression expression2 = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(expression2);
        }
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        if (objectLevelModifyQuery.getSession().isUnitOfWork()) {
            return this.getRealAttributeValueFromObject(objectLevelModifyQuery.getBackupClone(), objectLevelModifyQuery.getSession());
        }
        if (!this.shouldVerifyDelete()) {
            return null;
        }
        ReadObjectQuery readObjectQuery = (ReadObjectQuery)this.getSelectionQuery().clone();
        readObjectQuery.setSelectionCriteria(this.getPrivateOwnedCriteria());
        return objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)readObjectQuery, objectLevelModifyQuery.getTranslationRow());
    }

    protected void initializePrivateOwnedCriteria() {
        if (!this.isForeignKeyRelationship()) {
            this.setPrivateOwnedCriteria(this.getSelectionCriteria());
        } else {
            Expression expression = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder();
            Expression expression2 = expressionBuilder.getManualQueryKey(this.getAttributeName() + "-back-ref", this.getDescriptor());
            Expression expression3 = expression.rebuildOn(expression2);
            Expression expression4 = expression2.twist(this.getSelectionCriteria(), expressionBuilder);
            if (this.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
                Expression expression5 = this.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(expression2);
                expression4 = expression4 == null ? expression5 : expression4.and(expression5);
            }
            this.setPrivateOwnedCriteria(expression3.and(expression4));
        }
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        Object object;
        if (!objectLevelReadQuery.hasPartialAttributeExpressions()) {
            object = this.getFields().elements();
            while (object.hasMoreElements()) {
                DatabaseField databaseField = (DatabaseField)object.nextElement();
                if (databaseRow.get(databaseField) != null) continue;
                return this.getIndirectionPolicy().nullValueFromRow();
            }
        }
        if (((DatabaseQuery)(object = this.getSelectionQuery())).isObjectLevelReadQuery() && (objectLevelReadQuery.shouldCascadeAllParts() || objectLevelReadQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || objectLevelReadQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
            object = (ObjectLevelReadQuery)((DatabaseQuery)object).clone();
            ((ObjectLevelReadQuery)object).setShouldRefreshIdentityMapResult(objectLevelReadQuery.shouldRefreshIdentityMapResult());
            ((DatabaseQuery)object).setCascadePolicy(objectLevelReadQuery.getCascadePolicy());
            ((ReadQuery)object).setQueryId(objectLevelReadQuery.getQueryId());
            if (((DatabaseQuery)object).shouldMaintainCache()) {
                ((DatabaseQuery)object).setShouldMaintainCache(objectLevelReadQuery.shouldMaintainCache());
            }
        }
        return this.getIndirectionPolicy().valueFromQuery((ReadQuery)object, databaseRow, objectLevelReadQuery.getSession());
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        DatabaseRow databaseRow2 = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (databaseRow2 == null) {
            Object object2 = this.getRealAttributeValueFromObject(object, session);
            for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
                DatabaseField databaseField = (DatabaseField)this.getForeignKeyFields().get(i);
                DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
                Object object3 = null;
                if (object2 != null) {
                    object3 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object2, databaseField2, session);
                }
                databaseRow.add(databaseField, object3);
            }
        } else {
            for (int i = 0; i < this.getForeignKeyFields().size(); ++i) {
                DatabaseField databaseField = (DatabaseField)this.getForeignKeyFields().get(i);
                databaseRow.add(databaseField, databaseRow2.get(databaseField));
            }
        }
    }

    public Class getFieldClassification(DatabaseField databaseField) throws DescriptorException {
        DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
        if (databaseField2 == null) {
            return null;
        }
        DatabaseMapping databaseMapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField2);
        if (databaseMapping == null) {
            return null;
        }
        return databaseMapping.getFieldClassification(databaseField2);
    }

    public Expression getPrivateOwnedCriteria() {
        if (this.privateOwnedCriteria == null) {
            this.initializePrivateOwnedCriteria();
        }
        return this.privateOwnedCriteria;
    }

    protected void setPrivateOwnedCriteria(Expression expression) {
        this.privateOwnedCriteria = expression;
    }

    public void setShouldVerifyDelete(boolean bl) {
        this.shouldVerifyDelete = bl;
    }

    public boolean shouldVerifyDelete() {
        return this.shouldVerifyDelete;
    }

    public Map getSourceToTargetKeyFields() {
        return this.sourceToTargetKeyFields;
    }

    public Map getTargetToSourceKeyFields() {
        return this.targetToSourceKeyFields;
    }

    public void setSourceToTargetKeyFields(Map map) {
        this.sourceToTargetKeyFields = map;
    }

    public void setTargetToSourceKeyFields(Map map) {
        this.targetToSourceKeyFields = map;
    }

    public void setSelectionSQLString(String string) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionSQLString");
    }

    public void setUsesBatchReading(boolean bl) {
        throw DescriptorException.invalidMappingOperation(this, "setUsesBatchReading");
    }

    public boolean shouldUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "shouldUseBatchReading");
    }

    public void useBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "useBatchReading");
    }

    public void dontUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "dontUseBatchReading");
    }

    public void addAscendingOrdering(String string) {
        throw DescriptorException.invalidMappingOperation(this, "addAscendingOrdering");
    }

    public void addDescendingOrdering(String string) {
        throw DescriptorException.invalidMappingOperation(this, "addDescendingOrdering");
    }
}

