/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis.adapters.mqseries;

import com.ibm.mq.jms.MQQueueConnectionFactory;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.resource.cci.Connection;
import oracle.toplink.eis.EISAccessor;
import oracle.toplink.eis.EISException;
import oracle.toplink.eis.adapters.jms.JMSEISConnectionSpec;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.eis.adapters.jms.CciJMSConnectionFactory;
import oracle.toplink.internal.eis.adapters.jms.CciJMSConnectionSpec;

public class MQConnectionSpec
extends JMSEISConnectionSpec {
    public static String TRANSPORT_TYPE = "transport";
    public static String CHANNEL = "channel";
    public static String HOST = "host";
    public static String PORT = "port";
    public static String QUEUE_MANAGER = "manager";

    public Connection connectToDataSource(EISAccessor eISAccessor, Properties properties) throws DatabaseException, ValidationException {
        this.setConnectionFactory(new CciJMSConnectionFactory());
        if (this.getConnectionSpec() == null) {
            MQQueueConnectionFactory mQQueueConnectionFactory;
            CciJMSConnectionSpec cciJMSConnectionSpec = new CciJMSConnectionSpec();
            String string = (String)properties.get(CONNECTION_FACTORY_URL);
            if (string != null) {
                cciJMSConnectionSpec.setConnectionFactoryURL(string);
            }
            if ((mQQueueConnectionFactory = (MQQueueConnectionFactory)properties.get(CONNECTION_FACTORY)) != null) {
                try {
                    mQQueueConnectionFactory.setChannel((String)properties.get(CHANNEL));
                    mQQueueConnectionFactory.setHostName((String)properties.get(HOST));
                    mQQueueConnectionFactory.setQueueManager((String)properties.get(QUEUE_MANAGER));
                    Integer n = (Integer)properties.get(TRANSPORT_TYPE);
                    if (n != null) {
                        mQQueueConnectionFactory.setTransportType(n.intValue());
                    }
                    if ((n = (Integer)properties.get(PORT)) != null) {
                        mQQueueConnectionFactory.setPort(n.intValue());
                    }
                }
                catch (Exception exception) {
                    throw EISException.invalidConnectionFactoryAttributes();
                }
                cciJMSConnectionSpec.setConnectionFactory((ConnectionFactory)mQQueueConnectionFactory);
            }
            this.setConnectionSpec(cciJMSConnectionSpec);
        }
        return super.connectToDataSource(eISAccessor, properties);
    }
}

