/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml.stream;

import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sdk.SDKAccessor;
import oracle.toplink.sdk.SDKFieldValue;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.xml.XMLAccessor;
import oracle.toplink.xml.XMLDataStoreException;
import oracle.toplink.xml.XMLStreamStreamPolicy;
import oracle.toplink.xml.XMLTranslator;
import oracle.toplink.xml.stream.XMLStreamDatabase;
import oracle.toplink.xml.xerces.DefaultXMLTranslator;

public class XMLStreamAccessor
extends SDKAccessor
implements XMLAccessor {
    private XMLStreamDatabase xmlStreamDatabase;
    private XMLStreamStreamPolicy xmlStreamPolicy;
    private XMLTranslator translator = new DefaultXMLTranslator();
    static /* synthetic */ Class class$java$lang$String;

    public void setXMLStreamDatabase(XMLStreamDatabase xMLStreamDatabase) {
        this.xmlStreamDatabase = xMLStreamDatabase;
    }

    public DatabaseRow convert(DatabaseRow databaseRow, Session session) {
        if (databaseRow == null || databaseRow.isEmpty()) {
            return databaseRow;
        }
        DatabaseRecord databaseRecord = new DatabaseRecord(databaseRow.size());
        Enumeration enumeration = databaseRow.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = databaseRow.get(databaseField);
            object = object instanceof SDKFieldValue ? this.convert((SDKFieldValue)object, session) : this.convert(object, class$java$lang$String == null ? XMLStreamAccessor.class$("java.lang.String") : class$java$lang$String, session);
            databaseRecord.put(databaseField, object);
        }
        return databaseRecord;
    }

    protected Object convert(Object object, Class clazz, Session session) {
        return session.getDatasourcePlatform().convertObject(object, clazz);
    }

    protected Object convert(SDKFieldValue sDKFieldValue, Session session) {
        Vector<Object> vector = new Vector<Object>(sDKFieldValue.getElements().size());
        Enumeration enumeration = sDKFieldValue.getElements().elements();
        while (enumeration.hasMoreElements()) {
            Object object = null;
            object = sDKFieldValue.isDirectCollection() ? this.convert(enumeration.nextElement(), class$java$lang$String == null ? XMLStreamAccessor.class$("java.lang.String") : class$java$lang$String, session) : this.convert((DatabaseRow)enumeration.nextElement(), session);
            vector.addElement(object);
        }
        return sDKFieldValue.clone(vector);
    }

    public void createStreamSource(String string) throws XMLDataStoreException {
        this.xmlStreamDatabase.createStreamSource(string);
    }

    public Integer deleteStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        return this.getWriteStreamPolicy(string, databaseRow, vector).deleteStream(string, databaseRow, vector, this);
    }

    public void dropStreamSource(String string) throws XMLDataStoreException {
        this.xmlStreamDatabase.dropStreamSource(string);
    }

    public Reader getExistenceCheckStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        return this.getReadStreamPolicy(string, databaseRow, vector).getExistenceCheckStream(string, databaseRow, vector, this);
    }

    public Writer getExistingWriteStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        return this.getWriteStreamPolicy(string, databaseRow, vector).getExistingWriteStream(string, databaseRow, vector, this);
    }

    public Writer getNewWriteStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        StringWriter stringWriter = (StringWriter)this.getWriteStreamPolicy(string, databaseRow, vector).getNewWriteStream(string, databaseRow, vector, this);
        this.xmlStreamDatabase.putWriter(string, databaseRow, vector, stringWriter);
        return stringWriter;
    }

    public Reader getReadStream(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        return this.getReadStreamPolicy(string, databaseRow, vector).getReadStream(string, databaseRow, vector, this);
    }

    public Enumeration getReadStreams(String string) throws XMLDataStoreException {
        return this.getReadStreamPolicy(string).getReadStreams(string, this);
    }

    public Enumeration getReadStreams(String string, Vector vector, Vector vector2) throws XMLDataStoreException {
        return this.getReadStreamPolicy(string, vector, vector2).getReadStreams(string, vector, vector2, this);
    }

    public XMLTranslator getXMLTranslator() {
        return this.translator;
    }

    public void setXMLTranslator(XMLTranslator xMLTranslator) {
        this.translator = xMLTranslator;
    }

    private XMLStreamStreamPolicy getReadStreamPolicy(String string) {
        Enumeration enumeration = this.xmlStreamDatabase.getReaders(string);
        return new XMLStreamStreamPolicy(enumeration);
    }

    private XMLStreamStreamPolicy getReadStreamPolicy(String string, DatabaseRow databaseRow, Vector vector) {
        Reader reader = this.xmlStreamDatabase.getReader(string, databaseRow, vector);
        return new XMLStreamStreamPolicy(reader);
    }

    private XMLStreamStreamPolicy getReadStreamPolicy(String string, Vector vector, Vector vector2) {
        Enumeration enumeration = this.xmlStreamDatabase.getReaders(string, vector, vector2);
        return new XMLStreamStreamPolicy(enumeration);
    }

    private XMLStreamStreamPolicy getWriteStreamPolicy(String string, DatabaseRow databaseRow, Vector vector) {
        Writer writer = this.xmlStreamDatabase.getWriter(string, databaseRow, vector);
        return new XMLStreamStreamPolicy(writer);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

