/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.xml.XMLFileAccessor;
import oracle.toplink.xml.XMLLogin;

public class XMLFileLogin
extends XMLLogin {
    private String baseDirectoryName;
    private String fileNameExtension;
    private boolean createsDirectoriesAsNeeded;

    public XMLFileLogin() {
    }

    public XMLFileLogin(String string) {
        this();
        this.initialize(string);
    }

    public XMLFileLogin(DatabasePlatform databasePlatform) {
        super(databasePlatform);
    }

    public Accessor buildAccessor() {
        XMLFileAccessor xMLFileAccessor = (XMLFileAccessor)super.buildAccessor();
        xMLFileAccessor.setBaseDirectoryName(this.getBaseDirectoryName());
        xMLFileAccessor.setFileNameExtension(this.getFileNameExtension());
        xMLFileAccessor.setCreatesDirectoriesAsNeeded(this.createsDirectoriesAsNeeded());
        return xMLFileAccessor;
    }

    public void createDirectoriesAsNeeded() {
        this.setCreatesDirectoriesAsNeeded(true);
    }

    public boolean createsDirectoriesAsNeeded() {
        return this.createsDirectoriesAsNeeded;
    }

    public void dontCreateDirectoriesAsNeeded() {
        this.setCreatesDirectoriesAsNeeded(false);
    }

    public String getBaseDirectoryName() {
        return this.baseDirectoryName;
    }

    protected String tempDirectoryName() {
        return Helper.tempDirectory();
    }

    protected Class getDefaultAccessorClass() {
        return ClassConstants.XMLFileAccessor_Class;
    }

    protected String getDefaultFileNameExtension() {
        return ".xml";
    }

    public String getFileNameExtension() {
        return this.fileNameExtension;
    }

    protected void initialize() {
        super.initialize();
        this.baseDirectoryName = this.tempDirectoryName();
        this.fileNameExtension = this.getDefaultFileNameExtension();
        this.createsDirectoriesAsNeeded = false;
    }

    protected void initialize(String string) {
        if (string != null) {
            this.setBaseDirectoryName(string);
        }
    }

    public void setBaseDirectoryName(String string) {
        this.baseDirectoryName = string;
    }

    public void setCreatesDirectoriesAsNeeded(boolean bl) {
        this.createsDirectoriesAsNeeded = bl;
    }

    public void setFileNameExtension(String string) {
        this.fileNameExtension = string;
    }
}

