/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.xml.XMLDataStoreException;

public class JARClassLoader
extends ClassLoader {
    private Hashtable overridePackageNames;

    protected JARClassLoader() {
        this.initialize();
    }

    public JARClassLoader(String[] stringArray) {
        this();
        this.initialize(stringArray);
    }

    public JARClassLoader(String string) {
        this();
        this.initialize(string);
    }

    protected ZipFile buildJARFile(String string) {
        try {
            return new ZipFile(string);
        }
        catch (IOException iOException) {
            throw XMLDataStoreException.ioException(iOException);
        }
    }

    protected String buildPackageName(String string) {
        return string.substring(0, string.lastIndexOf("."));
    }

    protected Class customLoadUnresolvedClass(String string) throws ClassNotFoundException {
        byte[] byArray;
        String string2 = (String)this.overridePackageNames.get(this.buildPackageName(string));
        ZipFile zipFile = this.buildJARFile(string2);
        String string3 = string.replace('.', '/').concat(".class");
        ZipEntry zipEntry = zipFile.getEntry(string3);
        try {
            byArray = this.loadData(zipFile, zipEntry);
            zipFile.close();
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{string2, string3};
            throw new ClassNotFoundException(ExceptionLocalization.buildMessage("error_reading_jar_file", objectArray));
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    protected void extractPackageNames(String string) {
        Enumeration<? extends ZipEntry> enumeration = this.buildJARFile(string).entries();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement().getName();
            int n = string3.lastIndexOf("/");
            if (n == -1 || n == string3.length() - 1 || (string2 = string3.substring(0, n).replace('/', '.')).equals("META-INF")) continue;
            this.overridePackageNames.put(string2, string);
        }
    }

    protected void initialize() {
        this.overridePackageNames = new Hashtable();
    }

    protected void initialize(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_jar_file_names", null));
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            this.extractPackageNames(stringArray[i]);
        }
    }

    protected void initialize(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_jar_file_names", null));
        }
        this.initialize(new String[]{string});
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.loadUnresolvedClass(string);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected byte[] loadData(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        int n = (int)zipEntry.getSize();
        byte[] byArray = new byte[n];
        DataInputStream dataInputStream = new DataInputStream(zipFile.getInputStream(zipEntry));
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        return byArray;
    }

    protected Class loadUnresolvedClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.shouldCustomLoad(string)) {
            return this.customLoadUnresolvedClass(string);
        }
        ClassLoader classLoader = PrivilegedAccessController.getClassLoaderForClass(this.getClass());
        if (classLoader == null) {
            return this.findSystemClass(string);
        }
        return classLoader.loadClass(string);
    }

    protected boolean shouldCustomLoad(String string) {
        return this.overridePackageNames.containsKey(this.buildPackageName(string));
    }
}

