/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.util;

import java.util.Collection;
import java.util.Vector;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.threetier.Server;
import oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public class SessionFactory {
    private String sessionXMLPath;
    private String sessionName;

    public SessionFactory(String string, String string2) {
        this.sessionXMLPath = string;
        this.sessionName = string2;
    }

    public SessionFactory(String string) {
        this.sessionName = string;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getSessionXMLPath() {
        return this.sessionXMLPath;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public DatabaseSession getSharedSession() {
        return this.getSharedSession(true, false);
    }

    public DatabaseSession getSharedSession(boolean bl, boolean bl2) {
        XMLSessionConfigLoader xMLSessionConfigLoader = this.getSessionXMLPath() != null ? new XMLSessionConfigLoader(this.getSessionXMLPath()) : new XMLSessionConfigLoader();
        return (DatabaseSession)((Object)SessionManager.getManager().getSession(xMLSessionConfigLoader, this.getSessionName(), this.getClassLoader(), bl, bl2, true));
    }

    public oracle.toplink.sessions.Session acquireSession() {
        oracle.toplink.sessions.Session session;
        DatabaseSession databaseSession = this.getSharedSession();
        if (databaseSession.hasExternalTransactionController() && (session = databaseSession.getActiveUnitOfWork()) != null) {
            return session.getParent();
        }
        if (databaseSession.isServerSession()) {
            return ((Server)databaseSession).acquireClientSession();
        }
        if (databaseSession.isSessionBroker()) {
            session = (SessionBroker)databaseSession;
            if (((SessionBroker)session).isServerSessionBroker()) {
                return ((SessionBroker)session).acquireClientSessionBroker();
            }
            return session;
        }
        return databaseSession;
    }

    public oracle.toplink.sessions.UnitOfWork acquireUnitOfWork() {
        return this.acquireUnitOfWork(this.getSharedSession());
    }

    public oracle.toplink.sessions.UnitOfWork acquireUnitOfWork(oracle.toplink.sessions.Session session) {
        if (session.hasExternalTransactionController()) {
            return session.getActiveUnitOfWork();
        }
        return session.acquireUnitOfWork();
    }

    public Object detach(Object object) {
        UnitOfWork unitOfWork = ((Session)((Object)this.getSharedSession())).acquireNonSynchronizedUnitOfWork();
        Object object2 = unitOfWork.registerObject(object);
        unitOfWork.release();
        return object2;
    }

    public Collection detach(Collection collection) {
        UnitOfWork unitOfWork = ((Session)((Object)this.getSharedSession())).acquireNonSynchronizedUnitOfWork();
        Vector vector = unitOfWork.registerAllObjects(collection);
        unitOfWork.release();
        return vector;
    }
}

